/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.SecurityContextType;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import com.marklogic.mgmt.cma.ConfigurationManager;
import com.marklogic.mgmt.resource.clusters.ClusterManager;
import com.marklogic.rest.util.RestConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.ResponseErrorHandler;

public class TestConnectionsCommand
extends AbstractCommand {
    public TestConnectionsCommand() {
        this.setExecuteSortOrder(0);
    }

    @Override
    public void execute(CommandContext context) {
        TestResults results = this.testConnections(context);
        if (results.anyTestFailed()) {
            throw new RuntimeException(results.toString());
        }
        this.logger.info(results.toString());
    }

    public TestResults testConnections(CommandContext context) {
        try {
            TestResult manageResult = this.testManageAppServer(context.getManageClient());
            TestResult adminResult = this.testAdminAppServer(context.getAdminManager());
            TestResult appServicesResult = null;
            TestResult restResult = null;
            TestResult testRestResult = null;
            if (manageResult.isSucceeded()) {
                List<Integer> serverPorts = this.getAppServerPorts(context.getManageClient());
                appServicesResult = this.testAppServicesAppServer(context.getAppConfig(), serverPorts);
                restResult = this.testRestAppServer(context.getAppConfig(), serverPorts);
                testRestResult = this.testTestRestAppServer(context.getAppConfig(), serverPorts);
            }
            return new TestResults(manageResult, adminResult, appServicesResult, restResult, testRestResult);
        }
        catch (Exception ex) {
            throw new RuntimeException("Unable to test connections; cause: " + ex.getMessage(), ex);
        }
    }

    private List<Integer> getAppServerPorts(ManageClient manageClient) {
        JsonNode json = (JsonNode)new ConfigurationManager(manageClient).getResourcesAsJson("server").getBody();
        ArrayNode servers = (ArrayNode)json.get("config").get(0).get("server");
        ArrayList<Integer> ports = new ArrayList<Integer>();
        servers.forEach(server -> {
            if (server.has("port")) {
                ports.add(server.get("port").asInt());
            }
        });
        return ports;
    }

    private TestResult testAppServicesAppServer(AppConfig appConfig, List<Integer> serverPorts) {
        if (appConfig.getAppServicesPort() != null && serverPorts.contains(appConfig.getAppServicesPort())) {
            return this.testWithDatabaseClient(appConfig.getHost(), appConfig.getAppServicesPort(), appConfig.getAppServicesSslContext(), appConfig.getAppServicesSecurityContextType(), appConfig.getAppServicesUsername(), () -> appConfig.newAppServicesDatabaseClient(null));
        }
        return null;
    }

    private TestResult testRestAppServer(AppConfig appConfig, List<Integer> serverPorts) {
        if (appConfig.getRestPort() != null && serverPorts.contains(appConfig.getRestPort())) {
            return this.testWithDatabaseClient(appConfig.getHost(), appConfig.getRestPort(), appConfig.getRestSslContext(), appConfig.getRestSecurityContextType(), appConfig.getRestAdminUsername(), appConfig::newDatabaseClient);
        }
        return null;
    }

    private TestResult testTestRestAppServer(AppConfig appConfig, List<Integer> serverPorts) {
        if (appConfig.getTestRestPort() != null && serverPorts.contains(appConfig.getTestRestPort())) {
            return this.testWithDatabaseClient(appConfig.getHost(), appConfig.getTestRestPort(), appConfig.getRestSslContext(), appConfig.getRestSecurityContextType(), appConfig.getRestAdminUsername(), appConfig::newTestDatabaseClient);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult testManageAppServer(ManageClient client) {
        ResponseErrorHandler originalErrorHandler = client.getRestTemplate().getErrorHandler();
        client.getRestTemplate().setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler());
        try {
            String version = new ClusterManager(client).getVersion();
            TestResult testResult = new TestResult(client.getManageConfig(), true, "MarkLogic version: " + version);
            return testResult;
        }
        catch (Exception ex) {
            if (ex instanceof HttpClientErrorException && ((HttpClientErrorException)((Object)ex)).getRawStatusCode() == 404) {
                TestResult testResult = new TestResult(client.getManageConfig(), false, "Unable to access /manage/v2; received 404; unexpected response: " + ex.getMessage());
                return testResult;
            }
            TestResult testResult = new TestResult(client.getManageConfig(), ex);
            return testResult;
        }
        finally {
            client.getRestTemplate().setErrorHandler(originalErrorHandler);
        }
    }

    private TestResult testAdminAppServer(AdminManager adminManager) {
        try {
            String timestamp = adminManager.getServerTimestamp();
            return new TestResult(adminManager.getAdminConfig(), true, "MarkLogic server timestamp: " + timestamp);
        }
        catch (Exception ex) {
            return new TestResult(adminManager.getAdminConfig(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TestResult testWithDatabaseClient(String host, Integer port, SSLContext sslContext, SecurityContextType securityContextType, String username, Supplier<DatabaseClient> supplier) {
        if (port == null) {
            return null;
        }
        String scheme = sslContext != null ? "https" : "http";
        String authType = securityContextType != null ? securityContextType.name().toLowerCase() : "unknown";
        DatabaseClient client = null;
        try {
            client = supplier.get();
            TestResult testResult = new TestResult(host, port, scheme, authType, username, client.checkConnection());
            return testResult;
        }
        catch (Exception ex) {
            TestResult testResult = new TestResult(host, port, scheme, authType, username, false, ex.getMessage());
            return testResult;
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
    }

    public static class TestResult {
        private String host;
        private int port;
        private String scheme;
        private String authType;
        private String username;
        private boolean succeeded;
        private String message;

        public TestResult(RestConfig restConfig, boolean succeeded, String message) {
            this(restConfig.getHost(), restConfig.getPort(), restConfig.getScheme(), restConfig.getAuthType(), restConfig.getUsername(), succeeded, message);
        }

        public TestResult(RestConfig restConfig, Exception ex) {
            this(restConfig, false, ex.getMessage());
        }

        public TestResult(String host, int port, String scheme, String authType, String username, DatabaseClient.ConnectionResult result) {
            this.host = host;
            this.port = port;
            this.scheme = scheme;
            this.authType = authType;
            this.username = username;
            this.succeeded = result.isConnected();
            if (!result.isConnected()) {
                this.message = String.format("Received %d: %s", result.getStatusCode(), result.getErrorMessage());
            }
        }

        public TestResult(String host, int port, String scheme, String authType, String username, boolean succeeded, String message) {
            this.host = host;
            this.port = port;
            this.scheme = scheme;
            this.authType = authType;
            this.username = username;
            this.succeeded = succeeded;
            this.message = message;
        }

        public String getHost() {
            return this.host;
        }

        public int getPort() {
            return this.port;
        }

        public String getScheme() {
            return this.scheme;
        }

        public boolean isSucceeded() {
            return this.succeeded;
        }

        public String getMessage() {
            return this.message;
        }

        public String getAuthType() {
            return this.authType;
        }

        public String getUsername() {
            return this.username;
        }

        public String toString() {
            String result = String.format("Configured to connect to %s://%s:%d using '%s' authentication", this.getScheme(), this.getHost(), this.getPort(), this.getAuthType());
            if (this.getUsername() != null) {
                result = result + String.format(" and username of '%s'", this.getUsername());
            }
            if (this.isSucceeded()) {
                result = result + "\nConnected successfully";
                return this.getMessage() != null ? result + "; " + this.getMessage() : result;
            }
            return result + "\nFAILED TO CONNECT; cause: " + this.message;
        }
    }

    public static class TestResults {
        private TestResult manageTestResult;
        private TestResult adminTestResult;
        private TestResult appServicesTestResult;
        private TestResult restServerTestResult;
        private TestResult testRestServerTestResult;

        public TestResults(TestResult manageTestResult, TestResult adminTestResult, TestResult appServicesTestResult, TestResult restServerTestResult, TestResult testRestServerTestResult) {
            this.manageTestResult = manageTestResult;
            this.adminTestResult = adminTestResult;
            this.appServicesTestResult = appServicesTestResult;
            this.restServerTestResult = restServerTestResult;
            this.testRestServerTestResult = testRestServerTestResult;
        }

        public boolean anyTestFailed() {
            return Stream.of(this.manageTestResult, this.adminTestResult, this.appServicesTestResult, this.restServerTestResult, this.testRestServerTestResult).anyMatch(test -> test != null && !test.isSucceeded());
        }

        public TestResult getManageTestResult() {
            return this.manageTestResult;
        }

        public TestResult getAdminTestResult() {
            return this.adminTestResult;
        }

        public TestResult getAppServicesTestResult() {
            return this.appServicesTestResult;
        }

        public TestResult getRestServerTestResult() {
            return this.restServerTestResult;
        }

        public TestResult getTestRestServerTestResult() {
            return this.testRestServerTestResult;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Manage App Server\n").append(this.getManageTestResult()).append("\n\nAdmin App Server\n").append(this.getAdminTestResult());
            if (this.getManageTestResult().isSucceeded()) {
                if (this.getAppServicesTestResult() != null) {
                    sb.append("\n\nApp-Services App Server\n").append(this.getAppServicesTestResult());
                } else {
                    sb.append("\n\nNo test run for the App-Services App Server as either a port is not configured for it or it has not been deployed yet");
                }
                if (this.getRestServerTestResult() != null) {
                    sb.append("\n\nREST API App Server\n").append(this.getRestServerTestResult());
                } else {
                    sb.append("\n\nNo test run for a REST API App Server as either a port is not configured for it or it has not been deployed yet.");
                }
                if (this.getTestRestServerTestResult() != null) {
                    sb.append("\n\nTest REST API App Server\n").append(this.getTestRestServerTestResult());
                } else {
                    sb.append("\n\nNo test run for a Test REST API App Server as either a port is not configured for it or it has not been deployed yet.");
                }
            } else {
                sb.append("\n\nCould not test connections against the App-Services or REST API App Servers due to the Manage App Server connection failing.");
            }
            return sb.toString();
        }
    }
}

