/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.appdeployer.command;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.PayloadTokenReplacer;
import java.util.Map;

public class DefaultPayloadTokenReplacer
implements PayloadTokenReplacer {
    @Override
    public String replaceTokens(String payload, AppConfig appConfig, boolean isTestResource) {
        payload = this.replaceDefaultTokens(payload, appConfig, isTestResource);
        return this.replaceCustomTokens(payload, appConfig, isTestResource);
    }

    protected String replaceDefaultTokens(String payload, AppConfig appConfig, boolean isTestResource) {
        payload = payload.replace("%%NAME%%", isTestResource ? appConfig.getTestRestServerName() : appConfig.getRestServerName());
        payload = payload.replace("%%GROUP%%", appConfig.getGroupName());
        payload = payload.replace("%%DATABASE%%", isTestResource ? appConfig.getTestContentDatabaseName() : appConfig.getContentDatabaseName());
        payload = payload.replace("%%MODULES_DATABASE%%", appConfig.getModulesDatabaseName());
        payload = payload.replace("%%TRIGGERS_DATABASE%%", appConfig.getTriggersDatabaseName());
        payload = payload.replace("%%SCHEMAS_DATABASE%%", appConfig.getSchemasDatabaseName());
        payload = payload.replace("%%PORT%%", isTestResource ? appConfig.getTestRestPort().toString() : appConfig.getRestPort().toString());
        return payload;
    }

    protected String replaceCustomTokens(String payload, AppConfig appConfig, boolean isTestResource) {
        Map<String, String> customTokens;
        if (payload != null && (customTokens = appConfig.getCustomTokens()) != null) {
            for (String key : customTokens.keySet()) {
                String value;
                if (key == null || (value = customTokens.get(key)) == null) continue;
                payload = payload.replace(key, value);
            }
        }
        return payload;
    }
}

