/**
 Copyright (c) 2021 MarkLogic Corporation

 Licensed under the Apache License, Version 2.0 (the "License");
 you may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 */
'use strict';

import DocPermission from "/data-hub/features/doc-permissions.mjs";
import Mapping from '/data-hub/features/mapping.mjs';
import ProtectedCollections from '/data-hub/features/protected-collections.mjs';
import Provenance from '/data-hub/features/provenance.mjs';
import SchemaValidation from '/data-hub/features/schema-validation.mjs';
import Temporal from '/data-hub/features/temporal.mjs';

// define constants for caching expensive operations
const registeredFeatures = {
  docPermission: DocPermission,
  mapping: Mapping,
  protectedCollections: ProtectedCollections,
  provenance: Provenance,
  schemaValidation: SchemaValidation,
  temporal: Temporal
};




function getFeatures() {
  return registeredFeatures;
}

function getFeatureMethod(featureName, featureMethod) {
  return registeredFeatures[featureName][featureMethod];
}

export default {
  getFeatures,
  getFeatureMethod
};
