/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.step.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.hub.step.AbstractStepDefinition;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.step.impl.Step;
import com.marklogic.hub.util.json.JSONObject;
import java.util.ArrayList;
import java.util.Map;

public class IngestionStepDefinitionImpl
extends AbstractStepDefinition {
    private JsonNode fileLocations;

    public IngestionStepDefinitionImpl(String name) {
        this.setName(name);
        this.setType(StepDefinition.StepDefinitionType.INGESTION);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("inputFilePath", "");
        jsonObject.put("outputURIReplacement", "");
        jsonObject.put("inputFileType", "");
        this.fileLocations = jsonObject.jsonNode();
        this.setFileLocations(this.fileLocations);
        Map<String, Object> options = this.getOptions();
        options.put("sourceQuery", "cts.collectionQuery([])");
        options.put("outputFormat", "json");
        ArrayList<String> collectionName = new ArrayList<String>();
        collectionName.add(name);
        options.put("collections", collectionName);
        options.put("targetDatabase", "data-hub-STAGING");
        this.setModulePath("/data-hub/5/builtins/steps/ingestion/default/main.mjs");
    }

    public JsonNode getFileLocations() {
        return this.fileLocations;
    }

    public void setFileLocations(JsonNode fileLocations) {
        this.fileLocations = fileLocations;
    }

    @Override
    public void deserialize(JsonNode json) {
        JSONObject jsonObject = new JSONObject(json);
        if (jsonObject.isExist("fileLocations")) {
            this.setFileLocations(jsonObject.getNode("fileLocations"));
        }
        super.deserialize(jsonObject.jsonNode());
    }

    @Override
    public Step transformToStep(String stepName, StepDefinition stepDefinition, Step step) {
        step.setFileLocations(this.fileLocations);
        return super.transformToStep(stepName, stepDefinition, step);
    }

    @Override
    public StepDefinition transformFromStep(StepDefinition stepDefinition, Step step) {
        ((IngestionStepDefinitionImpl)stepDefinition).setFileLocations(step.getFileLocations());
        return super.transformFromStep(stepDefinition, step);
    }
}

