/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.FlowManager;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.error.DataHubProjectException;
import com.marklogic.hub.flow.Flow;
import com.marklogic.hub.impl.FlowManagerImpl;
import com.marklogic.hub.impl.ScaffoldingImpl;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.hub.util.FileUtil;
import com.marklogic.mgmt.util.ObjectMapperFactory;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.FileCopyUtils;

public class HubProjectImpl
extends LoggingObject
implements HubProject {
    public static final String ENTITY_CONFIG_DIR = "src/main/entity-config";
    public static final String MODULES_DIR = "src/main/ml-modules";
    public static final String USER_SCHEMAS_DIR = "src/main/ml-schemas";
    private static final Pattern nonSpecialCharacterPattern = Pattern.compile("[^\\w\\-]");
    private String projectDirString;
    private Path projectDir;
    private Path pluginsDir;
    private Path stepDefinitionsDir;
    private String userModulesDeployTimestampFile = "user-modules-deploy-timestamps.properties";
    private final String[] artifactTypes = new String[]{"entities", "step-definitions", "steps"};
    private static final String PROJECT_TMP_FOLDER = ".tmp";

    private void validatePath(Path path, String pathName) {
        if (!path.toFile().exists()) {
            this.logger.warn(pathName + " directory does not exist: " + path);
        }
    }

    @Override
    public String getProjectDirString() {
        return this.projectDirString;
    }

    @Override
    public void createProject(String projectDirString) {
        this.projectDirString = projectDirString;
        this.projectDir = Paths.get(projectDirString, new String[0]).toAbsolutePath();
        this.pluginsDir = this.projectDir.resolve("plugins");
        this.stepDefinitionsDir = this.projectDir.resolve("step-definitions");
    }

    @Override
    public Path getHubPluginsDir() {
        return this.pluginsDir;
    }

    @Override
    public Path getStepDefinitionsDir() {
        Path path = this.stepDefinitionsDir;
        this.validatePath(path, "Step definitions");
        return path;
    }

    @Override
    public Path getStepDefinitionPath(StepDefinition.StepDefinitionType type) {
        Path path;
        if (type == null) {
            throw new DataHubProjectException("Invalid Step type");
        }
        switch (type) {
            case CUSTOM: {
                path = this.stepDefinitionsDir.resolve("custom");
                break;
            }
            case INGESTION: {
                path = this.stepDefinitionsDir.resolve("ingestion");
                break;
            }
            case MAPPING: {
                path = this.stepDefinitionsDir.resolve("mapping");
                break;
            }
            case MASTERING: {
                path = this.stepDefinitionsDir.resolve("mastering");
                break;
            }
            case MATCHING: {
                path = this.stepDefinitionsDir.resolve("matching");
                break;
            }
            case MERGING: {
                path = this.stepDefinitionsDir.resolve("merging");
                break;
            }
            default: {
                throw new DataHubProjectException("Invalid Step type" + (Object)((Object)type));
            }
        }
        return path;
    }

    @Override
    public Path getHubEntitiesDir() {
        Path path = this.projectDir.resolve("entities");
        this.validatePath(path, "Entities");
        return path;
    }

    @Override
    public Path getHubMappingsDir() {
        Path path = this.projectDir.resolve("mappings");
        this.validatePath(path, "Mappings");
        return path;
    }

    @Override
    public Path getLegacyHubEntitiesDir() {
        Path path = this.pluginsDir.resolve("entities");
        this.validatePath(path, "Legacy entities");
        return path;
    }

    @Override
    public Path getLegacyHubMappingsDir() {
        Path path = this.pluginsDir.resolve("mappings");
        this.validatePath(path, "Legacy mappings");
        return path;
    }

    @Override
    public Path getHubConfigDir() {
        return this.projectDir.resolve("src/main/hub-internal-config");
    }

    @Override
    public Path getHubDatabaseDir() {
        return this.getHubConfigDir().resolve("databases");
    }

    @Override
    public Path getHubServersDir() {
        return this.getHubConfigDir().resolve("servers");
    }

    @Override
    public Path getHubSecurityDir() {
        return this.getHubConfigDir().resolve("security");
    }

    @Override
    public Path getHubTriggersDir() {
        return this.getHubConfigDir().resolve("triggers");
    }

    @Override
    public Path getUserConfigDir() {
        return this.projectDir.resolve("src/main/ml-config");
    }

    @Override
    public Path getUserSecurityDir() {
        return this.getUserConfigDir().resolve("security");
    }

    @Override
    public Path getUserDatabaseDir() {
        return this.getUserConfigDir().resolve("databases");
    }

    @Override
    public Path getUserSchemasDir() {
        return this.projectDir.resolve(USER_SCHEMAS_DIR);
    }

    @Override
    public Path getUserServersDir() {
        return this.getUserConfigDir().resolve("servers");
    }

    @Override
    public Path getEntityConfigDir() {
        return this.projectDir.resolve(ENTITY_CONFIG_DIR);
    }

    @Override
    public Path getEntityDatabaseDir() {
        return this.getEntityConfigDir().resolve("databases");
    }

    @Override
    public Path getFlowsDir() {
        Path path = this.projectDir.resolve("flows");
        this.validatePath(path, "Flows");
        return path;
    }

    @Override
    @Deprecated
    public Path getHubStagingModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    @Deprecated
    public Path getUserStagingModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    public Path getModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    @Deprecated
    public Path getUserFinalModulesDir() {
        return this.projectDir.resolve(MODULES_DIR);
    }

    @Override
    public Path getCustomModulesDir() {
        return this.getModulesDir().resolve("root").resolve("custom-modules");
    }

    @Override
    public Path getCustomMappingFunctionsDir() {
        return this.getCustomModulesDir().resolve("mapping-functions");
    }

    @Override
    public boolean isInitialized() {
        File buildGradle = this.projectDir.resolve("build.gradle").toFile();
        File gradleProperties = this.projectDir.resolve("gradle.properties").toFile();
        File hubConfigDir = this.getHubConfigDir().toFile();
        File userConfigDir = this.getUserConfigDir().toFile();
        File databasesDir = this.getHubDatabaseDir().toFile();
        File serversDir = this.getHubServersDir().toFile();
        File securityDir = this.getHubSecurityDir().toFile();
        boolean newConfigInitialized = hubConfigDir.exists() && hubConfigDir.isDirectory() && userConfigDir.exists() && userConfigDir.isDirectory() && databasesDir.exists() && databasesDir.isDirectory() && serversDir.exists() && serversDir.isDirectory() && securityDir.exists() && securityDir.isDirectory();
        return buildGradle.exists() && gradleProperties.exists() && newConfigInitialized;
    }

    @Override
    public void init(Map<String, String> customTokens) {
        if (customTokens == null) {
            customTokens = new HashMap<String, String>();
        }
        for (String artifactType : this.artifactTypes) {
            File artifactTypeDir = this.getProjectDir().resolve(artifactType).toFile();
            if (artifactTypeDir.exists()) continue;
            artifactTypeDir.mkdirs();
        }
        Path userModules = this.projectDir.resolve(MODULES_DIR);
        userModules.toFile().mkdirs();
        Path customModulesDir = this.getCustomModulesDir();
        customModulesDir.toFile().mkdirs();
        this.getCustomMappingFunctionsDir().toFile().mkdirs();
        for (StepDefinition.StepDefinitionType stepType : StepDefinition.StepDefinitionType.values()) {
            customModulesDir.resolve(stepType.toString().toLowerCase()).toFile().mkdirs();
        }
        Path hubServersDir = this.getHubServersDir();
        hubServersDir.toFile().mkdirs();
        this.writeResourceFile("hub-internal-config/servers/staging-server.json", hubServersDir.resolve("staging-server.json"), true);
        this.writeResourceFile("hub-internal-config/servers/job-server.json", hubServersDir.resolve("job-server.json"), true);
        Path hubDatabaseDir = this.getHubDatabaseDir();
        hubDatabaseDir.toFile().mkdirs();
        this.writeResourceFile("hub-internal-config/databases/staging-database.json", hubDatabaseDir.resolve("staging-database.json"), true);
        this.writeResourceFile("hub-internal-config/databases/final-database.json", hubDatabaseDir.resolve("final-database.json"), true);
        this.writeResourceFile("hub-internal-config/databases/job-database.json", hubDatabaseDir.resolve("job-database.json"), true);
        this.writeResourceFile("hub-internal-config/databases/staging-schemas-database.json", hubDatabaseDir.resolve("staging-schemas-database.json"), true);
        this.writeResourceFile("hub-internal-config/databases/staging-triggers-database.json", hubDatabaseDir.resolve("staging-triggers-database.json"), true);
        boolean overwriteUserConfigFiles = false;
        Path userServersDir = this.getUserServersDir();
        userServersDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/servers/final-server.json", userServersDir.resolve("final-server.json"), false);
        Path userDatabaseDir = this.getUserDatabaseDir();
        userDatabaseDir.toFile().mkdirs();
        this.writeResourceFile("ml-config/databases/final-database.json", userDatabaseDir.resolve("final-database.json"), false);
        this.writeResourceFile("ml-config/databases/modules-database.json", userDatabaseDir.resolve("modules-database.json"), false);
        this.writeResourceFile("ml-config/databases/final-schemas-database.json", userDatabaseDir.resolve("final-schemas-database.json"), false);
        this.writeResourceFile("ml-config/databases/final-triggers-database.json", userDatabaseDir.resolve("final-triggers-database.json"), false);
        Path userDatabaseFieldsDir = this.getUserConfigDir().resolve("database-fields");
        userDatabaseFieldsDir.toFile().mkdirs();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            HubProjectImpl.writeResources(resolver, "classpath:hub-internal-config/security/amps/*.json", this.getHubSecurityDir().resolve("amps"));
            HubProjectImpl.writeResources(resolver, "classpath:hub-internal-config/security/privileges/*.json", this.getHubSecurityDir().resolve("privileges"));
            HubProjectImpl.writeResources(resolver, "classpath:hub-internal-config/security/roles/*.json", this.getHubSecurityDir().resolve("roles"));
            HubProjectImpl.writeResources(resolver, "classpath:hub-internal-config/triggers/*.json", this.getHubTriggersDir());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write project resources to project filesystem; cause: " + e.getMessage(), e);
        }
        Path userSecurityDir = this.getUserSecurityDir();
        userSecurityDir.resolve("roles").toFile().mkdirs();
        userSecurityDir.resolve("users").toFile().mkdirs();
        userSecurityDir.resolve("privileges").toFile().mkdirs();
        this.getUserServersDir().toFile().mkdirs();
        this.getUserDatabaseDir().toFile().mkdirs();
        String stagingSchemasKey = "%%mlStagingSchemasDbName%%";
        if (customTokens.containsKey("%%mlStagingSchemasDbName%%")) {
            this.getUserDatabaseDir().resolve(customTokens.get("%%mlStagingSchemasDbName%%")).resolve("schemas").toFile().mkdirs();
        }
        this.getUserSchemasDir().toFile().mkdirs();
        this.getFlowsDir().toFile().mkdirs();
        Path gradlew = this.projectDir.resolve("gradlew");
        this.writeResourceFile("scaffolding/gradlew", gradlew);
        HubProjectImpl.makeExecutable(gradlew);
        Path gradlewbat = this.projectDir.resolve("gradlew.bat");
        this.writeResourceFile("scaffolding/gradlew.bat", gradlewbat);
        HubProjectImpl.makeExecutable(gradlewbat);
        Path gradleWrapperDir = this.projectDir.resolve("gradle").resolve("wrapper");
        gradleWrapperDir.toFile().mkdirs();
        this.writeResourceFile("scaffolding/gradle/wrapper/gradle-wrapper.jar", gradleWrapperDir.resolve("gradle-wrapper.jar"), true);
        this.writeResourceFile("scaffolding/gradle/wrapper/gradle-wrapper.properties", gradleWrapperDir.resolve("gradle-wrapper.properties"), true);
        this.writeResourceFile("scaffolding/build_gradle", this.projectDir.resolve("build.gradle"));
        this.writeResourceFileWithReplace(customTokens, "scaffolding/gradle_properties", this.projectDir.resolve("gradle.properties"));
        this.writeResourceFile("scaffolding/gradle-local_properties", this.projectDir.resolve("gradle-local.properties"));
    }

    private static void writeResources(PathMatchingResourcePatternResolver resolver, String pattern, Path projectTargetPath) throws IOException {
        File projectTargetDir = projectTargetPath.toFile();
        if (!projectTargetDir.mkdirs() && !projectTargetDir.exists()) {
            throw new RuntimeException("Unable to create directory at '" + projectTargetDir.getAbsolutePath() + "'.");
        }
        for (Resource resource : resolver.getResources(pattern)) {
            FileCopyUtils.copy((InputStream)resource.getInputStream(), (OutputStream)Files.newOutputStream(projectTargetPath.resolve(Objects.requireNonNull(resource.getFilename())).toFile().toPath(), new OpenOption[0]));
        }
    }

    private static void makeExecutable(Path file) {
        EnumSet<PosixFilePermission> perms = EnumSet.noneOf(PosixFilePermission.class);
        perms.add(PosixFilePermission.OWNER_READ);
        perms.add(PosixFilePermission.OWNER_WRITE);
        perms.add(PosixFilePermission.OWNER_EXECUTE);
        try {
            Files.setPosixFilePermissions(file, perms);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeResourceFile(String srcFile, Path dstFile) {
        this.writeResourceFile(srcFile, dstFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResourceFile(String srcFile, Path dstFile, boolean overwrite) {
        if (overwrite || !dstFile.toFile().exists()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Getting file: " + srcFile);
            }
            InputStream inputStream = null;
            try {
                inputStream = HubProject.class.getClassLoader().getResourceAsStream(srcFile);
                FileUtil.copy(inputStream, dstFile.toFile());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(inputStream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private void writeResourceFileWithReplace(Map<String, String> customTokens, String srcFile, Path dstFile) {
        this.writeResourceFileWithReplace(customTokens, srcFile, dstFile, false);
    }

    private void writeResourceFileWithReplace(Map<String, String> customTokens, String srcFile, Path dstFile, boolean overwrite) {
        block19: {
            InputStream inputStream = null;
            try {
                if (!overwrite && dstFile.toFile().exists()) break block19;
                this.logger.debug("Getting file with replace: " + srcFile);
                inputStream = HubProject.class.getClassLoader().getResourceAsStream(srcFile);
                assert (inputStream != null);
                String fileContents = IOUtils.toString((InputStream)inputStream, (Charset)Charset.defaultCharset());
                for (Map.Entry<String, String> entry : customTokens.entrySet()) {
                    String value = entry.getValue();
                    if (value == null) continue;
                    fileContents = fileContents.replace(entry.getKey(), value);
                }
                try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(dstFile.toFile().toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
                    writer.write(fileContents);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                IOUtils.closeQuietly(inputStream);
            }
        }
    }

    @Override
    public void upgradeProject(FlowManager flowManager) throws IOException {
        File[] oldMappingsDirectories;
        File[] oldEntityDirectories;
        Path oldEntitiesDir = this.getLegacyHubEntitiesDir();
        Path oldMappingsDir = this.getLegacyHubMappingsDir();
        Path newEntitiesDirPath = this.getHubEntitiesDir();
        Path newMappingsDirPath = this.getHubMappingsDir();
        File newEntitiesDirFile = newEntitiesDirPath.toFile();
        File newMappingsDirFile = newMappingsDirPath.toFile();
        if (!newEntitiesDirFile.exists()) {
            newEntitiesDirFile.mkdir();
        }
        if (!newMappingsDirFile.exists()) {
            newMappingsDirFile.mkdir();
        }
        if ((oldEntityDirectories = oldEntitiesDir.toFile().listFiles()) != null) {
            HashMap<String, JsonNode> entitiesJson = new HashMap<String, JsonNode>();
            for (File legacyEntityDir : oldEntityDirectories) {
                File[] entityFiles;
                if (!legacyEntityDir.isDirectory() || (entityFiles = legacyEntityDir.listFiles((file, name) -> name.endsWith(".entity.json"))) == null) continue;
                ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
                File[] fileArray = entityFiles;
                int n = fileArray.length;
                for (int i = 0; i < n; ++i) {
                    File entityFile = fileArray[i];
                    String entityFileName = entityFile.getName();
                    this.logger.info("Moving plugins/entities/" + legacyEntityDir.getName() + "/" + entityFileName + " to entities/" + entityFileName);
                    Path newEntityPath = newEntitiesDirPath.resolve(entityFileName);
                    Files.move(entityFile.toPath(), newEntityPath, new CopyOption[0]);
                    entitiesJson.put(entityFileName.substring(0, entityFileName.indexOf(".entity.json")), mapper.readTree(newEntityPath.toFile()));
                }
            }
            this.fixEntityRelationships(entitiesJson);
        }
        if ((oldMappingsDirectories = oldMappingsDir.toFile().listFiles()) != null) {
            for (File legacyMappingsDir : oldMappingsDirectories) {
                File[] mappingsFiles;
                if (!legacyMappingsDir.isDirectory()) continue;
                if (!newMappingsDirPath.resolve(legacyMappingsDir.getName()).toFile().exists()) {
                    newMappingsDirPath.resolve(legacyMappingsDir.getName()).toFile().mkdir();
                }
                if ((mappingsFiles = legacyMappingsDir.listFiles((file, name) -> name.endsWith(".mapping.json"))) == null) continue;
                for (File mappingsFile : mappingsFiles) {
                    this.logger.info("Moving plugins/mappings/" + legacyMappingsDir.getName() + "/" + mappingsFile.getName() + " to mappings/" + legacyMappingsDir.getName() + "/" + mappingsFile.getName());
                    Files.move(mappingsFile.toPath(), newMappingsDirPath.resolve(legacyMappingsDir.getName()).resolve(mappingsFile.getName()), new CopyOption[0]);
                }
            }
        }
        this.convertHubCommunityProject();
        this.removeEmptyRangeElementIndexArrayFromFinalDatabaseFile();
        this.updateStepDefinitionTypeForInlineMappingSteps(flowManager);
        this.updateGradleProperties();
    }

    private void fixEntityRelationships(Map<String, JsonNode> entitiesJson) throws IOException {
        HashSet<String> entitiesThatRequireUpdating = new HashSet<String>();
        for (Map.Entry<String, JsonNode> entry : entitiesJson.entrySet()) {
            String entityName = entry.getKey();
            JsonNode entityDefinitions = entry.getValue().path("definitions");
            Iterator it = entityDefinitions.fields();
            while (it.hasNext()) {
                JsonNode definition = (JsonNode)((Map.Entry)it.next()).getValue();
                Iterator it2 = definition.path("properties").fields();
                while (it2.hasNext()) {
                    String refDefName;
                    JsonNode property = (JsonNode)((Map.Entry)it2.next()).getValue();
                    ObjectNode refParent = (ObjectNode)(property.has("items") ? property.path("items") : property);
                    JsonNode ref = refParent.path("$ref");
                    if (ref.isMissingNode() || !ref.asText().startsWith("#/definitions/") || entityDefinitions.has(refDefName = ref.asText().substring("#/definitions/".length())) || !entitiesJson.containsKey(refDefName)) continue;
                    JsonNode referencedEntityModel = entitiesJson.get(refDefName);
                    JsonNode referencedEntityModelInfo = referencedEntityModel.path("info");
                    JsonNode referencedEntityModelDef = referencedEntityModel.path("definitions").path(refDefName);
                    String baseUri = referencedEntityModelInfo.path("baseUri").asText();
                    String referencedUri = baseUri + (baseUri.endsWith("/") ? "" : "/") + referencedEntityModelInfo.path("title").asText() + "-" + referencedEntityModelInfo.path("version").asText() + "/" + refDefName;
                    refParent.remove("$ref");
                    refParent.put("relatedEntityType", referencedUri);
                    String referencedPrimaryKey = referencedEntityModelDef.path("primaryKey").asText();
                    refParent.put("joinPropertyName", referencedPrimaryKey);
                    JsonNode primaryKeyProp = referencedEntityModelDef.path("properties").path(referencedPrimaryKey);
                    refParent.set("datatype", primaryKeyProp.path("datatype"));
                    JsonNode collationProp = primaryKeyProp.path("collation");
                    if (!collationProp.isMissingNode()) {
                        refParent.set("collation", collationProp);
                    }
                    entitiesThatRequireUpdating.add(entityName);
                }
            }
        }
        ObjectMapper mapper = ObjectMapperFactory.getObjectMapper();
        for (String entityName : entitiesThatRequireUpdating) {
            mapper.writeValue(this.getHubEntitiesDir().resolve(entityName + ".entity.json").toFile(), (Object)entitiesJson.get(entityName));
        }
    }

    private void updateGradleProperties() {
        block16: {
            File gradleProperties = this.projectDir.resolve("gradle.properties").toFile();
            if (gradleProperties.exists()) {
                try {
                    ArrayList<String> appendLines = new ArrayList<String>();
                    List<String> existingLines = Files.readAllLines(gradleProperties.toPath());
                    this.conditionallyAddGradleLines(existingLines, appendLines, "hubSupportMlColonPrefix", "# If your system depends on the ml: prefix for REST extensions, uncomment the following. (Only works with ML on Linux)", "# hubSupportMlColonPrefix=true");
                    this.conditionallyAddGradleLines(existingLines, appendLines, "hubFlattenedTdeView", "# Setting the following to true will cause your application use the optimized TDE view which will cause TDE reindexing of existing applications.", "hubFlattenedTdeView=false");
                    if (appendLines.isEmpty()) break block16;
                    try (FileWriter writer = new FileWriter(gradleProperties, true);){
                        writer.write(System.lineSeparator());
                        for (String str : appendLines) {
                            writer.write(str + System.lineSeparator());
                        }
                    }
                }
                catch (IOException e) {
                    this.logger.warn("Failed to read or update gradle.properties.", (Throwable)e);
                }
            }
        }
    }

    private void conditionallyAddGradleLines(List<String> existingLines, List<String> appendLines, String notContains, String ... addLines) {
        Optional<String> existingProperty = existingLines.stream().filter(line -> line.contains(notContains)).findFirst();
        if (!existingProperty.isPresent()) {
            Collections.addAll(appendLines, addLines);
        }
    }

    @Override
    public int upgradeLegacyFlows(FlowManager flowManager) {
        return this.upgradeLegacyFlows(flowManager, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), "data-hub-STAGING", "data-hub-FINAL");
    }

    public int upgradeLegacyFlows(FlowManager flowManager, List<String> legacyEntities, List<String> legacyFlowTypes, List<String> legacyFlowNames, String stagingDb, String finalDb) {
        HashSet<String> legacyEntitiesSet = new HashSet<String>(legacyEntities);
        HashSet<String> legacyFlowTypesSet = new HashSet<String>(legacyFlowTypes);
        HashSet<String> legacyFlowNamesSet = new HashSet<String>(legacyFlowNames);
        int flowsUpdated = 0;
        if (this.getHubPluginsDir() == null || this.getLegacyHubEntitiesDir() == null) {
            this.logger.info("No legacy Flows found in plugins/entities directory to upgrade");
            return flowsUpdated;
        }
        Path oldEntitiesDir = this.getLegacyHubEntitiesDir();
        Object[] oldEntityDirectories = oldEntitiesDir.toFile().listFiles((dir, name) -> !legacyEntitiesSet.isEmpty() ? dir.isDirectory() && legacyEntitiesSet.contains(name) : dir.isDirectory());
        if (ArrayUtils.isEmpty((Object[])oldEntityDirectories)) {
            this.logger.info("No legacy Flows found in plugins/entities directory to upgrade");
            return flowsUpdated;
        }
        ScaffoldingImpl scaffolding = new ScaffoldingImpl(flowManager.getHubConfig());
        ObjectMapper objectMapper = new ObjectMapper();
        if (oldEntityDirectories != null) {
            for (Object legacyEntityDir : oldEntityDirectories) {
                ObjectNode steps;
                File[] flowTypes = ((File)legacyEntityDir).listFiles((dir, name) -> !legacyFlowTypesSet.isEmpty() ? dir.isDirectory() && legacyFlowTypesSet.contains(name) : dir.isDirectory());
                assert (flowTypes != null);
                Arrays.sort(flowTypes, Collections.reverseOrder());
                String flowName = "dh_Upgrade_".concat(((File)legacyEntityDir).getName()).concat("Flow");
                ObjectNode flow = ((FlowManagerImpl)flowManager).getLocalFlowAsJSON(flowName);
                int stepNumber = 0;
                if (flow == null) {
                    flow = objectMapper.createObjectNode();
                    flow.put("name", flowName);
                    steps = objectMapper.createObjectNode();
                    flow.set("steps", (JsonNode)steps);
                } else {
                    steps = (ObjectNode)flow.get("steps");
                    Iterable iterable = () -> ((ObjectNode)steps).fieldNames();
                    stepNumber = StreamSupport.stream(iterable.spliterator(), false).mapToInt(Integer::parseInt).max().getAsInt();
                }
                int currStepNumber = stepNumber;
                for (File oldFlowType : flowTypes) {
                    File[] stepFiles = oldFlowType.listFiles((dir, name) -> !legacyFlowNamesSet.isEmpty() ? dir.isDirectory() && legacyFlowNamesSet.contains(name) : dir.isDirectory());
                    assert (stepFiles != null);
                    for (File stepFile : stepFiles) {
                        if (stepFile.getName().equalsIgnoreCase("rest")) continue;
                        String stepName = stepFile.getName();
                        String newStepName = nonSpecialCharacterPattern.matcher(stepName).replaceAll("");
                        newStepName = Character.isLetter(newStepName.charAt(0)) ? newStepName : "dh_".concat(newStepName);
                        String slash = "/";
                        String mainModulePath = slash.concat("entities").concat(slash).concat(((File)legacyEntityDir).getName()).concat(slash).concat(oldFlowType.getName()).concat(slash).concat(stepName);
                        String stepType = "";
                        boolean acceptSourceModule = false;
                        if (oldFlowType.getName().equals("input")) {
                            stepType = "ingestion";
                        } else if (oldFlowType.getName().equals("harmonize")) {
                            stepType = "custom";
                            acceptSourceModule = true;
                        }
                        if (this.getStepFile(Objects.requireNonNull(StepDefinition.StepDefinitionType.getStepDefinitionType(stepType)), newStepName).exists()) {
                            this.logger.info(String.format("Ignoring legacy flow %s in the %s entity as a step with StepName: %s and StepType: %s already exists in steps directory", stepName, ((File)legacyEntityDir).getName(), newStepName, stepType));
                            continue;
                        }
                        JsonNode stepPayLoad = scaffolding.getStepConfig(newStepName, stepType, newStepName, null, acceptSourceModule);
                        scaffolding.saveStepDefinition(newStepName, newStepName, stepType, true);
                        this.updateStepOptionsFor4xFlow(stepName, stepFile, stepPayLoad, mainModulePath, ((File)legacyEntityDir).getName(), stagingDb, finalDb);
                        scaffolding.saveLocalStep(stepType, stepPayLoad);
                        ObjectNode stepIdObj = objectMapper.createObjectNode();
                        steps.putIfAbsent(Integer.toString(++stepNumber), (JsonNode)stepIdObj);
                        stepIdObj.put("stepId", newStepName.concat("-").concat(stepType));
                        ++flowsUpdated;
                    }
                }
                if (stepNumber <= currStepNumber) continue;
                ((FlowManagerImpl)flowManager).saveLocalFlow((JsonNode)flow);
            }
        }
        return flowsUpdated;
    }

    private Path getMlcpOptionsFilePath(Path destFolder, String entityName, String flowName) {
        return destFolder.resolve(entityName + "-" + flowName + ".txt");
    }

    public Map<String, Object> getFlowMlcpOptionsFromFile(String entityName, String flowName) {
        Path destFolder = this.getProjectDir().resolve(PROJECT_TMP_FOLDER);
        Path filePath = this.getMlcpOptionsFilePath(destFolder, entityName, flowName);
        File file = filePath.toFile();
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (file.exists()) {
            try {
                result.putAll((Map)new ObjectMapper().readValue(file, Map.class));
            }
            catch (IOException e) {
                this.logger.warn("Unable to parse old QuickStart options for conversion.", (Throwable)e);
            }
        }
        return result;
    }

    private void updateStepOptionsFor4xFlow(String stepName, File stepFile, JsonNode stepPayLoad, String mainModulePath, String entityType, String stagingDb, String finalDb) {
        ObjectNode step = (ObjectNode)stepPayLoad;
        ObjectMapper mapper = new ObjectMapper();
        Properties properties = new Properties();
        try {
            File propsFile = Objects.requireNonNull(stepFile.listFiles((file, name) -> name.equals(stepName.concat(".properties"))))[0];
            try (InputStream in = Files.newInputStream(propsFile.toPath(), new OpenOption[0]);){
                properties.load(in);
            }
        }
        catch (IOException | ArrayIndexOutOfBoundsException e) {
            this.logger.warn("{}.properties file is missing in the {} directory. The dataFormat and mainModule is defaulted to json and main.sjsIf the default values are inappropriate, change the values in steps/{} file", new Object[]{stepName, stepName, stepPayLoad.get("name").asText()});
            properties.put("mainModule", "main.sjs");
            properties.put("dataFormat", "json");
        }
        ObjectNode optionsNode = mapper.createObjectNode();
        optionsNode.put("flow", stepName);
        optionsNode.put("entity", "");
        optionsNode.put("dataFormat", properties.getOrDefault((Object)"dataFormat", "json").toString());
        optionsNode.put("mainModuleUri", mainModulePath.concat("/").concat(properties.getOrDefault((Object)"mainModule", "main.sjs").toString()));
        step.putIfAbsent("options", (JsonNode)optionsNode);
        step.putArray("collections").add(stepPayLoad.get("name").asText()).add(entityType);
        step.put("permissions", "data-hub-common,read,data-hub-common,update");
        step.put("stepId", step.get("name").asText().concat("-").concat(step.get("stepDefinitionType").asText()));
        step.put("isUpgradedLegacyFlow", true);
        step.put("sourceFormat", (String)properties.getOrDefault((Object)"dataFormat", "json"));
        step.put("targetFormat", (String)properties.getOrDefault((Object)"dataFormat", "json"));
        if (step.get("stepDefinitionType").asText().equals("custom")) {
            step.put("sourceDatabase", stagingDb);
            step.put("targetDatabase", finalDb);
            step.put("sourceQueryIsModule", true);
            mainModulePath = mainModulePath.concat("/").concat(properties.getOrDefault((Object)"collectorModule", "collector.sjs").toString());
            ObjectNode sourceModuleNode = (ObjectNode)step.get("sourceModule");
            sourceModuleNode.put("modulePath", mainModulePath);
            sourceModuleNode.put("functionName", "collect");
            optionsNode.put("entity", entityType);
        } else {
            Map<String, Object> quickStartOptions = this.getFlowMlcpOptionsFromFile(entityType, stepName);
            if ("delimited_text".equals(quickStartOptions.get("input_file_type"))) {
                step.put("separator", (String)quickStartOptions.getOrDefault("delimiter", ","));
                step.put("sourceFormat", "csv");
            }
            step.put("targetDatabase", stagingDb);
            step.put("inputFilePath", (String)quickStartOptions.getOrDefault("input_file_path", ""));
        }
    }

    private JsonNode retrieveEntityFromCommunityNode(String modelName, JsonNode modelNodes, Map<String, JsonNode> entityModels) throws IOException {
        JsonNode communityModelNode;
        String entityName;
        Path newEntitiesDirPath;
        File entityFile;
        if (!entityModels.containsKey(modelName) && (entityFile = (newEntitiesDirPath = this.getHubEntitiesDir()).resolve((entityName = (communityModelNode = modelNodes.path(modelName)).path("entityName").asText()) + ".entity.json").toFile()).exists()) {
            entityModels.put(modelName, ObjectMapperFactory.getObjectMapper().readTree(entityFile));
        }
        return entityModels.get(modelName);
    }

    private void convertHubCommunityProject() {
        File[] communityModelFiles;
        ObjectNode hubConfigNode;
        Path conceptConnectorModelsDir = this.getProjectDir().resolve("conceptConnectorModels");
        File hubConfigFile = this.getHubCentralConfigPath().resolve("hubCentral.json").toFile();
        if (hubConfigFile.exists()) {
            try {
                hubConfigNode = ObjectMapperFactory.getObjectMapper().readTree(hubConfigFile);
            }
            catch (Exception ex) {
                this.logger.warn("Unable to parse Hub Central Config " + hubConfigFile.getName() + "; exception: " + ex);
                return;
            }
        } else {
            hubConfigNode = ObjectMapperFactory.getObjectMapper().createObjectNode();
        }
        JsonNode hubConfigEntitiesNode = hubConfigNode.path("modeling").path("entities");
        if (hubConfigEntitiesNode.isMissingNode()) {
            hubConfigEntitiesNode = ObjectMapperFactory.getObjectMapper().createObjectNode();
        }
        if ((communityModelFiles = conceptConnectorModelsDir.toFile().listFiles((file, name) -> name.endsWith(".json"))) != null) {
            Path newEntitiesDirPath = this.getHubEntitiesDir();
            HashMap<String, JsonNode> entityModels = new HashMap<String, JsonNode>();
            for (File communityModelFile : communityModelFiles) {
                try {
                    JsonNode communityModel = ObjectMapperFactory.getObjectMapper().readTree(communityModelFile);
                    JsonNode modelNodes = communityModel.path("nodes");
                    JsonNode modelEdges = communityModel.path("edges");
                    Iterator it = modelNodes.elements();
                    while (it.hasNext()) {
                        JsonNode communityModelNode = (JsonNode)it.next();
                        JsonNode communityModelLabel = communityModelNode.path("labelField");
                        if (communityModelLabel.isMissingNode() || !"entity".equals(communityModelNode.path("type").asText())) continue;
                        String modelFrom = communityModelNode.path("entityName").asText();
                        if (!hubConfigEntitiesNode.hasNonNull(modelFrom)) {
                            ((ObjectNode)hubConfigEntitiesNode).set(modelFrom, (JsonNode)ObjectMapperFactory.getObjectMapper().createObjectNode());
                        }
                        JsonNode hubCentralNode = hubConfigEntitiesNode.path(modelFrom);
                        ((ObjectNode)hubCentralNode).set("label", communityModelLabel);
                    }
                    it = modelEdges.elements();
                    while (it.hasNext()) {
                        JsonNode modelFromPropertyNode;
                        JsonNode communityModelNode;
                        String modelFrom;
                        File entityFile;
                        JsonNode edge = (JsonNode)it.next();
                        String modelFromName = edge.path("from").asText();
                        if (!entityModels.containsKey(modelFromName) && (entityFile = newEntitiesDirPath.resolve((modelFrom = (communityModelNode = modelNodes.path(modelFromName)).path("entityName").asText()) + ".entity.json").toFile()).exists()) {
                            entityModels.put(modelFromName, ObjectMapperFactory.getObjectMapper().readTree(entityFile));
                        }
                        JsonNode modelFromNode = this.retrieveEntityFromCommunityNode(modelFromName, modelNodes, entityModels);
                        String edgeLabel = edge.path("label").asText();
                        String modelToName = edge.path("to").asText();
                        JsonNode modelToNode = this.retrieveEntityFromCommunityNode(modelToName, modelNodes, entityModels);
                        if (modelFromNode == null || modelToNode == null) continue;
                        JsonNode fromEntityNode = (JsonNode)entityModels.get(modelFromName);
                        String modelFromTitle = fromEntityNode.path("info").path("title").asText();
                        String modelToTitle = modelToNode.path("info").path("title").asText();
                        String[] modelFromPropertyPath = edge.path("keyFrom").asText("").split("/");
                        String[] modelToPropertyPath = edge.path("keyTo").asText("").split("/");
                        if (modelFromPropertyPath.length > 1) {
                            modelFromTitle = modelFromPropertyPath[modelFromPropertyPath.length - 2];
                        }
                        if (modelToPropertyPath.length > 1) {
                            modelToTitle = modelFromPropertyPath[modelToPropertyPath.length - 2];
                        }
                        String modelFromProperty = modelFromPropertyPath[modelFromPropertyPath.length - 1];
                        String modelToProperty = modelToPropertyPath[modelToPropertyPath.length - 1];
                        JsonNode modelFromTypeNode = modelFromNode.path("definitions").path(modelFromTitle);
                        if ("concept".equals(modelToNode.path("type").asText())) {
                            ArrayNode relatedConcepts = (ArrayNode)modelFromTypeNode.withArray("relatedConcepts");
                            boolean conceptExists = false;
                            String context = edge.path("keyFrom").isNull() ? modelToProperty : modelFromProperty;
                            Iterator iter = relatedConcepts.elements();
                            while (iter.hasNext()) {
                                JsonNode related = (JsonNode)iter.next();
                                if (!context.equals(related.path("context").asText())) continue;
                                conceptExists = true;
                                break;
                            }
                            if (conceptExists) continue;
                            ObjectNode relatedConcept = relatedConcepts.addObject();
                            relatedConcept.put("context", context);
                            relatedConcept.set("predicate", edge.get("label"));
                            relatedConcept.put("conceptClass", modelToTitle);
                            continue;
                        }
                        String modelToBaseUri = modelToNode.path("info").path("baseUri").asText();
                        String modelToVersion = modelToNode.path("info").path("version").asText();
                        String modelToIRI = modelToBaseUri + modelToTitle + "-" + modelToVersion;
                        String typeToIRI = modelToIRI + "/" + modelToTitle;
                        JsonNode modelFromProperties = modelFromTypeNode.path("properties");
                        JsonNode jsonNode = modelFromPropertyNode = modelFromProperties.hasNonNull(edgeLabel) ? modelFromProperties.path(edgeLabel) : modelFromProperties.path(modelFromProperty);
                        if (modelFromPropertyNode.hasNonNull("items")) {
                            modelFromPropertyNode = modelFromPropertyNode.get("items");
                        }
                        if (!modelFromPropertyNode.isObject() || modelFromPropertyNode.hasNonNull("relatedEntityType")) continue;
                        ((ObjectNode)modelFromPropertyNode).put("relatedEntityType", typeToIRI);
                        ((ObjectNode)modelFromPropertyNode).put("joinPropertyName", modelToProperty);
                        if (modelFromPropertyNode.hasNonNull("$ref")) {
                            ((ObjectNode)modelFromPropertyNode).remove("$ref");
                        }
                        if (modelFromPropertyNode.hasNonNull("datatype")) continue;
                        JsonNode modelToPropertyNode = modelToNode.path("definitions").path(modelToTitle).path("properties").path(modelToProperty);
                        if (modelToPropertyNode.hasNonNull("items")) {
                            modelToPropertyNode = modelToPropertyNode.path("items");
                        }
                        ((ObjectNode)modelFromPropertyNode).put("datatype", modelToPropertyNode.path("datatype").asText(""));
                    }
                }
                catch (Exception ex) {
                    this.logger.warn("Unable to parse Hub Community Model " + communityModelFile.getName() + "; exception: " + ex);
                }
                for (JsonNode entityNode : entityModels.values()) {
                    String title = entityNode.path("info").path("title").asText();
                    File entityFile = newEntitiesDirPath.resolve(title + ".entity.json").toFile();
                    try {
                        ObjectMapperFactory.getObjectMapper().writeValue(entityFile, (Object)entityNode);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (hubConfigNode.path("modeling").isMissingNode()) {
                    hubConfigNode.set("modeling", (JsonNode)ObjectMapperFactory.getObjectMapper().createObjectNode());
                }
                ((ObjectNode)hubConfigNode.path("modeling")).set("entities", hubConfigEntitiesNode);
                try {
                    if (!hubConfigFile.exists()) {
                        File parentFile = hubConfigFile.getParentFile();
                        if (!parentFile.mkdirs() && !parentFile.exists()) {
                            throw new RuntimeException("Unable to create parent directory at '" + parentFile.getAbsolutePath() + "' for Hub config file.");
                        }
                        hubConfigFile.createNewFile();
                    }
                    ObjectMapperFactory.getObjectMapper().writeValue(hubConfigFile, (Object)hubConfigNode);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Override
    public void exportProject(File location) {
        File parentFile = location.getParentFile();
        if (parentFile == null || !location.getParentFile().exists() && !location.getParentFile().mkdirs()) {
            throw new RuntimeException("Unable to create parent directory at '" + (parentFile != null ? parentFile.getAbsolutePath() : location.getAbsolutePath()) + "' for project export.");
        }
        try (FileOutputStream out = new FileOutputStream(location);){
            this.exportProject(out, new ArrayList<String>());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to export project, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public void exportProject(OutputStream outputStream) {
        this.exportProject(outputStream, new ArrayList<String>());
    }

    public void exportProject(OutputStream outputStream, List<String> additionalFilesTobeAdded) {
        Stream<String> filesToBeAddedToZip = Stream.of("entities", "flows", "src/main", "step-definitions", "steps", "gradle", "gradlew", "gradlew.bat", "build.gradle", "gradle.properties", "concepts", "config");
        if (additionalFilesTobeAdded.isEmpty()) {
            this.writeToStream(outputStream, filesToBeAddedToZip);
        } else {
            this.writeToStream(outputStream, Stream.concat(filesToBeAddedToZip, additionalFilesTobeAdded.stream()));
        }
    }

    private void writeToStream(OutputStream out, Stream<String> filesToBeAddedToZip) {
        try (ZipOutputStream zout = new ZipOutputStream(out);){
            filesToBeAddedToZip.forEach(file -> {
                File fileToZip = this.getProjectDir().resolve((String)file).toFile();
                if (!fileToZip.exists()) {
                    this.logger.warn(String.format("%s does not exist during project export.", fileToZip));
                    return;
                }
                try {
                    if (fileToZip.isDirectory()) {
                        zout.putNextEntry(new ZipEntry(file + "/"));
                        HubProjectImpl.zipSubDirectory(file + "/", fileToZip, zout);
                    } else {
                        HubProjectImpl.zipSubDirectory("", fileToZip, zout);
                    }
                }
                catch (Exception ex) {
                    throw new RuntimeException("Unable to export project, cause: " + ex.getMessage(), ex);
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to export project, cause: " + e.getMessage(), e);
        }
    }

    @Override
    public String getProjectName() {
        return this.getProjectDir().toFile().getName();
    }

    private static void zipSubDirectory(String basePath, File fileToZip, ZipOutputStream zout) throws IOException {
        File[] files = fileToZip.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    String path = basePath + file.getName() + "/";
                    zout.putNextEntry(new ZipEntry(path));
                    HubProjectImpl.zipSubDirectory(path, file, zout);
                    continue;
                }
                HubProjectImpl.addFileToZip(basePath, file, zout);
            }
        } else {
            HubProjectImpl.addFileToZip(basePath, fileToZip, zout);
        }
    }

    private static void addFileToZip(String basePath, File fileToZip, ZipOutputStream zout) throws IOException {
        try (FileInputStream fin = new FileInputStream(fileToZip);){
            zout.putNextEntry(new ZipEntry(basePath + fileToZip.getName()));
            IOUtils.copy((InputStream)fin, (OutputStream)zout);
            IOUtils.closeQuietly((InputStream)fin);
        }
    }

    public void updateStepDefinitionTypeForInlineMappingSteps(FlowManager flowManager) {
        try {
            flowManager.getLocalFlows().forEach(flow -> {
                AtomicBoolean shouldSaveFlow = new AtomicBoolean(false);
                flow.getSteps().values().forEach(step -> {
                    if (StepDefinition.StepDefinitionType.MAPPING.equals((Object)step.getStepDefinitionType()) && "default-mapping".equalsIgnoreCase(step.getStepDefinitionName())) {
                        step.setStepDefinitionName("entity-services-mapping");
                        shouldSaveFlow.set(true);
                    }
                });
                if (shouldSaveFlow.get()) {
                    flowManager.saveLocalFlow((Flow)flow);
                }
            });
        }
        catch (Exception ex) {
            this.logger.warn("Error occurred while attempting to upgrade mapping steps to use 'entity-services-mapping' stepDefinitionType instead of 'default-mapping'; error: " + ex.getMessage());
            this.logger.warn("If you have any steps in flows with a stepDefinitionType of 'default-mapping', please change these to be 'entity-services-mapping' instead, as this is the preferred type for mapping steps as of DHF 5.1.0.");
        }
    }

    protected void removeEmptyRangeElementIndexArrayFromFinalDatabaseFile() {
        File dbFile = this.getUserConfigDir().resolve("databases").resolve("final-database.json").toFile();
        if (dbFile.exists()) {
            try {
                ObjectNode db = (ObjectNode)ObjectMapperFactory.getObjectMapper().readTree(dbFile);
                if (HubProjectImpl.hasEmptyRangeElementIndexArray(db)) {
                    this.logger.warn("Removing empty range-element-index array from final-database.json to avoid unnecessary reindexing");
                    db.remove("range-element-index");
                    ObjectMapperFactory.getObjectMapper().writeValue(dbFile, (Object)db);
                }
            }
            catch (Exception ex) {
                this.logger.warn("Unable to determine if final-database.json file has a range-element-index field with an empty array as its value; if it does, please remove this to avoid unnecessary reindexing; exception: " + ex.getMessage());
            }
        }
    }

    protected static boolean hasEmptyRangeElementIndexArray(ObjectNode db) {
        JsonNode node;
        if (db.has("range-element-index") && (node = db.get("range-element-index")) instanceof ArrayNode) {
            ArrayNode indexes = (ArrayNode)node;
            return indexes.isEmpty();
        }
        return false;
    }

    @Override
    public String getUserModulesDeployTimestampFile() {
        Path timestampPath = Paths.get(this.projectDirString, PROJECT_TMP_FOLDER, this.userModulesDeployTimestampFile);
        Path parentPath = timestampPath.getParent();
        if (parentPath == null) {
            return null;
        }
        File parentFile = parentPath.toFile();
        if (!parentFile.mkdirs() && !parentFile.exists()) {
            this.logger.warn("Unable to create parent directory at '" + parentFile.getAbsolutePath() + "' for module timestamp file.");
        }
        return timestampPath.toString();
    }

    @Override
    public void setUserModulesDeployTimestampFile(String userModulesDeployTimestampFile) {
        this.userModulesDeployTimestampFile = userModulesDeployTimestampFile;
    }

    @Override
    @Deprecated
    public Path getEntityDir(String entityName) {
        return this.getLegacyHubEntitiesDir().resolve(entityName);
    }

    @Override
    public Path getMappingDir(String mappingName) {
        return this.getHubMappingsDir().resolve(mappingName);
    }

    @Override
    public Path getLegacyMappingDir(String mappingName) {
        return this.getLegacyHubMappingsDir().resolve(mappingName);
    }

    @Override
    public Path getCustomModuleDir(String stepName, String stepType) {
        return this.getCustomModulesDir().resolve(stepType).resolve(stepName);
    }

    @Override
    public Path getProjectDir() {
        return this.projectDir;
    }

    @Override
    public Path getHubCentralConfigPath() {
        return this.projectDir.resolve("config");
    }

    @Override
    public Path getHubCentralConceptsPath() {
        return this.projectDir.resolve("concepts");
    }

    @Override
    public Path getStepsPath() {
        Path path = this.projectDir.resolve("steps");
        if (!path.toFile().exists()) {
            this.logger.warn("The steps directory does not exist: " + path);
        }
        return path;
    }

    @Override
    public Path getStepsPath(StepDefinition.StepDefinitionType type) {
        Path path;
        Path parent = this.getStepsPath();
        if (type == null) {
            throw new DataHubProjectException("Invalid Step type");
        }
        switch (type) {
            case CUSTOM: {
                path = parent.resolve("custom");
                break;
            }
            case INGESTION: {
                path = parent.resolve("ingestion");
                break;
            }
            case MAPPING: {
                path = parent.resolve("mapping");
                break;
            }
            case MASTERING: {
                path = parent.resolve("mastering");
                break;
            }
            case MATCHING: {
                path = parent.resolve("matching");
                break;
            }
            case MERGING: {
                path = parent.resolve("merging");
                break;
            }
            default: {
                throw new DataHubProjectException("Invalid Step type" + (Object)((Object)type));
            }
        }
        return path;
    }

    @Override
    public File getStepFile(StepDefinition.StepDefinitionType stepType, String stepName) {
        return this.getStepsPath().resolve(stepType.toString()).resolve(stepName + ".step.json").toFile();
    }
}

