/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.util;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.hub.impl.HubClientImpl;
import com.marklogic.hub.impl.HubConfigImpl;
import java.io.IOException;
import org.apache.hc.client5.http.classic.methods.HttpDelete;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.StringEntity;

public class CloudUtil
extends LoggingObject {
    private final HubConfigImpl hubConfig;

    public CloudUtil(HubConfigImpl hubConfig) {
        this.hubConfig = hubConfig;
    }

    /*
     * Exception decompiling
     */
    private String getAccessToken() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void waitForGateWayToRestart() {
        int maxTimeToWaitInMs = 10000;
        int maxRetries = 20;
        int sleepTime = maxTimeToWaitInMs / maxRetries;
        HubClientImpl hubClient = null;
        while (maxRetries > 0) {
            try {
                hubClient = hubClient == null ? (HubClientImpl)this.hubConfig.newHubClient() : hubClient;
                DatabaseClient databaseClient = hubClient.getHubClientConfig().newStagingClient(null);
                boolean connectionStatus = databaseClient.checkConnection().isConnected();
                this.logger.info("Connected to gateway: " + connectionStatus);
                if (connectionStatus) break;
                Thread.sleep(sleepTime);
                --maxRetries;
            }
            catch (Exception e) {
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.logger.info(e.getMessage());
                this.logger.info("waitForGateWayToRestart catch block");
                --maxRetries;
            }
        }
    }

    public void jsonPostRequest(String apiPath, String jsonBody) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        try (CloseableHttpClient httpClient = clientBuilder.build();){
            String url = "https://" + this.hubConfig.getHost() + apiPath;
            HttpPost postRequest = new HttpPost(url);
            StringEntity entity = new StringEntity(jsonBody);
            postRequest.setHeader("Content-Type", (Object)"application/json");
            String accessToken = this.getAccessToken();
            postRequest.setHeader("Authorization", (Object)("bearer " + accessToken));
            postRequest.setEntity((HttpEntity)entity);
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)postRequest);){
                this.logger.info(String.format("%s response code: %s", url, response.getCode()));
                this.logger.info(String.format("%s response phrase: %s", url, response.getReasonPhrase()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void deleteRequest(String apiPath) {
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        try (CloseableHttpClient httpClient = clientBuilder.build();){
            String url = "https://" + this.hubConfig.getHost() + apiPath;
            HttpDelete deleteRequest = new HttpDelete(url);
            String accessToken = this.getAccessToken();
            deleteRequest.setHeader("Authorization", (Object)("bearer " + accessToken));
            try (CloseableHttpResponse response = httpClient.execute((ClassicHttpRequest)deleteRequest);){
                this.logger.info(String.format("%s response code: %s", url, response.getCode()));
                this.logger.info(String.format("%s response phrase: %s", url, response.getReasonPhrase()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

