/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.command.CommandContext;
import com.marklogic.appdeployer.command.triggers.DeployTriggersCommand;
import com.marklogic.client.DatabaseClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.hub.deploy.commands.DeployHubAppServersCommand;
import java.util.Arrays;
import java.util.stream.Collectors;

public class RemoveOldTriggersCommand
extends DeployTriggersCommand {
    private final HubConfig hubConfig;
    private final String[] oldTriggersToRemove = new String[]{"ml-dh-json-mapping-create", "ml-dh-json-mapping-modify", "ml-dh-json-mapping-delete"};

    public RemoveOldTriggersCommand(HubConfig hubConfig, String triggersDatabase) {
        this.hubConfig = hubConfig;
        this.setDatabaseIdOrName(triggersDatabase);
        this.setExecuteSortOrder(new DeployHubAppServersCommand(hubConfig).getExecuteSortOrder() + 1);
    }

    public void execute(CommandContext context) {
        this.removeOldTriggers();
    }

    private void removeOldTriggers() {
        DatabaseClient finalClient = this.hubConfig.newFinalClient(this.hubConfig.getFinalTriggersDbName());
        DatabaseClient stagingClient = this.hubConfig.newStagingClient(this.hubConfig.getStagingTriggersDbName());
        String xquery = "xquery version \"1.0-ml\";\nimport module namespace trgr=\"http://marklogic.com/xdmp/triggers\" \n   at \"/MarkLogic/triggers.xqy\";\n\n";
        xquery = xquery + Arrays.stream(this.oldTriggersToRemove).map(oldTrigger -> "try { trgr:remove-trigger(\"" + oldTrigger + "\") } catch * {()}").collect(Collectors.joining(", "));
        finalClient.newServerEval().xquery(xquery).eval().close();
        stagingClient.newServerEval().xquery(xquery).eval().close();
    }
}

