/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.deploy.commands;

import com.marklogic.appdeployer.AppConfig;
import com.marklogic.appdeployer.command.AbstractCommand;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubConfig;
import com.marklogic.mgmt.resource.hosts.HostManager;
import java.util.HashSet;

public abstract class AbstractCacheClearingCommand
extends AbstractCommand {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearCache(HubConfig hubConfig, HubClient hubClient) {
        AppConfig mlAppConfig = hubConfig.getAppConfig();
        String originalHost = mlAppConfig.getHost();
        try {
            HashSet<String> hosts = new HashSet<String>(new HostManager(hubClient.getManageClient()).getHostNames());
            hosts.add(originalHost);
            hosts.forEach(host -> {
                try {
                    mlAppConfig.setHost(host);
                    this.logger.info("Clearing expanded tree cache on host: " + host);
                    mlAppConfig.newAppServicesDatabaseClient("Documents").newServerEval().xquery("xdmp:expanded-tree-cache-clear(),\nxdmp:module-cache-clear()").evalAs(String.class);
                }
                catch (Exception e) {
                    this.logger.info("Failed to clear expanded tree cache: " + e.getMessage());
                }
            });
        }
        finally {
            mlAppConfig.setHost(originalHost);
        }
    }
}

