/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface SecurityService {
    public static SecurityService on(DatabaseClient db) {
        return SecurityService.on(db, null);
    }

    public static SecurityService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class SecurityServiceImpl
        implements SecurityService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_describeRole;
            private BaseProxy.DBFunctionRequest req_describeUser;

            SecurityServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/security/", servDecl);
                this.req_describeRole = this.baseProxy.request("describeRole.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_describeUser = this.baseProxy.request("describeUser.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
            }

            @Override
            public JsonNode describeRole(String roleName) {
                return this.describeRole(this.req_describeRole.on(this.dbClient), roleName);
            }

            private JsonNode describeRole(BaseProxy.DBFunctionRequest request, String roleName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"roleName", (boolean)false, (String)BaseProxy.StringType.fromString((String)roleName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode describeUser(String username) {
                return this.describeUser(this.req_describeUser.on(this.dbClient), username);
            }

            private JsonNode describeUser(BaseProxy.DBFunctionRequest request, String username) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"username", (boolean)false, (String)BaseProxy.StringType.fromString((String)username))}).responseSingle(false, Format.JSON));
            }
        }
        return new SecurityServiceImpl(db, serviceDeclaration);
    }

    public JsonNode describeRole(String var1);

    public JsonNode describeUser(String var1);
}

