/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import java.util.stream.Stream;

public interface MasteringService {
    public static MasteringService on(DatabaseClient db) {
        return MasteringService.on(db, null);
    }

    public static MasteringService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class MasteringServiceImpl
        implements MasteringService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_calculateMergingActivity;
            private BaseProxy.DBFunctionRequest req_validateMatchingStep;
            private BaseProxy.DBFunctionRequest req_updateMergeOptions;
            private BaseProxy.DBFunctionRequest req_calculateMatchingActivity;
            private BaseProxy.DBFunctionRequest req_updateMatchOptions;
            private BaseProxy.DBFunctionRequest req_previewMatchingActivity;
            private BaseProxy.DBFunctionRequest req_getDefaultCollections;
            private BaseProxy.DBFunctionRequest req_validateMergingStep;

            MasteringServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/mastering/", servDecl);
                this.req_calculateMergingActivity = this.baseProxy.request("calculateMergingActivity.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_validateMatchingStep = this.baseProxy.request("validateMatchingStep.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_updateMergeOptions = this.baseProxy.request("updateMergeOptions.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_calculateMatchingActivity = this.baseProxy.request("calculateMatchingActivity.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_updateMatchOptions = this.baseProxy.request("updateMatchOptions.mjs", BaseProxy.ParameterValuesKind.SINGLE_NODE);
                this.req_previewMatchingActivity = this.baseProxy.request("previewMatchingActivity.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
                this.req_getDefaultCollections = this.baseProxy.request("getDefaultCollections.mjs", BaseProxy.ParameterValuesKind.SINGLE_ATOMIC);
                this.req_validateMergingStep = this.baseProxy.request("validateMergingStep.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_ATOMICS);
            }

            @Override
            public JsonNode calculateMergingActivity(String stepName) {
                return this.calculateMergingActivity(this.req_calculateMergingActivity.on(this.dbClient), stepName);
            }

            private JsonNode calculateMergingActivity(BaseProxy.DBFunctionRequest request, String stepName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode validateMatchingStep(String stepName) {
                return this.validateMatchingStep(this.req_validateMatchingStep.on(this.dbClient), stepName);
            }

            private JsonNode validateMatchingStep(BaseProxy.DBFunctionRequest request, String stepName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode updateMergeOptions(JsonNode options) {
                return this.updateMergeOptions(this.req_updateMergeOptions.on(this.dbClient), options);
            }

            private JsonNode updateMergeOptions(BaseProxy.DBFunctionRequest request, JsonNode options) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"options", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)options))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode calculateMatchingActivity(String stepName) {
                return this.calculateMatchingActivity(this.req_calculateMatchingActivity.on(this.dbClient), stepName);
            }

            private JsonNode calculateMatchingActivity(BaseProxy.DBFunctionRequest request, String stepName) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode updateMatchOptions(JsonNode options) {
                return this.updateMatchOptions(this.req_updateMatchOptions.on(this.dbClient), options);
            }

            private JsonNode updateMatchOptions(BaseProxy.DBFunctionRequest request, JsonNode options) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"options", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)options))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode previewMatchingActivity(Integer sampleSize, Stream<String> uris, String stepName, Boolean restrictToUris, Boolean nonMatches) {
                return this.previewMatchingActivity(this.req_previewMatchingActivity.on(this.dbClient), sampleSize, uris, stepName, restrictToUris, nonMatches);
            }

            private JsonNode previewMatchingActivity(BaseProxy.DBFunctionRequest request, Integer sampleSize, Stream<String> uris, String stepName, Boolean restrictToUris, Boolean nonMatches) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"sampleSize", (boolean)false, (String)BaseProxy.IntegerType.fromInteger((Integer)sampleSize)), BaseProxy.atomicParam((String)"uris", (boolean)true, (Stream)BaseProxy.StringType.fromString(uris)), BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName)), BaseProxy.atomicParam((String)"restrictToUris", (boolean)false, (String)BaseProxy.BooleanType.fromBoolean((Boolean)restrictToUris)), BaseProxy.atomicParam((String)"nonMatches", (boolean)false, (String)BaseProxy.BooleanType.fromBoolean((Boolean)nonMatches))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode getDefaultCollections(String entityType) {
                return this.getDefaultCollections(this.req_getDefaultCollections.on(this.dbClient), entityType);
            }

            private JsonNode getDefaultCollections(BaseProxy.DBFunctionRequest request, String entityType) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"entityType", (boolean)false, (String)BaseProxy.StringType.fromString((String)entityType))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode validateMergingStep(String stepName, String view, String entityPropertyPath) {
                return this.validateMergingStep(this.req_validateMergingStep.on(this.dbClient), stepName, view, entityPropertyPath);
            }

            private JsonNode validateMergingStep(BaseProxy.DBFunctionRequest request, String stepName, String view, String entityPropertyPath) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.atomicParam((String)"stepName", (boolean)false, (String)BaseProxy.StringType.fromString((String)stepName)), BaseProxy.atomicParam((String)"view", (boolean)false, (String)BaseProxy.StringType.fromString((String)view)), BaseProxy.atomicParam((String)"entityPropertyPath", (boolean)true, (String)BaseProxy.StringType.fromString((String)entityPropertyPath))}).responseSingle(false, Format.JSON));
            }
        }
        return new MasteringServiceImpl(db, serviceDeclaration);
    }

    public JsonNode calculateMergingActivity(String var1);

    public JsonNode validateMatchingStep(String var1);

    public JsonNode updateMergeOptions(JsonNode var1);

    public JsonNode calculateMatchingActivity(String var1);

    public JsonNode updateMatchOptions(JsonNode var1);

    public JsonNode previewMatchingActivity(Integer var1, Stream<String> var2, String var3, Boolean var4, Boolean var5);

    public JsonNode getDefaultCollections(String var1);

    public JsonNode validateMergingStep(String var1, String var2, String var3);
}

