/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.dataservices;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.impl.BaseProxy;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.BufferableContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;

public interface GraphService {
    public static GraphService on(DatabaseClient db) {
        return GraphService.on(db, null);
    }

    public static GraphService on(DatabaseClient db, JSONWriteHandle serviceDeclaration) {
        final class GraphServiceImpl
        implements GraphService {
            private DatabaseClient dbClient;
            private BaseProxy baseProxy;
            private BaseProxy.DBFunctionRequest req_nodeExpand;
            private BaseProxy.DBFunctionRequest req_searchNodes;
            private BaseProxy.DBFunctionRequest req_entitiesWithConceptsTypes;

            GraphServiceImpl(DatabaseClient dbClient, JSONWriteHandle servDecl) {
                this.dbClient = dbClient;
                this.baseProxy = new BaseProxy("/data-hub/data-services/graph/", servDecl);
                this.req_nodeExpand = this.baseProxy.request("nodeExpand.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_searchNodes = this.baseProxy.request("searchNodes.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
                this.req_entitiesWithConceptsTypes = this.baseProxy.request("entitiesWithConceptsTypes.mjs", BaseProxy.ParameterValuesKind.MULTIPLE_MIXED);
            }

            @Override
            public JsonNode nodeExpand(JsonNode nodeInfo, Integer limit) {
                return this.nodeExpand(this.req_nodeExpand.on(this.dbClient), nodeInfo, limit);
            }

            private JsonNode nodeExpand(BaseProxy.DBFunctionRequest request, JsonNode nodeInfo, Integer limit) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"nodeInfo", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)nodeInfo)), BaseProxy.atomicParam((String)"limit", (boolean)true, (String)BaseProxy.IntegerType.fromInteger((Integer)limit))}).responseSingle(false, Format.JSON));
            }

            @Override
            public String searchNodes(JsonNode query, Long start, Long pageLength, String structuredQuery, String queryOptions) {
                return this.searchNodes(this.req_searchNodes.on(this.dbClient), query, start, pageLength, structuredQuery, queryOptions);
            }

            private String searchNodes(BaseProxy.DBFunctionRequest request, JsonNode query, Long start, Long pageLength, String structuredQuery, String queryOptions) {
                return BaseProxy.JsonDocumentType.toString((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"query", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)query)), BaseProxy.atomicParam((String)"start", (boolean)false, (String)BaseProxy.LongType.fromLong((Long)start)), BaseProxy.atomicParam((String)"pageLength", (boolean)false, (String)BaseProxy.LongType.fromLong((Long)pageLength)), BaseProxy.atomicParam((String)"structuredQuery", (boolean)true, (String)BaseProxy.StringType.fromString((String)structuredQuery)), BaseProxy.atomicParam((String)"queryOptions", (boolean)true, (String)BaseProxy.StringType.fromString((String)queryOptions))}).responseSingle(false, Format.JSON));
            }

            @Override
            public JsonNode entitiesWithConceptsTypes(JsonNode query, String structuredQuery, String queryOptions) {
                return this.entitiesWithConceptsTypes(this.req_entitiesWithConceptsTypes.on(this.dbClient), query, structuredQuery, queryOptions);
            }

            private JsonNode entitiesWithConceptsTypes(BaseProxy.DBFunctionRequest request, JsonNode query, String structuredQuery, String queryOptions) {
                return BaseProxy.JsonDocumentType.toJsonNode((RESTServices.SingleCallResponse)request.withParams(new RESTServices.CallField[]{BaseProxy.documentParam((String)"query", (boolean)false, (BufferableContentHandle)BaseProxy.JsonDocumentType.fromJsonNode((JsonNode)query)), BaseProxy.atomicParam((String)"structuredQuery", (boolean)true, (String)BaseProxy.StringType.fromString((String)structuredQuery)), BaseProxy.atomicParam((String)"queryOptions", (boolean)true, (String)BaseProxy.StringType.fromString((String)queryOptions))}).responseSingle(false, Format.JSON));
            }
        }
        return new GraphServiceImpl(db, serviceDeclaration);
    }

    public JsonNode nodeExpand(JsonNode var1, Integer var2);

    public String searchNodes(JsonNode var1, Long var2, Long var3, String var4, String var5);

    public JsonNode entitiesWithConceptsTypes(JsonNode var1, String var2, String var3);
}

