/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.marklogic.appdeployer.AppConfig;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubProject;
import com.marklogic.hub.impl.HubConfigImpl;
import com.marklogic.hub.step.StepDefinition;
import com.marklogic.mgmt.ManageClient;
import com.marklogic.mgmt.admin.AdminManager;
import java.nio.file.Path;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;

@JsonDeserialize(as=HubConfigImpl.class)
@JsonSerialize(as=HubConfigImpl.class)
public interface HubConfig {
    public static final String USER_MODULES_DEPLOY_TIMESTAMPS_PROPERTIES = "user-modules-deploy-timestamps.properties";
    public static final String PATH_PREFIX = "src/main/";
    public static final String HUB_CONFIG_DIR = "src/main/hub-internal-config";
    public static final String USER_CONFIG_DIR = "src/main/ml-config";
    public static final String ENTITY_CONFIG_DIR = "src/main/entity-config";
    public static final String STAGING_ENTITY_QUERY_OPTIONS_FILE = "staging-entity-options.xml";
    public static final String FINAL_ENTITY_QUERY_OPTIONS_FILE = "final-entity-options.xml";
    public static final String EXP_STAGING_ENTITY_QUERY_OPTIONS_FILE = "exp-staging-entity-options.xml";
    public static final String EXP_FINAL_ENTITY_QUERY_OPTIONS_FILE = "exp-final-entity-options.xml";
    public static final String STAGING_ENTITY_DATABASE_FILE = "staging-database.json";
    public static final String FINAL_ENTITY_DATABASE_FILE = "final-database.json";
    public static final String DEFAULT_STAGING_NAME = "data-hub-STAGING";
    public static final String DEFAULT_FINAL_NAME = "data-hub-FINAL";
    public static final String DEFAULT_JOB_NAME = "data-hub-JOBS";
    public static final String DEFAULT_MODULES_DB_NAME = "data-hub-MODULES";
    public static final String DEFAULT_STAGING_TRIGGERS_DB_NAME = "data-hub-staging-TRIGGERS";
    public static final String DEFAULT_FINAL_TRIGGERS_DB_NAME = "data-hub-final-TRIGGERS";
    public static final String DEFAULT_STAGING_SCHEMAS_DB_NAME = "data-hub-staging-SCHEMAS";
    public static final String DEFAULT_FINAL_SCHEMAS_DB_NAME = "data-hub-final-SCHEMAS";
    public static final Integer DEFAULT_STAGING_PORT = 8010;
    public static final Integer DEFAULT_FINAL_PORT = 8011;
    public static final Integer DEFAULT_JOB_PORT = 8013;
    public static final String DEFAULT_AUTH_METHOD = "digest";
    public static final String DEFAULT_HUB_LOG_LEVEL = "default";
    public static final String DEFAULT_SCHEME = "http";
    public static final Integer DEFAULT_FORESTS_PER_HOST = 4;
    public static final String DEFAULT_CUSTOM_FOREST_PATH = "forests";
    public static final String PII_QUERY_ROLESET_FILE = "pii-reader.json";
    public static final String PII_PROTECTED_PATHS_FILE = "pii-protected-paths.json";

    public HubClient newHubClient();

    public DatabaseClient newAppServicesModulesClient();

    public String getHost();

    public String getDbName(DatabaseKind var1);

    public void setDbName(DatabaseKind var1, String var2);

    public String getHttpName(DatabaseKind var1);

    public void setHttpName(DatabaseKind var1, String var2);

    public Integer getForestsPerHost(DatabaseKind var1);

    public void setForestsPerHost(DatabaseKind var1, Integer var2);

    public Integer getPort(DatabaseKind var1);

    public void setPort(DatabaseKind var1, Integer var2);

    public SSLContext getSslContext(DatabaseKind var1);

    public void setSslContext(DatabaseKind var1, SSLContext var2);

    public void setSslHostnameVerifier(DatabaseKind var1, DatabaseClientFactory.SSLHostnameVerifier var2);

    public DatabaseClientFactory.SSLHostnameVerifier getSslHostnameVerifier(DatabaseKind var1);

    public String getAuthMethod(DatabaseKind var1);

    public void setAuthMethod(DatabaseKind var1, String var2);

    public X509TrustManager getTrustManager(DatabaseKind var1);

    public void setTrustManager(DatabaseKind var1, X509TrustManager var2);

    @Deprecated
    public String getScheme(DatabaseKind var1);

    @Deprecated
    public void setScheme(DatabaseKind var1, String var2);

    public boolean getSimpleSsl(DatabaseKind var1);

    public void setSimpleSsl(DatabaseKind var1, Boolean var2);

    public String getCertFile(DatabaseKind var1);

    public void setCertFile(DatabaseKind var1, String var2);

    public String getCertPassword(DatabaseKind var1);

    public void setCertPass(DatabaseKind var1, String var2);

    public String getExternalName(DatabaseKind var1);

    public void setExternalName(DatabaseKind var1, String var2);

    public Boolean getIsHostLoadBalancer();

    public Boolean getIsProvisionedEnvironment();

    public void setIsProvisionedEnvironment(boolean var1);

    public String getCustomForestPath();

    public String getModulePermissions();

    public String getEntityModelPermissions();

    public String getFlowPermissions();

    public String getMappingPermissions();

    public String getStepDefinitionPermissions();

    public String getProjectDir();

    public void setProjectDir(String var1);

    public HubProject getHubProject();

    public void initHubProject();

    public DatabaseClient newAppServicesClient();

    public DatabaseClient newJobDbClient();

    @Deprecated
    public DatabaseClient newTraceDbClient();

    public DatabaseClient newModulesDbClient();

    public Path getModulesDir();

    public Path getHubPluginsDir();

    public Path getHubEntitiesDir();

    public Path getHubMappingsDir();

    public Path getStepDefinitionPath(StepDefinition.StepDefinitionType var1);

    public Path getHubConfigDir();

    public Path getHubDatabaseDir();

    public Path getHubServersDir();

    public Path getHubSecurityDir();

    public Path getUserConfigDir();

    public Path getUserSecurityDir();

    public Path getUserDatabaseDir();

    public Path getUserSchemasDir();

    public Path getUserServersDir();

    public Path getEntityDatabaseDir();

    public Path getFlowsDir();

    public Path getStepDefinitionsDir();

    @JsonIgnore
    public AppConfig getAppConfig();

    public void setAppConfig(AppConfig var1);

    public void setAppConfig(AppConfig var1, boolean var2);

    public String getJarVersion();

    public String getHubLogLevel();

    public DatabaseClient newStagingClient();

    public DatabaseClient newStagingClient(String var1);

    public String getStagingTriggersDbName();

    public String getFinalTriggersDbName();

    public AdminManager getAdminManager();

    public ManageClient getManageClient();

    public DatabaseClient newReverseFlowClient();

    public DatabaseClient newFinalClient();

    public DatabaseClient newFinalClient(String var1);

    public String getInfo();

    public void createProject(String var1);

    public HubConfig withPropertiesFromEnvironment(String var1);

    public void refreshProject();
}

