/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.hub.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.hub.DatabaseKind;
import com.marklogic.hub.HubClient;
import com.marklogic.hub.HubClientConfig;
import com.marklogic.mgmt.ManageClient;
import java.util.Map;

public class HubClientImpl
implements HubClient {
    private final HubClientConfig hubClientConfig;
    private String username;
    private String mlAuthentication;
    private DatabaseClient stagingClient;
    private DatabaseClient finalClient;
    private DatabaseClient jobsClient;
    private DatabaseClient modulesClient;
    private Map<DatabaseKind, String> databaseNames;
    private ManageClient manageClient;

    public HubClientImpl(HubClientConfig hubClientConfig) {
        this.hubClientConfig = hubClientConfig;
        this.username = hubClientConfig.getUsername();
        this.mlAuthentication = hubClientConfig.getMlAuthentication();
        this.stagingClient = hubClientConfig.newStagingClient(null);
        this.finalClient = hubClientConfig.newFinalClient(null);
        this.jobsClient = hubClientConfig.newJobDbClient();
        this.modulesClient = hubClientConfig.newModulesDbClient();
        this.databaseNames = hubClientConfig.getDatabaseNames();
        this.manageClient = new ManageClient(hubClientConfig.getManageConfig());
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getMlAuthentication() {
        return this.mlAuthentication;
    }

    @Override
    public String getDbName(DatabaseKind kind) {
        return this.databaseNames.get((Object)kind);
    }

    @Override
    public DatabaseClient getStagingClient() {
        return this.stagingClient;
    }

    @Override
    public DatabaseClient getStagingClient(String databaseName) {
        return this.hubClientConfig.newStagingClient(databaseName);
    }

    @Override
    public DatabaseClient getFinalClient() {
        return this.finalClient;
    }

    @Override
    public DatabaseClient getJobsClient() {
        return this.jobsClient;
    }

    @Override
    public DatabaseClient getModulesClient() {
        return this.modulesClient;
    }

    @Override
    public ManageClient getManageClient() {
        return this.manageClient;
    }

    public HubClientConfig getHubClientConfig() {
        return this.hubClientConfig;
    }
}

