/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl.okhttp;

import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.impl.IoUtil;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.mail.BodyPart;
import jakarta.mail.MessagingException;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.util.ByteArrayDataSource;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import okhttp3.Headers;
import okhttp3.MultipartReader;

public class PartIterator
implements Iterator<BodyPart> {
    private final MultipartReader reader;
    private BodyPart nextBodyPart;

    public PartIterator(MultipartReader reader) {
        this.reader = reader;
        this.readNextPart();
    }

    @Override
    public boolean hasNext() {
        return this.nextBodyPart != null;
    }

    @Override
    public BodyPart next() {
        BodyPart partToReturn = this.nextBodyPart;
        this.readNextPart();
        return partToReturn;
    }

    private void readNextPart() {
        try {
            MultipartReader.Part nextPart = this.reader.nextPart();
            this.nextBodyPart = nextPart != null ? PartIterator.convertPartToBodyPart(nextPart) : null;
        }
        catch (Exception e) {
            throw new MarkLogicIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static BodyPart convertPartToBodyPart(MultipartReader.Part part) throws IOException, MessagingException {
        MimeBodyPart bodyPart = new MimeBodyPart();
        try {
            InputStream inputStream = part.body().inputStream();
            Object object = null;
            try {
                byte[] bytes = IoUtil.streamToBytes(inputStream);
                bodyPart.setDataHandler(new DataHandler((DataSource)new ByteArrayDataSource(bytes, part.headers().get("Content-Type"))));
            }
            catch (Throwable bytes) {
                object = bytes;
                throw bytes;
            }
            finally {
                if (inputStream != null) {
                    if (object != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable bytes) {
                            ((Throwable)object).addSuppressed(bytes);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
            Headers headers = part.headers();
            for (String headerName : headers.names()) {
                for (String headerValue : headers.values(headerName)) {
                    bodyPart.addHeader(headerName, headerValue);
                }
            }
            object = bodyPart;
            return object;
        }
        finally {
            part.close();
        }
    }
}

