/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.marker.BinaryReadHandle;
import com.marklogic.client.io.marker.BinaryWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.ContentHandleFactory;
import com.marklogic.client.io.marker.CtsQueryWriteHandle;
import com.marklogic.client.io.marker.GenericReadHandle;
import com.marklogic.client.io.marker.GenericWriteHandle;
import com.marklogic.client.io.marker.JSONReadHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.QuadsWriteHandle;
import com.marklogic.client.io.marker.ResendableContentHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.io.marker.StructureWriteHandle;
import com.marklogic.client.io.marker.TextReadHandle;
import com.marklogic.client.io.marker.TextWriteHandle;
import com.marklogic.client.io.marker.TriplesReadHandle;
import com.marklogic.client.io.marker.TriplesWriteHandle;
import com.marklogic.client.io.marker.XMLReadHandle;
import com.marklogic.client.io.marker.XMLWriteHandle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public class FileHandle
extends BaseHandle<File, File>
implements ResendableContentHandle<File, File>,
BinaryReadHandle,
BinaryWriteHandle,
GenericReadHandle,
GenericWriteHandle,
JSONReadHandle,
JSONWriteHandle,
TextReadHandle,
TextWriteHandle,
XMLReadHandle,
XMLWriteHandle,
StructureReadHandle,
StructureWriteHandle,
CtsQueryWriteHandle,
QuadsWriteHandle,
TriplesReadHandle,
TriplesWriteHandle {
    private File content;

    public static ContentHandleFactory newFactory() {
        return new ContentHandleFactory(){

            @Override
            public Class<?>[] getHandledClasses() {
                return new Class[]{File.class};
            }

            @Override
            public boolean isHandled(Class<?> type) {
                return File.class.isAssignableFrom(type);
            }

            @Override
            public <C> ContentHandle<C> newHandle(Class<C> type) {
                FileHandle handle = this.isHandled(type) ? new FileHandle() : null;
                return handle;
            }
        };
    }

    public FileHandle() {
        this.setResendable(true);
    }

    public FileHandle(File content) {
        this();
        this.set(content);
    }

    @Override
    public File get() {
        return this.content;
    }

    @Override
    public void set(File content) {
        this.content = content;
    }

    public FileHandle with(File content) {
        this.set(content);
        return this;
    }

    @Override
    public Class<File> getContentClass() {
        return File.class;
    }

    @Override
    public FileHandle newHandle() {
        return new FileHandle().withFormat(this.getFormat()).withMimetype(this.getMimetype());
    }

    public FileHandle[] newHandleArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new FileHandle[length];
    }

    public File[] newArray(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("array length less than zero: " + length);
        }
        return new File[length];
    }

    public FileHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    public FileHandle withMimetype(String mimetype) {
        this.setMimetype(mimetype);
        return this;
    }

    @Override
    public File toContent(File serialization) {
        return serialization;
    }

    @Override
    protected Class<File> receiveAs() {
        return File.class;
    }

    @Override
    protected void receiveContent(File content) {
        this.set(this.toContent(content));
    }

    @Override
    protected File sendContent() {
        if (this.get() == null) {
            throw new IllegalStateException("No file to write");
        }
        return this.get();
    }

    @Override
    public void fromBuffer(byte[] buffer) {
        this.set(this.bytesToContent(buffer));
    }

    @Override
    public byte[] toBuffer() {
        return this.contentToBytes(this.get());
    }

    @Override
    public File bytesToContent(byte[] buffer) {
        if (buffer == null || buffer.length == 0) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(buffer);
        return NodeConverter.InputStreamToFile(byteArrayInputStream);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public byte[] contentToBytes(File content) {
        if (content == null) {
            return null;
        }
        try (InputStreamHandle inputStreamHandle = new InputStreamHandle(new FileInputStream(content));){
            byte[] byArray = inputStreamHandle.toBuffer();
            return byArray;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }
}

