/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Forest;
import com.marklogic.client.datamovement.ForestConfiguration;
import com.marklogic.client.datamovement.impl.ForestImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class FilteredForestConfiguration
implements ForestConfiguration {
    ForestConfiguration wrappedForestConfig;
    Set<String> blackList = new HashSet<String>();
    Set<String> whiteList = new HashSet<String>();
    Map<String, String> renames = new HashMap<String, String>();

    public FilteredForestConfiguration(ForestConfiguration forestConfig) {
        this.wrappedForestConfig = forestConfig;
    }

    @Override
    public Forest[] listForests() {
        Forest[] renamedForests = (Forest[])Stream.of(this.wrappedForestConfig.listForests()).map(forest -> {
            String host;
            String alternateHost;
            String requestHost;
            String openReplicaHost = forest.getOpenReplicaHost();
            if (openReplicaHost != null) {
                openReplicaHost = openReplicaHost.toLowerCase();
            }
            if (this.renames.containsKey(openReplicaHost)) {
                openReplicaHost = this.renames.get(openReplicaHost);
            }
            if ((requestHost = forest.getRequestHost()) != null) {
                requestHost = requestHost.toLowerCase();
            }
            if (this.renames.containsKey(requestHost)) {
                requestHost = this.renames.get(requestHost);
            }
            if ((alternateHost = forest.getAlternateHost()) != null) {
                alternateHost = alternateHost.toLowerCase();
            }
            if (this.renames.containsKey(alternateHost)) {
                alternateHost = this.renames.get(alternateHost);
            }
            if ((host = forest.getHost()) != null) {
                host = host.toLowerCase();
            }
            if (this.renames.containsKey(host)) {
                host = this.renames.get(host);
            }
            return new ForestImpl(host, openReplicaHost, requestHost, alternateHost, forest.getDatabaseName(), forest.getForestName(), forest.getForestId(), forest.isUpdateable(), false);
        }).toArray(Forest[]::new);
        String[] validHosts = (String[])Stream.of(renamedForests).flatMap(forest -> {
            String[] hostArray = (this.blackList.contains(forest.getPreferredHost()) || this.blackList.contains(forest.getHost())) && forest.getPreferredHostType() == Forest.HostType.REQUEST_HOST ? new String[]{forest.getOpenReplicaHost(), forest.getAlternateHost()} : new String[]{forest.getHost(), forest.getOpenReplicaHost(), forest.getAlternateHost(), forest.getRequestHost()};
            return Stream.of(hostArray).filter(host -> host != null).map(host -> host.toLowerCase()).filter(host -> {
                if (this.whiteList.size() > 0 && !this.whiteList.contains(host)) {
                    return false;
                }
                return !this.blackList.contains(host);
            });
        }).distinct().toArray(String[]::new);
        Stream<Forest> replaced = Stream.of(renamedForests);
        if (this.blackList.size() > 0) {
            replaced = replaced.map(forest -> {
                if (this.blackList.contains(forest.getPreferredHost()) || forest.getPreferredHostType() == Forest.HostType.REQUEST_HOST && this.blackList.contains(forest.getHost())) {
                    String alternateHost;
                    if (validHosts.length == 0) {
                        throw new IllegalStateException("White list or black list rules are too restrictive: no valid hosts are left");
                    }
                    String openReplicaHost = forest.getOpenReplicaHost();
                    if (this.blackList.contains(openReplicaHost)) {
                        openReplicaHost = this.replaceHost(openReplicaHost, validHosts);
                    }
                    String requestHost = forest.getRequestHost();
                    String host = forest.getHost();
                    if (this.blackList.contains(requestHost)) {
                        host = requestHost = this.replaceHost(requestHost, validHosts);
                    }
                    if (this.blackList.contains(alternateHost = forest.getAlternateHost())) {
                        alternateHost = this.replaceHost(alternateHost, validHosts);
                    }
                    if (this.blackList.contains(host)) {
                        host = this.replaceHost(host, validHosts);
                        if (requestHost != null) {
                            requestHost = host;
                        }
                    }
                    return new ForestImpl(host, openReplicaHost, requestHost, alternateHost, forest.getDatabaseName(), forest.getForestName(), forest.getForestId(), forest.isUpdateable(), false);
                }
                return forest;
            });
        }
        if (this.whiteList.size() > 0) {
            replaced = replaced.map(forest -> {
                if (!this.whiteList.contains(forest.getPreferredHost())) {
                    String host;
                    String alternateHost;
                    String requestHost;
                    if (validHosts.length == 0) {
                        throw new IllegalStateException("White list or black list rules are too restrictive: no valid hosts are left");
                    }
                    String openReplicaHost = forest.getOpenReplicaHost();
                    if (!this.whiteList.contains(openReplicaHost)) {
                        openReplicaHost = this.replaceHost(openReplicaHost, validHosts);
                    }
                    if (!this.whiteList.contains(requestHost = forest.getRequestHost())) {
                        requestHost = this.replaceHost(requestHost, validHosts);
                    }
                    if (!this.whiteList.contains(alternateHost = forest.getAlternateHost())) {
                        alternateHost = this.replaceHost(alternateHost, validHosts);
                    }
                    if (!this.whiteList.contains(host = forest.getHost())) {
                        host = this.replaceHost(host, validHosts);
                    }
                    return new ForestImpl(host, openReplicaHost, requestHost, alternateHost, forest.getDatabaseName(), forest.getForestName(), forest.getForestId(), forest.isUpdateable(), false);
                }
                return forest;
            });
        }
        return (Forest[])replaced.toArray(Forest[]::new);
    }

    private String replaceHost(String invalidHost, String[] validHosts) {
        if (invalidHost == null) {
            return null;
        }
        int charSum = 0;
        for (char c : invalidHost.toCharArray()) {
            charSum += c;
        }
        int replacementHostPosition = charSum % validHosts.length;
        return validHosts[replacementHostPosition];
    }

    public FilteredForestConfiguration withBlackList(String ... hostNames) {
        if (this.whiteList.size() > 0) {
            throw new IllegalStateException("whiteList already initialized");
        }
        if (hostNames == null) {
            throw new IllegalArgumentException("hostNames must not be null");
        }
        for (String hostName : hostNames) {
            if (hostName == null) continue;
            this.blackList.add(hostName.toLowerCase());
        }
        return this;
    }

    public FilteredForestConfiguration withWhiteList(String ... hostNames) {
        if (this.blackList.size() > 0) {
            throw new IllegalStateException("blackList already initialized");
        }
        if (hostNames == null) {
            throw new IllegalArgumentException("hostNames must not be null");
        }
        for (String hostName : hostNames) {
            if (hostName == null) continue;
            this.whiteList.add(hostName.toLowerCase());
        }
        return this;
    }

    public FilteredForestConfiguration withRenamedHost(String hostName, String targetHostName) {
        if (hostName == null) {
            throw new IllegalArgumentException("hostName must not be null");
        }
        if (targetHostName == null) {
            throw new IllegalArgumentException("targetHostName must not be null");
        }
        this.renames.put(hostName.toLowerCase(), targetHostName.toLowerCase());
        return this;
    }
}

