/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.io;

import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.OperationNotSupported;
import com.marklogic.client.io.marker.QueryOptionsListReadHandle;
import com.marklogic.client.query.QueryOptionsListBuilder;
import com.marklogic.client.query.QueryOptionsListResults;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryOptionsListHandle
extends BaseHandle<InputStream, OperationNotSupported>
implements QueryOptionsListReadHandle,
QueryOptionsListResults {
    private static final Logger logger = LoggerFactory.getLogger(QueryOptionsListHandle.class);
    private QueryOptionsListBuilder.OptionsList optionsHolder;
    private Marshaller marshaller;
    private Unmarshaller unmarshaller;

    public QueryOptionsListHandle() {
        super.setFormat(Format.XML);
        try {
            JAXBContext jc = JaxbContextLoader.CACHED_CONTEXT;
            this.marshaller = jc.createMarshaller();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)true);
            this.unmarshaller = jc.createUnmarshaller();
        }
        catch (JAXBException e) {
            throw new MarkLogicBindingException((Exception)((Object)e));
        }
        catch (NoClassDefFoundError ncdfe) {
            throw new MarkLogicBindingException((Exception)((Object)new JAXBException("JAXB context initialization failed")));
        }
    }

    @Override
    public void setFormat(Format format) {
        if (format != Format.XML) {
            throw new IllegalArgumentException("QueryOptionsListHandle supports the XML format only");
        }
    }

    public QueryOptionsListHandle withFormat(Format format) {
        this.setFormat(format);
        return this;
    }

    @Override
    protected Class<InputStream> receiveAs() {
        return InputStream.class;
    }

    @Override
    protected void receiveContent(InputStream content) {
        try {
            this.optionsHolder = (QueryOptionsListBuilder.OptionsList)this.unmarshaller.unmarshal((Reader)new InputStreamReader(content, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            logger.error("Failed to unmarshall query options list", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
        catch (JAXBException e) {
            logger.error("Failed to unmarshall query options list", (Throwable)e);
            throw new MarkLogicIOException(e);
        }
    }

    @Override
    public HashMap<String, String> getValuesMap() {
        if (this.optionsHolder == null) {
            return null;
        }
        return this.optionsHolder.getOptionsMap();
    }

    private static class JaxbContextLoader {
        private static final JAXBContext CACHED_CONTEXT;

        private JaxbContextLoader() {
        }

        static {
            try {
                CACHED_CONTEXT = JAXBContext.newInstance((Class[])new Class[]{QueryOptionsListBuilder.OptionsList.class});
            }
            catch (JAXBException e) {
                throw new MarkLogicBindingException((Exception)((Object)e));
            }
        }
    }
}

