/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.impl;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marklogic.client.DatabaseClientFactory;
import com.marklogic.client.MarkLogicBindingException;
import com.marklogic.client.MarkLogicIOException;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.Transaction;
import com.marklogic.client.expression.PlanBuilder;
import com.marklogic.client.impl.AbstractLoggingManager;
import com.marklogic.client.impl.BaseTypeImpl;
import com.marklogic.client.impl.PlanBuilderBaseImpl;
import com.marklogic.client.impl.PlanBuilderSubImpl;
import com.marklogic.client.impl.RESTServices;
import com.marklogic.client.impl.XsValueImpl;
import com.marklogic.client.io.BaseHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.InputStreamHandle;
import com.marklogic.client.io.StringHandle;
import com.marklogic.client.io.XMLStreamReaderHandle;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import com.marklogic.client.io.marker.ContentHandle;
import com.marklogic.client.io.marker.JSONWriteHandle;
import com.marklogic.client.io.marker.StructureReadHandle;
import com.marklogic.client.row.RawPlanDefinition;
import com.marklogic.client.row.RowManager;
import com.marklogic.client.row.RowRecord;
import com.marklogic.client.row.RowSet;
import com.marklogic.client.type.PlanExprCol;
import com.marklogic.client.type.PlanParamBindingVal;
import com.marklogic.client.type.PlanParamExpr;
import com.marklogic.client.type.XsAnyAtomicTypeVal;
import com.marklogic.client.util.RequestParameters;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class RowManagerImpl
extends AbstractLoggingManager
implements RowManager {
    private RESTServices services;
    private DatabaseClientFactory.HandleFactoryRegistry handleRegistry;
    private RowManager.RowSetPart datatypeStyle = null;
    private RowManager.RowStructure rowStructureStyle = null;

    public RowManagerImpl(RESTServices services) {
        this.services = services;
    }

    DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
        return this.handleRegistry;
    }

    void setHandleRegistry(DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
        this.handleRegistry = handleRegistry;
    }

    @Override
    public PlanBuilder newPlanBuilder() {
        PlanBuilderSubImpl planBuilder = new PlanBuilderSubImpl();
        planBuilder.setHandleRegistry(this.handleRegistry);
        return planBuilder;
    }

    @Override
    public RowManager.RowSetPart getDatatypeStyle() {
        if (this.datatypeStyle == null) {
            return RowManager.RowSetPart.ROWS;
        }
        return this.datatypeStyle;
    }

    @Override
    public void setDatatypeStyle(RowManager.RowSetPart style) {
        this.datatypeStyle = style;
    }

    @Override
    public RowManager.RowStructure getRowStructureStyle() {
        if (this.rowStructureStyle == null) {
            return RowManager.RowStructure.OBJECT;
        }
        return this.rowStructureStyle;
    }

    @Override
    public void setRowStructureStyle(RowManager.RowStructure style) {
        this.rowStructureStyle = style;
    }

    @Override
    public RawPlanDefinition newRawPlanDefinition(JSONWriteHandle handle) {
        return new RawPlanDefinitionImpl(handle);
    }

    @Override
    public <T> T resultDocAs(PlanBuilder.Plan plan, Class<T> as) {
        return this.resultDocAs(plan, as, null);
    }

    @Override
    public <T> T resultDocAs(PlanBuilder.Plan plan, Class<T> as, Transaction transaction) {
        ContentHandle<T> handle = this.handleFor(as);
        if (this.resultDoc(plan, (StructureReadHandle)((Object)handle), transaction) == null) {
            return null;
        }
        return handle.get();
    }

    @Override
    public <T extends StructureReadHandle> T resultDoc(PlanBuilder.Plan plan, T resultsHandle) {
        return this.resultDoc(plan, resultsHandle, null);
    }

    @Override
    public <T extends StructureReadHandle> T resultDoc(PlanBuilder.Plan plan, T resultsHandle, Transaction transaction) {
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        if (resultsHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to read the row result document");
        }
        RequestParameters params = this.getParamBindings(requestPlan);
        this.addDatatypeStyleParam(params, this.getDatatypeStyle());
        this.addRowStructureStyleParam(params, this.getRowStructureStyle());
        return this.services.postResource(this.requestLogger, "rows", transaction, params, astHandle, resultsHandle);
    }

    @Override
    public RowSet<RowRecord> resultRows(PlanBuilder.Plan plan) {
        return this.resultRows(plan, (StructureReadHandle)null);
    }

    @Override
    public RowSet<RowRecord> resultRows(PlanBuilder.Plan plan, Transaction transaction) {
        RowManager.RowSetPart datatypeStyle = this.getDatatypeStyle();
        RowManager.RowStructure rowStructureStyle = this.getRowStructureStyle();
        RESTServices.RESTServiceResultIterator iter = this.makeRequest(plan, "json", datatypeStyle, rowStructureStyle, "reference", transaction);
        RowSetRecord rowset = new RowSetRecord("json", datatypeStyle, rowStructureStyle, iter, this.handleRegistry);
        rowset.init();
        return rowset;
    }

    @Override
    public <T extends StructureReadHandle> RowSet<T> resultRows(PlanBuilder.Plan plan, T rowHandle) {
        return this.resultRows(plan, rowHandle, null);
    }

    @Override
    public <T extends StructureReadHandle> RowSet<T> resultRows(PlanBuilder.Plan plan, T rowHandle, Transaction transaction) {
        RowManager.RowSetPart datatypeStyle = this.getDatatypeStyle();
        RowManager.RowStructure rowStructureStyle = this.getRowStructureStyle();
        String rowFormat = this.getRowFormat(rowHandle);
        RESTServices.RESTServiceResultIterator iter = this.makeRequest(plan, rowFormat, datatypeStyle, rowStructureStyle, "inline", transaction);
        RowSetHandle<T> rowset = new RowSetHandle<T>(rowFormat, datatypeStyle, rowStructureStyle, iter, rowHandle);
        rowset.init();
        return rowset;
    }

    @Override
    public <T> RowSet<T> resultRowsAs(PlanBuilder.Plan plan, Class<T> as) {
        return this.resultRowsAs(plan, as, null);
    }

    @Override
    public <T> RowSet<T> resultRowsAs(PlanBuilder.Plan plan, Class<T> as, Transaction transaction) {
        RowManager.RowSetPart datatypeStyle = this.getDatatypeStyle();
        RowManager.RowStructure rowStructureStyle = this.getRowStructureStyle();
        ContentHandle<T> rowHandle = this.handleFor(as);
        String rowFormat = this.getRowFormat(rowHandle);
        RESTServices.RESTServiceResultIterator iter = this.makeRequest(plan, rowFormat, datatypeStyle, rowStructureStyle, "inline", transaction);
        RowSetObject<T> rowset = new RowSetObject<T>(rowFormat, datatypeStyle, rowStructureStyle, iter, rowHandle);
        rowset.init();
        return rowset;
    }

    @Override
    public <T extends StructureReadHandle> T explain(PlanBuilder.Plan plan, T resultsHandle) {
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        if (resultsHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to read the explanation for the plan");
        }
        RequestParameters params = new RequestParameters();
        params.add("output", "explain");
        return this.services.postResource(this.requestLogger, "rows", null, params, astHandle, resultsHandle);
    }

    @Override
    public <T> T explainAs(PlanBuilder.Plan plan, Class<T> as) {
        ContentHandle<T> handle = this.handleFor(as);
        if (this.explain(plan, (StructureReadHandle)((Object)handle)) == null) {
            return null;
        }
        return handle.get();
    }

    private void addDatatypeStyleParam(RequestParameters params, RowManager.RowSetPart datatypeStyle) {
        if (datatypeStyle != null) {
            switch (datatypeStyle) {
                case HEADER: {
                    params.add("column-types", "header");
                    break;
                }
                case ROWS: {
                    params.add("column-types", "rows");
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown data type style: " + datatypeStyle);
                }
            }
        }
    }

    private void addRowStructureStyleParam(RequestParameters params, RowManager.RowStructure rowStructureStyle) {
        if (rowStructureStyle != null) {
            switch (rowStructureStyle) {
                case ARRAY: {
                    params.add("output", "array");
                    break;
                }
                case OBJECT: {
                    params.add("output", "object");
                    break;
                }
                default: {
                    throw new IllegalStateException("unknown row structure style: " + rowStructureStyle);
                }
            }
        }
    }

    private <T extends AbstractReadHandle> String getRowFormat(T rowHandle) {
        if (rowHandle == null) {
            throw new IllegalArgumentException("Must specify a handle to iterate over the rows");
        }
        if (!(rowHandle instanceof BaseHandle)) {
            throw new IllegalArgumentException("Cannot iterate rows with invalid handle having class " + rowHandle.getClass().getName());
        }
        BaseHandle baseHandle = (BaseHandle)((Object)rowHandle);
        Format handleFormat = baseHandle.getFormat();
        switch (handleFormat) {
            case JSON: 
            case UNKNOWN: {
                return "json";
            }
            case XML: {
                return "xml";
            }
        }
        throw new IllegalArgumentException("Must use JSON or XML format to iterate rows instead of " + handleFormat.name());
    }

    private RESTServices.RESTServiceResultIterator makeRequest(PlanBuilder.Plan plan, String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, String nodeCols, Transaction transaction) {
        PlanBuilderBaseImpl.RequestPlan requestPlan = this.checkPlan(plan);
        AbstractWriteHandle astHandle = requestPlan.getHandle();
        RequestParameters params = this.getParamBindings(requestPlan);
        params.add("row-format", rowFormat);
        params.add("node-columns", nodeCols);
        this.addDatatypeStyleParam(params, datatypeStyle);
        this.addRowStructureStyleParam(params, rowStructureStyle);
        return this.services.postIteratedResource(this.requestLogger, "rows", transaction, params, astHandle, new String[0]);
    }

    private PlanBuilderBaseImpl.RequestPlan checkPlan(PlanBuilder.Plan plan) {
        if (plan == null) {
            throw new IllegalArgumentException("Must specify a plan to produce row results");
        }
        if (!(plan instanceof PlanBuilderBaseImpl.RequestPlan)) {
            throw new IllegalArgumentException("Cannot produce rows with invalid plan having class " + plan.getClass().getName());
        }
        return (PlanBuilderBaseImpl.RequestPlan)((Object)plan);
    }

    private RequestParameters getParamBindings(PlanBuilderBaseImpl.RequestPlan requestPlan) {
        RequestParameters params = new RequestParameters();
        Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> planParams = requestPlan.getParams();
        if (planParams != null) {
            for (Map.Entry<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> entry : planParams.entrySet()) {
                BaseTypeImpl.ParamBinder binder = entry.getValue();
                StringBuilder nameBuf = new StringBuilder("bind:");
                nameBuf.append(entry.getKey().getName());
                String paramQual = binder.getParamQualifier();
                if (paramQual != null) {
                    nameBuf.append(paramQual);
                }
                params.add(nameBuf.toString(), binder.getParamValue());
            }
        }
        return params;
    }

    <T> ContentHandle<T> handleFor(Class<T> as) {
        if (as == null) {
            throw new IllegalArgumentException("Must specify a class for content with a registered handle");
        }
        ContentHandle<T> handle = this.handleRegistry.makeHandle(as);
        if (!(handle instanceof StructureReadHandle)) {
            if (handle == null) {
                throw new IllegalArgumentException("Class \"" + as.getName() + "\" has no registered handle");
            }
            throw new IllegalArgumentException("Class \"" + as.getName() + "\" uses handle " + handle.getClass().getName() + " which is not a StructureReadHandle");
        }
        return handle;
    }

    private static class NodeNotAStringException
    extends Exception {
        private NodeNotAStringException() {
        }
    }

    static class RawPlanDefinitionImpl
    implements RawPlanDefinition,
    PlanBuilderBaseImpl.RequestPlan {
        private Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params = null;
        private JSONWriteHandle handle = null;

        RawPlanDefinitionImpl(JSONWriteHandle handle) {
            this.setHandle(handle);
        }

        private RawPlanDefinitionImpl(JSONWriteHandle handle, Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> params) {
            this(handle);
            this.params = params;
        }

        @Override
        public Map<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> getParams() {
            return this.params;
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, boolean literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, boolean literal) {
            return this.bindParam(param, new XsValueImpl.BooleanValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, byte literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, byte literal) {
            return this.bindParam(param, new XsValueImpl.ByteValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, double literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, double literal) {
            return this.bindParam(param, new XsValueImpl.DoubleValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, float literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, float literal) {
            return this.bindParam(param, new XsValueImpl.FloatValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, int literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, int literal) {
            return this.bindParam(param, new XsValueImpl.IntValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, long literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, long literal) {
            return this.bindParam(param, new XsValueImpl.LongValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, short literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, short literal) {
            return this.bindParam(param, new XsValueImpl.ShortValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(String paramName, String literal) {
            return this.bindParam((PlanParamExpr)new PlanBuilderBaseImpl.PlanParamBase(paramName), literal);
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, String literal) {
            return this.bindParam(param, new XsValueImpl.StringValImpl(literal));
        }

        @Override
        public PlanBuilder.Plan bindParam(PlanParamExpr param, PlanParamBindingVal literal) {
            if (!(param instanceof PlanBuilderBaseImpl.PlanParamBase)) {
                throw new IllegalArgumentException("cannot set parameter that doesn't extend base");
            }
            if (!(literal instanceof XsValueImpl.AnyAtomicTypeValImpl)) {
                throw new IllegalArgumentException("cannot set value with unknown implementation");
            }
            HashMap<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder> nextParams = new HashMap<PlanBuilderBaseImpl.PlanParamBase, BaseTypeImpl.ParamBinder>();
            if (this.params != null) {
                nextParams.putAll(this.params);
            }
            nextParams.put((PlanBuilderBaseImpl.PlanParamBase)param, (XsValueImpl.AnyAtomicTypeValImpl)((Object)literal));
            return new RawPlanDefinitionImpl(this.getHandle(), nextParams);
        }

        @Override
        public JSONWriteHandle getHandle() {
            return this.handle;
        }

        @Override
        public void setHandle(JSONWriteHandle handle) {
            if (handle == null) {
                throw new IllegalArgumentException("Must specify handle for reading raw plan");
            }
            if (!(handle instanceof BaseHandle)) {
                throw new IllegalArgumentException("Cannot provide raw plan definition with invalid handle having class " + handle.getClass().getName());
            }
            ((BaseHandle)((Object)handle)).setFormat(Format.JSON);
            this.handle = handle;
        }

        @Override
        public RawPlanDefinition withHandle(JSONWriteHandle handle) {
            this.setHandle(handle);
            return this;
        }
    }

    static class RowRecordImpl
    implements RowRecord {
        private static final Map<Class<? extends XsAnyAtomicTypeVal>, Function<String, ? extends XsAnyAtomicTypeVal>> factories = new HashMap<Class<? extends XsAnyAtomicTypeVal>, Function<String, ? extends XsAnyAtomicTypeVal>>();
        private static final Map<Class<? extends XsAnyAtomicTypeVal>, Constructor<?>> constructors = new HashMap();
        private Map<String, RowRecord.ColumnKind> kinds = null;
        private Map<String, String> datatypes = null;
        private Map<String, Object> row = null;
        private Map<String, Object> aliasedRow = null;
        private RowSetRecord set = null;

        RowRecordImpl(RowSetRecord set) {
            this.set = set;
        }

        void init(Map<String, RowRecord.ColumnKind> kinds, Map<String, String> datatypes, Map<String, Object> row) {
            this.kinds = kinds;
            this.datatypes = datatypes;
            this.row = row;
        }

        @Override
        public RowRecord.ColumnKind getKind(PlanExprCol col) {
            return this.getKind(this.getNameForColumn(col));
        }

        @Override
        public RowRecord.ColumnKind getKind(String columnName) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column kind with null name");
            }
            RowRecord.ColumnKind kind = this.kinds.get(columnName);
            if (kind != null) {
                return kind;
            }
            if (this.kinds.containsKey(columnName)) {
                return RowRecord.ColumnKind.NULL;
            }
            if (this.set.hasAlias(this.kinds, columnName)) {
                return this.kinds.get(columnName);
            }
            throw new IllegalArgumentException("no kind for column: " + columnName);
        }

        @Override
        public String getDatatype(PlanExprCol col) {
            return this.getDatatype(this.getNameForColumn(col));
        }

        @Override
        public String getDatatype(String columnName) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column datatype with null name");
            }
            String datatype = this.datatypes.get(columnName);
            if (datatype != null) {
                return datatype;
            }
            if (this.datatypes.containsKey(columnName)) {
                return null;
            }
            if (this.set.hasAlias(this.datatypes, columnName)) {
                return this.datatypes.get(columnName);
            }
            throw new IllegalArgumentException("no datatype for column: " + columnName);
        }

        @Override
        public boolean containsKey(Object key) {
            if (this.aliasedRow == null) {
                boolean isContained = this.row.containsKey(key);
                if (isContained) {
                    return isContained;
                }
                this.aliasedRow = new HashMap<String, Object>(this.row);
            }
            return this.set.hasAlias(this.aliasedRow, key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.row.containsValue(value);
        }

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            return this.row.entrySet();
        }

        @Override
        public Object get(Object key) {
            if (key == null) {
                throw new IllegalArgumentException("cannot get column value with null name");
            }
            Map<String, Object> valueRow = this.aliasedRow == null ? this.row : this.aliasedRow;
            Object value = valueRow.get(key);
            if (value != null) {
                return value;
            }
            if (valueRow.containsKey(key)) {
                return null;
            }
            if (this.aliasedRow == null) {
                this.aliasedRow = new HashMap<String, Object>(this.row);
            }
            if (this.set.hasAlias(this.aliasedRow, key)) {
                return this.aliasedRow.get(key);
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.row.isEmpty();
        }

        @Override
        public Set<String> keySet() {
            return this.row.keySet();
        }

        @Override
        public Collection<Object> values() {
            return this.row.values();
        }

        @Override
        public int size() {
            return this.row.size();
        }

        @Override
        public Object put(String key, Object value) {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public Object remove(Object key) {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public void putAll(Map<? extends String, ? extends Object> m) {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("cannot modify row record");
        }

        @Override
        public boolean getBoolean(PlanExprCol col) {
            return this.getBoolean(this.getNameForColumn(col));
        }

        @Override
        public boolean getBoolean(String columnName) {
            return this.asBoolean(columnName, this.get(columnName));
        }

        @Override
        public byte getByte(PlanExprCol col) {
            return this.getByte(this.getNameForColumn(col));
        }

        @Override
        public byte getByte(String columnName) {
            return this.asByte(columnName, this.get(columnName));
        }

        @Override
        public double getDouble(PlanExprCol col) {
            return this.getDouble(this.getNameForColumn(col));
        }

        @Override
        public double getDouble(String columnName) {
            return this.asDouble(columnName, this.get(columnName));
        }

        @Override
        public float getFloat(PlanExprCol col) {
            return this.getFloat(this.getNameForColumn(col));
        }

        @Override
        public float getFloat(String columnName) {
            return this.asFloat(columnName, this.get(columnName));
        }

        @Override
        public int getInt(PlanExprCol col) {
            return this.getInt(this.getNameForColumn(col));
        }

        @Override
        public int getInt(String columnName) {
            return this.asInt(columnName, this.get(columnName));
        }

        @Override
        public long getLong(PlanExprCol col) {
            return this.getLong(this.getNameForColumn(col));
        }

        @Override
        public long getLong(String columnName) {
            return this.asLong(columnName, this.get(columnName));
        }

        @Override
        public short getShort(PlanExprCol col) {
            return this.getShort(this.getNameForColumn(col));
        }

        @Override
        public short getShort(String columnName) {
            return this.asShort(columnName, this.get(columnName));
        }

        @Override
        public String getString(PlanExprCol col) {
            return this.getString(this.getNameForColumn(col));
        }

        @Override
        public String getString(String columnName) {
            try {
                return this.asString(this.get(columnName));
            }
            catch (NodeNotAStringException e) {
                throw new IllegalArgumentException("value for column \"" + columnName + "\" not a string");
            }
        }

        private boolean asBoolean(String columnName, Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            throw new IllegalStateException("column " + columnName + " does not have a boolean value");
        }

        private byte asByte(String columnName, Object value) {
            if (value instanceof Number) {
                return ((Number)value).byteValue();
            }
            throw new IllegalStateException("column " + columnName + " does not have a byte value");
        }

        private double asDouble(String columnName, Object value) {
            if (value instanceof Number) {
                return ((Number)value).doubleValue();
            }
            throw new IllegalStateException("column " + columnName + " does not have a double value");
        }

        private float asFloat(String columnName, Object value) {
            if (value instanceof Number) {
                return ((Number)value).floatValue();
            }
            throw new IllegalStateException("column " + columnName + " does not have a float value");
        }

        private int asInt(String columnName, Object value) {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            throw new IllegalStateException("column " + columnName + " does not have an integer value");
        }

        private long asLong(String columnName, Object value) {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            throw new IllegalStateException("column " + columnName + " does not have a long value");
        }

        private short asShort(String columnName, Object value) {
            if (value instanceof Number) {
                return ((Number)value).shortValue();
            }
            throw new IllegalStateException("column " + columnName + " does not have a short value");
        }

        private String asString(Object value) throws NodeNotAStringException {
            if (value == null || value instanceof String) {
                return (String)value;
            }
            if (value instanceof RESTServices.RESTServiceResult) {
                RESTServices.RESTServiceResult result = (RESTServices.RESTServiceResult)value;
                if (result.getMimetype() != null && result.getMimetype().startsWith("text/plain")) {
                    return result.getContent(new StringHandle()).get();
                }
                throw new NodeNotAStringException();
            }
            return value.toString();
        }

        private RESTServices.RESTServiceResult getServiceResult(String columnName) {
            Object val = this.get(columnName);
            if (val instanceof RESTServices.RESTServiceResult) {
                return (RESTServices.RESTServiceResult)val;
            }
            return null;
        }

        @Override
        public <T extends XsAnyAtomicTypeVal> T getValueAs(PlanExprCol col, Class<T> as) {
            return this.getValueAs(this.getNameForColumn(col), as);
        }

        @Override
        public <T extends XsAnyAtomicTypeVal> T getValueAs(String columnName, Class<T> as) {
            if (as == null) {
                throw new IllegalArgumentException("cannot construct " + columnName + " value with null class");
            }
            Object value = this.get(columnName);
            if (value == null) {
                return null;
            }
            try {
                String valueStr = this.asString(value);
                Function<String, XsAnyAtomicTypeVal> factory = this.getFactory(as);
                if (factory != null) {
                    return (T)((XsAnyAtomicTypeVal)as.cast(factory.apply(valueStr)));
                }
                Constructor<Object> constructor = constructors.get(as);
                if (constructor == null) {
                    constructor = as.getConstructor(String.class);
                    constructors.put(as, constructor);
                }
                return (T)((XsAnyAtomicTypeVal)constructor.newInstance(valueStr));
            }
            catch (NodeNotAStringException e) {
                throw new IllegalArgumentException("column \"" + columnName + "\" is a node, not an atomic");
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("cannot construct " + columnName + " value as class: " + as.getName());
            }
            catch (InstantiationException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
            catch (IllegalAccessException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
            catch (IllegalArgumentException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
            catch (InvocationTargetException e) {
                throw new MarkLogicBindingException("could not construct value as class: " + as.getName(), e);
            }
        }

        <T extends XsAnyAtomicTypeVal> Function<String, ? extends XsAnyAtomicTypeVal> getFactory(Class<T> as) {
            Function<String, ? extends XsAnyAtomicTypeVal> factory = factories.get(as);
            if (factory != null) {
                return factory;
            }
            if (as.isAssignableFrom(XsValueImpl.DecimalValImpl.class)) {
                factory = XsValueImpl.DecimalValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.IntegerValImpl.class)) {
                factory = XsValueImpl.IntegerValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.LongValImpl.class)) {
                factory = XsValueImpl.LongValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.IntValImpl.class)) {
                factory = XsValueImpl.IntValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.ShortValImpl.class)) {
                factory = XsValueImpl.ShortValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.ByteValImpl.class)) {
                factory = XsValueImpl.ByteValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedLongValImpl.class)) {
                factory = XsValueImpl.UnsignedLongValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedIntValImpl.class)) {
                factory = XsValueImpl.UnsignedIntValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedShortValImpl.class)) {
                factory = XsValueImpl.UnsignedShortValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.UnsignedByteValImpl.class)) {
                factory = XsValueImpl.UnsignedByteValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DoubleValImpl.class)) {
                factory = XsValueImpl.DoubleValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.FloatValImpl.class)) {
                factory = XsValueImpl.FloatValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DateTimeValImpl.class)) {
                factory = XsValueImpl.DateTimeValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DateValImpl.class)) {
                factory = XsValueImpl.DateValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.TimeValImpl.class)) {
                factory = XsValueImpl.TimeValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.AnyURIValImpl.class)) {
                factory = XsValueImpl.AnyURIValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.BooleanValImpl.class)) {
                factory = XsValueImpl.BooleanValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.DayTimeDurationValImpl.class)) {
                factory = XsValueImpl.DayTimeDurationValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GDayValImpl.class)) {
                factory = XsValueImpl.GDayValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GMonthValImpl.class)) {
                factory = XsValueImpl.GMonthValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GMonthDayValImpl.class)) {
                factory = XsValueImpl.GMonthDayValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GYearValImpl.class)) {
                factory = XsValueImpl.GYearValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.GYearMonthValImpl.class)) {
                factory = XsValueImpl.GYearMonthValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.StringValImpl.class)) {
                factory = XsValueImpl.StringValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.YearMonthDurationValImpl.class)) {
                factory = XsValueImpl.YearMonthDurationValImpl::new;
            } else if (as.isAssignableFrom(XsValueImpl.QNameValImpl.class)) {
                factory = XsValueImpl.QNameValImpl::valueOf;
            }
            if (factory != null) {
                factories.put(as, factory);
            }
            return factory;
        }

        @Override
        public Format getContentFormat(PlanExprCol col) {
            return this.getContentFormat(this.getNameForColumn(col));
        }

        @Override
        public Format getContentFormat(String columnName) {
            String mimetype = this.getContentMimetype(columnName);
            if (mimetype == null) {
                return null;
            }
            switch (mimetype) {
                case "application/json": {
                    return Format.JSON;
                }
                case "text/plain": {
                    return Format.TEXT;
                }
                case "application/xml": 
                case "application/xml-external-parsed-entity": {
                    return Format.XML;
                }
            }
            return Format.BINARY;
        }

        @Override
        public String getContentMimetype(PlanExprCol col) {
            return this.getContentMimetype(this.getNameForColumn(col));
        }

        @Override
        public String getContentMimetype(String columnName) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column mime type with null name");
            }
            RESTServices.RESTServiceResult nodeResult = this.getServiceResult(columnName);
            if (nodeResult == null) {
                return null;
            }
            return nodeResult.getMimetype();
        }

        @Override
        public <T extends AbstractReadHandle> T getContent(PlanExprCol col, T contentHandle) {
            return this.getContent(this.getNameForColumn(col), contentHandle);
        }

        @Override
        public <T extends AbstractReadHandle> T getContent(String columnName, T contentHandle) {
            if (columnName == null) {
                throw new IllegalArgumentException("cannot get column node with null name");
            }
            RESTServices.RESTServiceResult nodeResult = this.getServiceResult(columnName);
            if (nodeResult == null) {
                return null;
            }
            return nodeResult.getContent(contentHandle);
        }

        @Override
        public <T> T getContentAs(PlanExprCol col, Class<T> as) {
            return this.getContentAs(this.getNameForColumn(col), as);
        }

        @Override
        public <T> T getContentAs(String columnName, Class<T> as) {
            if (as == null) {
                throw new IllegalArgumentException("Must specify a class for content with a registered handle");
            }
            ContentHandle<T> handle = this.set.getHandleRegistry().makeHandle(as);
            if (handle == null) {
                throw new IllegalArgumentException("No handle registered for class: " + as.getName());
            }
            T content = (handle = this.getContent(columnName, handle)) == null ? null : (T)handle.get();
            return content;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            boolean isFirst = true;
            if (this.row != null) {
                for (String colName : this.row.keySet()) {
                    if (isFirst) {
                        buf.append("\n    ");
                        isFirst = false;
                    } else {
                        buf.append(",\n    ");
                    }
                    RowRecord.ColumnKind colKind = this.kinds.get(colName);
                    String colType = this.datatypes.get(colName);
                    buf.append(colName);
                    buf.append(":{kind: \"");
                    buf.append(colKind.name());
                    if (!"cid".equals(colType)) {
                        buf.append("\", type: \"");
                        buf.append(colType);
                    }
                    buf.append("\", ");
                    block0 : switch (colKind) {
                        case ATOMIC_VALUE: {
                            buf.append("value: ");
                            String colVal = this.getString(colName);
                            switch (colType) {
                                case "xs:boolean": 
                                case "xs:byte": 
                                case "xs:decimal": 
                                case "xs:double": 
                                case "xs:float": 
                                case "xs:int": 
                                case "xs:integer": 
                                case "xs:long": 
                                case "xs:short": 
                                case "xs:unsignedByte": 
                                case "xs:unsignedInt": 
                                case "xs:unsignedLong": 
                                case "xs:unsignedShort": {
                                    buf.append(colVal);
                                    break block0;
                                }
                            }
                            if (colVal == null) {
                                buf.append("null");
                                break;
                            }
                            buf.append("\"");
                            buf.append(colVal.replace("\"", "\\\""));
                            buf.append("\"");
                            break;
                        }
                        case CONTENT: {
                            buf.append("format: \"");
                            buf.append(this.getContentFormat(colName).name().toLowerCase());
                            buf.append("\", mimetype: \"");
                            buf.append(this.getContentMimetype(colName));
                            buf.append("\"");
                            break;
                        }
                        case NULL: {
                            buf.append("value: null");
                            break;
                        }
                        default: {
                            throw new InternalError("unknown value kind: " + colKind);
                        }
                    }
                    buf.append("}");
                }
            }
            if (!isFirst) {
                buf.append("\n    ");
            }
            buf.append("}\n");
            return buf.toString();
        }

        private String getNameForColumn(PlanExprCol col) {
            if (col == null) {
                throw new IllegalArgumentException("null column");
            }
            if (!(col instanceof PlanBuilderSubImpl.ColumnNamer)) {
                throw new IllegalArgumentException("invalid column class: " + col.getClass().getName());
            }
            return ((PlanBuilderSubImpl.ColumnNamer)((Object)col)).getColName();
        }
    }

    static class RowSetObject<T>
    extends RowSetHandleBase<T, ContentHandle<T>> {
        RowSetObject(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, ContentHandle<T> rowHandle) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results, rowHandle);
        }

        @Override
        T makeNextResult(ContentHandle<T> currentHandle) {
            return currentHandle.get();
        }
    }

    static class RowSetHandle<T extends StructureReadHandle>
    extends RowSetHandleBase<T, T> {
        RowSetHandle(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, T rowHandle) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results, rowHandle);
        }

        @Override
        T makeNextResult(T currentHandle) {
            return currentHandle;
        }
    }

    static abstract class RowSetHandleBase<T, R extends AbstractReadHandle>
    extends RowSetBase<T> {
        private R rowHandle = null;

        RowSetHandleBase(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, R rowHandle) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results);
            this.rowHandle = rowHandle;
        }

        abstract T makeNextResult(R var1);

        @Override
        public T next() {
            RESTServices.RESTServiceResult currentRow = this.nextRow;
            if (currentRow == null) {
                throw new NoSuchElementException("no next row");
            }
            R currentHandle = this.rowHandle;
            boolean hasMoreRows = this.results.hasNext();
            if (hasMoreRows) {
                this.nextRow = this.results.next();
            } else {
                this.close();
            }
            return this.makeNextResult(currentRow.getContent(currentHandle));
        }
    }

    static class RowSetRecord
    extends RowSetBase<RowRecord> {
        private DatabaseClientFactory.HandleFactoryRegistry handleRegistry = null;
        private Map<String, RowRecord.ColumnKind> headerKinds = null;
        private Map<String, String> headerDatatypes = null;
        private Map<String, String> aliases = null;

        RowSetRecord(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results, DatabaseClientFactory.HandleFactoryRegistry handleRegistry) {
            super(rowFormat, datatypeStyle, rowStructureStyle, results);
            this.handleRegistry = handleRegistry;
        }

        @Override
        void init() {
            super.init();
            if (this.datatypeStyle == RowManager.RowSetPart.HEADER) {
                this.headerKinds = new HashMap<String, RowRecord.ColumnKind>();
                this.headerDatatypes = new HashMap<String, String>();
                for (int i = 0; i < this.columnNames.length; ++i) {
                    String columnName = this.columnNames[i];
                    String columnType = this.columnTypes[i];
                    this.headerDatatypes.put(columnName, columnType);
                    RowRecord.ColumnKind columnKind = this.getColumnKind(columnType, RowRecord.ColumnKind.CONTENT);
                    this.headerKinds.put(columnName, columnKind);
                }
            }
        }

        DatabaseClientFactory.HandleFactoryRegistry getHandleRegistry() {
            return this.handleRegistry;
        }

        void initAliases(Map<String, ?> cols) {
            if (this.aliases != null) {
                return;
            }
            HashMap<String, String> candidates = new HashMap<String, String>();
            Set<String> noncandidates = cols.keySet();
            for (String col : noncandidates.toArray(new String[noncandidates.size()])) {
                String[] parts = col.split("\\.", 3);
                if (parts.length == 1) continue;
                for (int i = 1; i < parts.length; ++i) {
                    String candidate;
                    int next = i + 1;
                    String string = candidate = next == parts.length ? parts[i] : parts[i] + "." + parts[next];
                    if (noncandidates.contains(candidate)) continue;
                    if (candidates.containsKey(candidate)) {
                        candidates.remove(candidate);
                        noncandidates.add(candidate);
                        continue;
                    }
                    candidates.put(candidate, col);
                }
            }
            this.aliases = candidates;
        }

        <T> boolean hasAlias(Map<String, T> cols, Object colName) {
            if (colName == null) {
                return false;
            }
            this.initAliases(cols);
            String columnName = colName instanceof String ? (String)colName : colName.toString();
            String col = this.aliases.get(columnName);
            if (col == null) {
                return false;
            }
            cols.put(columnName, cols.get(col));
            return true;
        }

        @Override
        public RowRecord next() {
            RESTServices.RESTServiceResult currentRow = this.nextRow;
            if (currentRow == null) {
                throw new NoSuchElementException("no next row");
            }
            boolean hasMoreRows = this.results.hasNext();
            try {
                int pos;
                String headerValue;
                Map<String, List<String>> headers;
                List<String> headerList;
                Map<String, String> datatypes = null;
                Map<Object, Object> kinds = null;
                Map<String, Object> row = null;
                InputStream rowStream = currentRow.getContent(new InputStreamHandle()).get();
                ObjectMapper rowMapper = new ObjectMapper();
                switch (this.rowStructureStyle) {
                    case ARRAY: {
                        int i;
                        row = new HashMap();
                        switch (this.datatypeStyle) {
                            case HEADER: {
                                datatypes = this.headerDatatypes;
                                List valueLister = (List)rowMapper.readValue(rowStream, List.class);
                                int valueListSize = valueLister.size();
                                for (i = 0; i < valueListSize; ++i) {
                                    RowRecord.ColumnKind columnKind;
                                    String columnName = this.columnNames[i];
                                    Object value = valueLister.get(i);
                                    row.put(columnName, value);
                                    if (value != null || (columnKind = this.headerKinds.get(columnName)) == RowRecord.ColumnKind.NULL) continue;
                                    if (kinds == null) {
                                        kinds = new HashMap();
                                        kinds.putAll(this.headerKinds);
                                    }
                                    kinds.put(columnName, (Object)RowRecord.ColumnKind.NULL);
                                }
                                if (kinds != null) break;
                                kinds = this.headerKinds;
                                break;
                            }
                            case ROWS: {
                                datatypes = new HashMap<String, String>();
                                kinds = new HashMap();
                                List rowLister = (List)rowMapper.readValue(rowStream, List.class);
                                int rowListSize = rowLister.size();
                                while (i < rowListSize) {
                                    String columnName = this.columnNames[i];
                                    row.put(columnName, this.getTypedRowValue(datatypes, kinds, columnName, (Map)rowLister.get(i)));
                                    ++i;
                                }
                                break;
                            }
                            default: {
                                throw new MarkLogicInternalException("Row record set with unknown datatype style: " + this.datatypeStyle);
                            }
                        }
                        while (i < this.columnNames.length) {
                            String columnName = this.columnNames[i];
                            kinds.put(columnName, (Object)RowRecord.ColumnKind.NULL);
                            row.put(columnName, null);
                            ++i;
                        }
                        break;
                    }
                    case OBJECT: {
                        Map mapRow = (Map)rowMapper.readValue(rowStream, Map.class);
                        switch (this.datatypeStyle) {
                            case HEADER: {
                                datatypes = this.headerDatatypes;
                                for (Map.Entry<String, RowRecord.ColumnKind> entry : this.headerKinds.entrySet()) {
                                    RowRecord.ColumnKind columnKind;
                                    String columnName = entry.getKey();
                                    Object value = mapRow.get(columnName);
                                    if (value != null || (columnKind = entry.getValue()) == RowRecord.ColumnKind.NULL) continue;
                                    if (kinds == null) {
                                        kinds = new HashMap();
                                        kinds.putAll(this.headerKinds);
                                    }
                                    kinds.put(columnName, (Object)RowRecord.ColumnKind.NULL);
                                }
                                if (kinds != null) break;
                                kinds = this.headerKinds;
                                break;
                            }
                            case ROWS: {
                                HashMap<String, String> rowDatatypes = new HashMap<String, String>();
                                HashMap rowKinds = new HashMap();
                                mapRow.replaceAll((key, rawBinding) -> {
                                    Map binding = (Map)rawBinding;
                                    return this.getTypedRowValue((Map<String, String>)rowDatatypes, rowKinds, (String)key, binding);
                                });
                                datatypes = rowDatatypes;
                                kinds = rowKinds;
                                break;
                            }
                            default: {
                                throw new MarkLogicInternalException("Row record set with unknown datatype style: " + this.datatypeStyle);
                            }
                        }
                        row = mapRow;
                        break;
                    }
                    default: {
                        throw new MarkLogicInternalException("Row record set with unknown row structure style: " + this.rowStructureStyle);
                    }
                }
                while (hasMoreRows && (headerList = (headers = (currentRow = this.results.next()).getHeaders()).get("Content-Disposition")) != null && !headerList.isEmpty() && (headerValue = headerList.get(0)) != null && headerValue.startsWith("inline; kind=row-attachment") && (headerList = headers.get("Content-ID")) != null && !headerList.isEmpty() && (headerValue = headerList.get(0)) != null && headerValue.startsWith("<") && headerValue.endsWith(">") && (pos = headerValue.indexOf("[", 1)) != -1) {
                    String colName = headerValue.substring(1, pos);
                    row.put(colName, currentRow);
                    hasMoreRows = this.results.hasNext();
                }
                RowRecordImpl rowRecord = new RowRecordImpl(this);
                rowRecord.init(kinds, datatypes, row);
                if (hasMoreRows) {
                    this.nextRow = currentRow;
                } else {
                    this.close();
                }
                return rowRecord;
            }
            catch (JsonParseException e) {
                throw new MarkLogicIOException("could not part row record", e);
            }
            catch (JsonMappingException e) {
                throw new MarkLogicIOException("could not map row record", e);
            }
            catch (IOException e) {
                throw new MarkLogicIOException("could not read row record", e);
            }
        }

        private Object getTypedRowValue(Map<String, String> datatypes, Map<String, RowRecord.ColumnKind> kinds, String columnName, Map<String, Object> binding) {
            RowRecord.ColumnKind columnKind = null;
            Object value = null;
            String datatype = (String)binding.get("type");
            if (datatype != null) {
                datatypes.put(columnName, datatype);
            }
            columnKind = this.getColumnKind(datatype, null);
            kinds.put(columnName, columnKind);
            value = columnKind == RowRecord.ColumnKind.ATOMIC_VALUE ? binding.get("value") : null;
            return value;
        }

        private RowRecord.ColumnKind getColumnKind(String datatype, RowRecord.ColumnKind defaultKind) {
            if ("cid".equals(datatype)) {
                return RowRecord.ColumnKind.CONTENT;
            }
            if ("null".equals(datatype)) {
                return RowRecord.ColumnKind.NULL;
            }
            if (datatype.contains(":")) {
                return RowRecord.ColumnKind.ATOMIC_VALUE;
            }
            if (datatype != null && defaultKind != null) {
                return defaultKind;
            }
            throw new MarkLogicInternalException("Column value with unsupported datatype: " + datatype);
        }
    }

    static abstract class RowSetBase<T>
    implements RowSet<T>,
    Iterator<T> {
        String rowFormat = null;
        RESTServices.RESTServiceResultIterator results = null;
        String[] columnNames = null;
        String[] columnTypes = null;
        RESTServices.RESTServiceResult nextRow = null;
        RowManager.RowSetPart datatypeStyle = null;
        RowManager.RowStructure rowStructureStyle = null;

        RowSetBase(String rowFormat, RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle, RESTServices.RESTServiceResultIterator results) {
            this.rowFormat = rowFormat;
            this.datatypeStyle = datatypeStyle;
            this.rowStructureStyle = rowStructureStyle;
            this.results = results;
        }

        void init() {
            this.parseColumns(this.datatypeStyle, this.rowStructureStyle);
            if (this.results.hasNext()) {
                this.nextRow = this.results.next();
            }
        }

        private void parseColumns(RowManager.RowSetPart datatypeStyle, RowManager.RowStructure rowStructureStyle) {
            if (!this.results.hasNext()) {
                return;
            }
            RESTServices.RESTServiceResult headerRow = this.results.next();
            switch (this.rowFormat) {
                case "json": {
                    try {
                        List cols = null;
                        switch (rowStructureStyle) {
                            case OBJECT: {
                                Map headerObj = (Map)new ObjectMapper().readValue(headerRow.getContent(new InputStreamHandle()).get(), Map.class);
                                if (headerObj == null) break;
                                cols = (List)headerObj.get("columns");
                                break;
                            }
                            case ARRAY: {
                                cols = (List)new ObjectMapper().readValue(headerRow.getContent(new InputStreamHandle()).get(), List.class);
                                break;
                            }
                            default: {
                                throw new InternalError("unknown row structure style: " + rowStructureStyle);
                            }
                        }
                        int colSize = cols == null ? 0 : cols.size();
                        this.columnNames = colSize > 0 ? new String[colSize] : new String[]{};
                        String[] stringArray = this.columnTypes = colSize > 0 && datatypeStyle == RowManager.RowSetPart.HEADER ? new String[colSize] : new String[]{};
                        if (colSize <= 0) break;
                        int i = 0;
                        for (Map col : cols) {
                            this.columnNames[i] = (String)col.get("name");
                            if (datatypeStyle == RowManager.RowSetPart.HEADER) {
                                this.columnTypes[i] = (String)col.get("type");
                            }
                            ++i;
                        }
                        break;
                    }
                    catch (JsonParseException e) {
                        throw new MarkLogicIOException("could not read JSON header part", e);
                    }
                    catch (JsonMappingException e) {
                        throw new MarkLogicIOException("could not read JSON header map", e);
                    }
                    catch (IOException e) {
                        throw new MarkLogicIOException("could not read JSON header", e);
                    }
                }
                case "xml": {
                    try {
                        ArrayList<String> cols = new ArrayList<String>();
                        ArrayList<String> types = datatypeStyle == RowManager.RowSetPart.HEADER ? new ArrayList<String>() : null;
                        XMLStreamReader headerReader = headerRow.getContent(new XMLStreamReaderHandle()).get();
                        while (headerReader.hasNext()) {
                            switch (headerReader.next()) {
                                case 1: {
                                    if (!"column".equals(headerReader.getLocalName())) break;
                                    cols.add(headerReader.getAttributeValue(null, "name"));
                                    if (datatypeStyle == RowManager.RowSetPart.HEADER) {
                                        types.add(headerReader.getAttributeValue(null, "type"));
                                    }
                                    headerReader.nextTag();
                                }
                            }
                        }
                        int colSize = cols.size();
                        this.columnNames = colSize > 0 ? cols.toArray(new String[colSize]) : new String[]{};
                        this.columnTypes = colSize > 0 && datatypeStyle == RowManager.RowSetPart.HEADER ? types.toArray(new String[colSize]) : new String[]{};
                        break;
                    }
                    catch (XMLStreamException e) {
                        throw new MarkLogicIOException("could not read XML header", e);
                    }
                }
                default: {
                    throw new IllegalArgumentException("Row format should be JSON or XML instead of " + this.rowFormat);
                }
            }
        }

        @Override
        public String[] getColumnNames() {
            return this.columnNames;
        }

        @Override
        public String[] getColumnTypes() {
            return this.columnTypes;
        }

        @Override
        public Iterator<T> iterator() {
            return this;
        }

        @Override
        public Stream<T> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }

        @Override
        public boolean hasNext() {
            return this.nextRow != null;
        }

        @Override
        public void close() {
            this.closeImpl();
        }

        protected void finalize() throws Throwable {
            this.closeImpl();
            super.finalize();
        }

        private void closeImpl() {
            if (this.results != null) {
                this.results.close();
                this.results = null;
                this.nextRow = null;
            }
        }
    }
}

