/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.dataservices.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.marklogic.client.DatabaseClient;
import com.marklogic.client.MarkLogicInternalException;
import com.marklogic.client.SessionState;
import com.marklogic.client.dataservices.IOEndpoint;
import com.marklogic.client.dataservices.impl.IOCallerImpl;
import com.marklogic.client.impl.NodeConverter;
import com.marklogic.client.io.marker.BufferableHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.BlockingQueue;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class IOEndpointImpl
implements IOEndpoint {
    private static Logger logger = LoggerFactory.getLogger(IOEndpointImpl.class);
    static final int DEFAULT_BATCH_SIZE = 100;
    private DatabaseClient client;
    private IOCallerImpl caller;

    public IOEndpointImpl(DatabaseClient client, IOCallerImpl caller) {
        if (client == null) {
            throw new IllegalArgumentException("null client");
        }
        if (caller == null) {
            throw new IllegalArgumentException("null caller");
        }
        this.client = client;
        this.caller = caller;
    }

    int initBatchSize(IOCallerImpl caller) {
        JsonNode apiDeclaration = caller.getApiDeclaration();
        if (apiDeclaration.has("$bulk") && apiDeclaration.get("$bulk").isObject() && apiDeclaration.get("$bulk").has("inputBatchSize") && apiDeclaration.get("$bulk").get("inputBatchSize").isInt()) {
            return apiDeclaration.get("$bulk").get("inputBatchSize").asInt();
        }
        return 100;
    }

    DatabaseClient getClient() {
        return this.client;
    }

    private IOCallerImpl getCaller() {
        return this.caller;
    }

    @Override
    public String getEndpointPath() {
        return this.getCaller().getEndpointPath();
    }

    @Override
    public boolean allowsEndpointState() {
        return this.getCaller().getEndpointStateParamdef() != null;
    }

    @Override
    public boolean allowsWorkUnit() {
        return this.getCaller().getWorkUnitParamdef() != null;
    }

    @Override
    public boolean allowsInput() {
        return this.getCaller().getInputParamdef() != null;
    }

    @Override
    public boolean allowsSession() {
        return this.getCaller().getSessionParamdef() != null;
    }

    @Override
    public SessionState newSessionState() {
        if (!this.allowsEndpointState()) {
            throw new IllegalStateException("endpoint does not support session state");
        }
        return this.getCaller().newSessionState();
    }

    public void checkAllowedArgs(InputStream endpointState, SessionState session, InputStream workUnit) {
        if (endpointState != null && !this.allowsEndpointState()) {
            throw new IllegalArgumentException("endpoint does not accept endpoint state");
        }
        if (session != null && !this.allowsSession()) {
            throw new IllegalArgumentException("endpoint does not accept session");
        }
        if (workUnit != null && !this.allowsWorkUnit()) {
            throw new IllegalArgumentException("endpoint does not accept work unit");
        }
    }

    static abstract class BulkIOEndpointCallerImpl
    implements IOEndpoint.BulkIOEndpointCaller {
        private WorkPhase phase = WorkPhase.INITIALIZING;
        private IOEndpointImpl endpoint;
        private byte[] endpointState;
        private byte[] workUnit;
        private SessionState session;
        private long callCount = 0L;

        BulkIOEndpointCallerImpl(IOEndpointImpl endpoint) {
            if (endpoint == null) {
                throw new IllegalArgumentException("null endpoint definition");
            }
            this.endpoint = endpoint;
        }

        private IOEndpointImpl getEndpoint() {
            return this.endpoint;
        }

        String getEndpointPath() {
            return this.getEndpoint().getEndpointPath();
        }

        long getCallCount() {
            return this.callCount;
        }

        void incrementCallCount() {
            ++this.callCount;
        }

        boolean allowsEndpointState() {
            return this.getEndpoint().allowsEndpointState();
        }

        @Override
        public InputStream getEndpointState() {
            return this.endpointState == null ? null : new ByteArrayInputStream(this.endpointState);
        }

        @Override
        public void setEndpointState(byte[] endpointState) {
            if (this.allowsEndpointState()) {
                this.endpointState = endpointState;
            } else if (endpointState != null) {
                throw new IllegalArgumentException("endpoint state not accepted by endpoint: " + this.getEndpointPath());
            }
        }

        @Override
        public void setEndpointState(InputStream endpointState) {
            this.setEndpointState(NodeConverter.InputStreamToBytes(endpointState));
        }

        @Override
        public void setEndpointState(BufferableHandle endpointState) {
            this.setEndpointState(endpointState == null ? null : endpointState.toBuffer());
        }

        boolean allowsWorkUnit() {
            return this.getEndpoint().allowsWorkUnit();
        }

        @Override
        public InputStream getWorkUnit() {
            return this.workUnit == null ? null : new ByteArrayInputStream(this.workUnit);
        }

        @Override
        public void setWorkUnit(byte[] workUnit) {
            if (this.allowsWorkUnit()) {
                this.workUnit = workUnit;
            } else if (workUnit != null) {
                throw new IllegalArgumentException("work unit not accepted by endpoint: " + this.getEndpointPath());
            }
        }

        @Override
        public void setWorkUnit(InputStream workUnit) {
            this.setWorkUnit(NodeConverter.InputStreamToBytes(workUnit));
        }

        @Override
        public void setWorkUnit(BufferableHandle workUnit) {
            this.setWorkUnit(workUnit == null ? null : workUnit.toBuffer());
        }

        DatabaseClient getClient() {
            return this.getEndpoint().getClient();
        }

        boolean allowsSession() {
            return this.getEndpoint().allowsSession();
        }

        SessionState getSession() {
            if (!this.allowsSession()) {
                return null;
            }
            if (this.session == null) {
                this.session = this.getEndpoint().getCaller().newSessionState();
            }
            return this.session;
        }

        boolean allowsInput() {
            return this.getEndpoint().allowsInput();
        }

        boolean queueInput(InputStream input, BlockingQueue<InputStream> queue, int batchSize) {
            if (input == null) {
                return false;
            }
            try {
                queue.put(input);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("InputStream was not added to the queue." + e.getMessage());
            }
            return this.checkQueue(queue, batchSize);
        }

        boolean queueAllInput(InputStream[] input, BlockingQueue<InputStream> queue, int batchSize) {
            if (input == null || input.length == 0) {
                return false;
            }
            try {
                for (InputStream item : input) {
                    queue.put(item);
                }
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("InputStream was not added to the queue." + e.getMessage());
            }
            return this.checkQueue(queue, batchSize);
        }

        boolean checkQueue(BlockingQueue<InputStream> queue, int batchSize) {
            if (queue.size() % batchSize > 0) {
                return false;
            }
            switch (this.getPhase()) {
                case INITIALIZING: {
                    this.setPhase(WorkPhase.RUNNING);
                    break;
                }
                case RUNNING: {
                    break;
                }
                case INTERRUPTING: 
                case INTERRUPTED: 
                case COMPLETED: {
                    throw new IllegalStateException("cannot accept more input as current phase is  " + this.getPhase().name());
                }
                default: {
                    throw new MarkLogicInternalException("unexpected state for " + this.getEndpointPath() + " during loop: " + this.getPhase().name());
                }
            }
            return true;
        }

        InputStream[] getInputBatch(BlockingQueue<InputStream> queue, int batchSize) {
            ArrayList inputStreamList = new ArrayList();
            queue.drainTo(inputStreamList, batchSize);
            return inputStreamList.toArray(new InputStream[inputStreamList.size()]);
        }

        void processOutputBatch(InputStream[] output, Consumer<InputStream> outputListener) {
            int i;
            if (output == null || output.length == 0) {
                return;
            }
            this.assignEndpointState(output);
            int n = i = this.allowsEndpointState() ? 1 : 0;
            while (i < output.length) {
                outputListener.accept(output[i]);
                ++i;
            }
        }

        WorkPhase getPhase() {
            return this.phase;
        }

        void setPhase(WorkPhase phase) {
            this.phase = phase;
        }

        @Override
        public void interrupt() {
            if (this.phase == WorkPhase.RUNNING) {
                this.setPhase(WorkPhase.INTERRUPTING);
            }
        }

        void assignEndpointState(InputStream[] output) {
            if (this.allowsEndpointState() && output.length > 0) {
                this.setEndpointState(output[0]);
            }
        }

        InputStream[] getOutput(InputStream[] output) {
            this.assignEndpointState(output);
            if (this.allowsEndpointState() && output.length > 0) {
                return Arrays.copyOfRange(output, 1, output.length);
            }
            return output;
        }

        static enum WorkPhase {
            INITIALIZING,
            RUNNING,
            INTERRUPTING,
            INTERRUPTED,
            COMPLETED;

        }
    }
}

