/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.impl.BatcherImpl;
import com.marklogic.client.datamovement.impl.QueryBatcherImpl;
import com.marklogic.client.datamovement.impl.WriteBatcherImpl;

public class JobTicketImpl
implements JobTicket {
    private String jobId;
    private JobTicket.JobType jobType;
    private QueryBatcherImpl queryBatcher;
    private WriteBatcherImpl writeBatcher;

    public JobTicketImpl(String jobId, JobTicket.JobType jobType) {
        this.jobId = jobId;
        this.jobType = jobType;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public JobTicket.JobType getJobType() {
        return this.jobType;
    }

    @Override
    public BatcherImpl getBatcher() {
        JobTicket.JobType jobType = this.getJobType();
        if (jobType == null) {
            throw new InternalError("null job type");
        }
        switch (jobType) {
            case QUERY_BATCHER: {
                return this.getQueryBatcher();
            }
            case WRITE_BATCHER: {
                return this.getWriteBatcher();
            }
        }
        throw new InternalError("unknown job type: " + jobType.name());
    }

    public QueryBatcherImpl getQueryBatcher() {
        return this.queryBatcher;
    }

    public WriteBatcherImpl getWriteBatcher() {
        return this.writeBatcher;
    }

    public JobTicketImpl withQueryBatcher(QueryBatcherImpl queryBatcher) {
        this.queryBatcher = queryBatcher;
        return this;
    }

    public JobTicketImpl withWriteBatcher(WriteBatcherImpl writeBatcher) {
        this.writeBatcher = writeBatcher;
        return this;
    }
}

