/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.datamovement.Batcher;
import com.marklogic.client.datamovement.DataMovementManager;
import com.marklogic.client.datamovement.Forest;
import com.marklogic.client.datamovement.ForestConfiguration;
import com.marklogic.client.datamovement.JobTicket;
import com.marklogic.client.datamovement.impl.DataMovementManagerImpl;
import com.marklogic.client.datamovement.impl.ForestConfigurationImpl;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class BatcherImpl
implements Batcher {
    private String jobName = "unnamed";
    private String jobId = null;
    private int batchSize = 100;
    private int threadCount = 1;
    private ForestConfiguration forestConfig;
    private DataMovementManagerImpl moveMgr;

    protected BatcherImpl(DataMovementManager moveMgr) {
        if (moveMgr == null) {
            throw new IllegalArgumentException("moveMgr must not be null");
        }
        if (!(moveMgr instanceof DataMovementManagerImpl)) {
            throw new IllegalArgumentException("moveMgr must be DataMovementManagerImpl");
        }
        this.moveMgr = (DataMovementManagerImpl)moveMgr;
    }

    @Override
    public Batcher withJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public String getJobName() {
        return this.jobName;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    @Override
    public Batcher withBatchSize(int batchSize) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must be 1 or greater");
        }
        this.batchSize = batchSize;
        return this;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public Batcher withThreadCount(int threadCount) {
        if (threadCount <= 0) {
            throw new IllegalArgumentException("threadCount must be 1 or greater");
        }
        this.threadCount = threadCount;
        return this;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public ForestConfiguration getForestConfig() {
        return this.forestConfig;
    }

    @Override
    public Batcher withForestConfig(ForestConfiguration forestConfig) {
        if (forestConfig == null) {
            throw new IllegalArgumentException("forestConfig must not be null");
        }
        if (this.moveMgr.getConnectionType() == DatabaseClient.ConnectionType.GATEWAY && !(forestConfig instanceof ForestConfigurationImpl)) {
            throw new IllegalArgumentException("cannot change internal forestConfig when using a gateway");
        }
        this.forestConfig = forestConfig;
        return this;
    }

    @Override
    public DatabaseClient getPrimaryClient() {
        return this.getMoveMgr().getPrimaryClient();
    }

    public abstract void start(JobTicket var1);

    @Override
    public abstract JobTicket getJobTicket();

    public abstract void stop();

    @Override
    public abstract boolean isStopped();

    @Override
    public abstract boolean isStarted();

    protected DataMovementManagerImpl getMoveMgr() {
        return this.moveMgr;
    }

    protected Forest[] forests(ForestConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException("forestConfig must not be null");
        }
        return config.listForests();
    }

    protected Set<String> hosts(Forest[] forests) {
        if (forests.length == 0) {
            throw new IllegalStateException("batcher requires at least one forest");
        }
        HashSet<String> hosts = new HashSet<String>();
        for (Forest forest : forests) {
            if (forest.getPreferredHost() == null) {
                throw new IllegalStateException("Hostname must not be null for any forest");
            }
            hosts.add(forest.getPreferredHost());
        }
        for (Forest forest : forests) {
            String hostName = forest.getHost();
            if (forest.getPreferredHostType() != Forest.HostType.REQUEST_HOST || hostName.toLowerCase().equals(forest.getRequestHost().toLowerCase()) || !hosts.contains(hostName)) continue;
            hosts.remove(hostName);
        }
        return hosts;
    }

    protected List<DatabaseClient> clients(Set<String> hosts) {
        if (hosts == null || hosts.size() == 0) {
            throw new IllegalStateException("no hosts for batcher");
        }
        ArrayList<DatabaseClient> clients = new ArrayList<DatabaseClient>();
        for (String host : hosts) {
            clients.add(this.moveMgr.getHostClient(host));
        }
        return clients;
    }
}

