/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.document.DocumentWriteOperation;
import com.marklogic.client.impl.DocumentWriteOperationImpl;
import com.marklogic.client.io.BytesHandle;
import com.marklogic.client.io.Format;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipSplitter
implements Splitter<BytesHandle> {
    private Map<String, Format> extensionFormats = new HashMap<String, Format>();
    private Predicate<ZipEntry> entryFilter;
    private Function<String, String> uriTransformer;
    private int count = 0;

    public Map<String, Format> getExtensionFormats() {
        return this.extensionFormats;
    }

    public Predicate<ZipEntry> getEntryFilter() {
        return this.entryFilter;
    }

    public void setEntryFilter(Predicate<ZipEntry> entryFilter) {
        this.entryFilter = entryFilter;
    }

    public Function<String, String> getUriTransformer() {
        return this.uriTransformer;
    }

    public void setUriTransformer(Function<String, String> uriTransformer) {
        this.uriTransformer = uriTransformer;
    }

    public ZipSplitter() {
        this.extensionFormats.put("", Format.UNKNOWN);
        this.extensionFormats.put("json", Format.JSON);
        this.extensionFormats.put("txt", Format.TEXT);
        this.extensionFormats.put("xml", Format.XML);
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Stream<BytesHandle> split(InputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        if (!(input instanceof ZipInputStream)) {
            throw new IllegalArgumentException("Input should be an instance of ZipInputStream");
        }
        return this.split((ZipInputStream)input);
    }

    public Stream<BytesHandle> split(ZipInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        BytesHandleSpliterator bytesHandleSpliterator = new BytesHandleSpliterator(this);
        bytesHandleSpliterator.setZipStream(input);
        bytesHandleSpliterator.setEntryFilter(this.entryFilter);
        bytesHandleSpliterator.setExtensionFormats(this.extensionFormats);
        return StreamSupport.stream(bytesHandleSpliterator, true);
    }

    public Stream<DocumentWriteOperation> splitWriteOperations(ZipInputStream input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Input cannot be null");
        }
        DocumentWriteOperationSpliterator documentWriteOperationSpliterator = new DocumentWriteOperationSpliterator(this);
        documentWriteOperationSpliterator.setZipStream(input);
        documentWriteOperationSpliterator.setEntryFilter(this.entryFilter);
        documentWriteOperationSpliterator.setExtensionFormats(this.extensionFormats);
        return StreamSupport.stream(documentWriteOperationSpliterator, true);
    }

    private static class DocumentWriteOperationSpliterator
    extends ZipEntrySpliterator<DocumentWriteOperation> {
        private ZipSplitter splitter;

        protected DocumentWriteOperationSpliterator(ZipSplitter splitter) {
            super(Long.MAX_VALUE, 1280);
            this.splitter = splitter;
        }

        @Override
        public boolean tryAdvance(Consumer<? super DocumentWriteOperation> action) {
            try {
                String name;
                FormatEntry nextEntry = this.getNextEntry();
                if (nextEntry == null) {
                    return false;
                }
                BytesHandle nextBytesHandle = this.readEntry(nextEntry);
                String uri = name = nextEntry.getZipEntry().getName();
                if (this.splitter.uriTransformer != null) {
                    uri = (String)this.splitter.uriTransformer.apply(name);
                }
                DocumentWriteOperationImpl documentWriteOperation = new DocumentWriteOperationImpl(DocumentWriteOperation.OperationType.DOCUMENT_WRITE, uri, null, nextBytesHandle);
                action.accept(documentWriteOperation);
                this.splitter.count++;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read ZipEntry", e);
            }
            return true;
        }
    }

    private static class BytesHandleSpliterator
    extends ZipEntrySpliterator<BytesHandle> {
        private ZipSplitter splitter;

        protected BytesHandleSpliterator(ZipSplitter splitter) {
            super(Long.MAX_VALUE, 1280);
            this.splitter = splitter;
        }

        @Override
        public boolean tryAdvance(Consumer<? super BytesHandle> action) {
            try {
                FormatEntry nextEntry = this.getNextEntry();
                if (nextEntry == null) {
                    return false;
                }
                BytesHandle nextBytesHandle = this.readEntry(nextEntry);
                action.accept(nextBytesHandle);
                this.splitter.count++;
            }
            catch (IOException e) {
                throw new RuntimeException("Could not read ZipEntry", e);
            }
            return true;
        }
    }

    private static abstract class ZipEntrySpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private static Pattern extensionRegex = Pattern.compile("\\.([^.]+)$");
        private ZipInputStream zipStream;
        private Map<String, Format> extensionFormats;
        private Predicate<ZipEntry> entryFilter;

        ZipEntrySpliterator(long est, int additionalCharacteristics) {
            super(est, additionalCharacteristics);
        }

        ZipInputStream getZipStream() {
            return this.zipStream;
        }

        void setZipStream(ZipInputStream zipStream) {
            if (zipStream == null) {
                throw new IllegalArgumentException("ZipStream cannot be null");
            }
            this.zipStream = zipStream;
        }

        Map<String, Format> getExtensionFormats() {
            return this.extensionFormats;
        }

        void setExtensionFormats(Map<String, Format> extensionFormats) {
            if (extensionFormats == null) {
                throw new IllegalArgumentException("ExtensionFormats cannot be null");
            }
            this.extensionFormats = extensionFormats;
        }

        Predicate<ZipEntry> getEntryFilter() {
            return this.entryFilter;
        }

        void setEntryFilter(Predicate<ZipEntry> entryFilter) {
            this.entryFilter = entryFilter;
        }

        protected FormatEntry getNextEntry() throws IOException {
            ZipEntry candidateEntry;
            while ((candidateEntry = this.getZipStream().getNextEntry()) != null) {
                if (this.getEntryFilter() != null && !this.getEntryFilter().test(candidateEntry)) continue;
                String name = candidateEntry.getName();
                Matcher matcher = extensionRegex.matcher(name);
                matcher.find();
                String extension = matcher.group(1);
                Format format = this.getExtensionFormats().get(extension);
                if (format == null) {
                    format = this.getExtensionFormats().get("");
                }
                if (format == null || format == Format.UNKNOWN) continue;
                FormatEntry newEntry = new FormatEntry();
                newEntry.setFormat(format);
                newEntry.setZipEntry(candidateEntry);
                return newEntry;
            }
            return null;
        }

        protected BytesHandle readEntry(FormatEntry entry) throws IOException {
            byte[] content = new byte[(int)entry.getZipEntry().getSize()];
            this.getZipStream().read(content, 0, content.length);
            return new BytesHandle(content).withFormat(entry.getFormat());
        }
    }

    private static class FormatEntry {
        private ZipEntry zipEntry;
        private Format format;

        private FormatEntry() {
        }

        private ZipEntry getZipEntry() {
            return this.zipEntry;
        }

        private void setZipEntry(ZipEntry zipEntry) {
            if (zipEntry == null) {
                throw new IllegalArgumentException("ZipEntry cannot be null");
            }
            this.zipEntry = zipEntry;
        }

        private Format getFormat() {
            return this.format;
        }

        private void setFormat(Format format) {
            if (format == null) {
                throw new IllegalArgumentException("Format cannot be null");
            }
            this.format = format;
        }
    }
}

