/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.datamovement;

import com.marklogic.client.datamovement.Splitter;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.StringHandle;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.stream.Stream;

public class LineSplitter
implements Splitter<StringHandle> {
    private Format format = Format.JSON;
    private int count = 0;

    public Format getFormat() {
        return this.format;
    }

    public void setFormat(Format format) {
        if (format == null) {
            throw new IllegalArgumentException("Format cannot be null.");
        }
        this.format = format;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public Stream<StringHandle> split(InputStream input) throws IOException {
        return this.split(input, null);
    }

    public Stream<StringHandle> split(InputStream input, Charset charset) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("InputStream cannot be null.");
        }
        return this.split(charset == null ? new InputStreamReader(input) : new InputStreamReader(input, charset));
    }

    public Stream<StringHandle> split(Reader input) throws IOException {
        if (input == null) {
            throw new IllegalArgumentException("Reader cannot be null.");
        }
        return new BufferedReader(input).lines().map(line -> {
            ++this.count;
            return new StringHandle((String)line).withFormat(this.getFormat());
        });
    }
}

