/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.navigation.utils.network;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import com.mapbox.navigation.utils.network.NetworkStatus;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/mapbox/navigation/utils/network/NetworkStatusService;", "", "applicationContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "connectivityManager", "Landroid/net/ConnectivityManager;", "networkStatusChannel", "Lkotlinx/coroutines/channels/Channel;", "Lcom/mapbox/navigation/utils/network/NetworkStatus;", "getNetworkStatusChannel", "Lkotlinx/coroutines/channels/ReceiveChannel;", "libnavigation-util_release"})
public final class NetworkStatusService {
    private final ConnectivityManager connectivityManager;
    private final Channel<NetworkStatus> networkStatusChannel;

    @NotNull
    public final ReceiveChannel<NetworkStatus> getNetworkStatusChannel() {
        return (ReceiveChannel)this.networkStatusChannel;
    }

    public NetworkStatusService(@NotNull Context applicationContext) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)applicationContext, (String)"applicationContext");
        Object object = applicationContext.getSystemService("connectivity");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.ConnectivityManager");
        }
        this.connectivityManager = (ConnectivityManager)object;
        this.networkStatusChannel = ChannelKt.Channel((int)-1);
        boolean bl2 = bl = Build.VERSION.SDK_INT >= 21;
        if (bl) {
            NetworkRequest.Builder builder = new NetworkRequest.Builder().addCapability(12).addTransportType(0).addTransportType(1).addTransportType(4);
            ConnectivityManager.NetworkCallback callback2 = new ConnectivityManager.NetworkCallback(this){
                final /* synthetic */ NetworkStatusService this$0;

                public void onAvailable(@Nullable Network network) {
                    super.onAvailable(network);
                    NetworkStatusService.access$getNetworkStatusChannel$p(this.this$0).offer((Object)new NetworkStatus(true));
                }

                public void onLost(@Nullable Network network) {
                    super.onLost(network);
                    NetworkStatusService.access$getNetworkStatusChannel$p(this.this$0).offer((Object)new NetworkStatus(false));
                }
                {
                    this.this$0 = $outer;
                }
            };
            this.connectivityManager.registerNetworkCallback(builder.build(), callback2);
        } else if (!bl) {
            IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
            BroadcastReceiver receiver2 = new BroadcastReceiver(this){
                final /* synthetic */ NetworkStatusService this$0;

                public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                    NetworkInfo activeNetwork;
                    Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
                    Intrinsics.checkParameterIsNotNull((Object)intent, (String)"intent");
                    NetworkInfo networkInfo = activeNetwork = NetworkStatusService.access$getConnectivityManager$p(this.this$0).getActiveNetworkInfo();
                    boolean isConnected = networkInfo != null ? networkInfo.isConnectedOrConnecting() : false;
                    NetworkStatusService.access$getNetworkStatusChannel$p(this.this$0).offer((Object)new NetworkStatus(isConnected));
                }
                {
                    this.this$0 = $outer;
                }
            };
            applicationContext.registerReceiver(receiver2, filter);
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    public static final /* synthetic */ Channel access$getNetworkStatusChannel$p(NetworkStatusService $this) {
        return $this.networkStatusChannel;
    }

    public static final /* synthetic */ ConnectivityManager access$getConnectivityManager$p(NetworkStatusService $this) {
        return $this.connectivityManager;
    }
}

