/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.turf;

import android.support.annotation.NonNull;
import com.mapbox.geojson.Feature;
import com.mapbox.geojson.LineString;
import com.mapbox.geojson.MultiLineString;
import com.mapbox.geojson.MultiPoint;
import com.mapbox.geojson.MultiPolygon;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.Polygon;
import com.mapbox.turf.TurfException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class TurfMeta {
    private TurfMeta() {
    }

    @NonNull
    public static List<Point> coordAll(@NonNull Point point) {
        ArrayList<Point> coords = new ArrayList<Point>();
        coords.add(point);
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull LineString lineString) {
        ArrayList<Point> coords = new ArrayList<Point>();
        coords.addAll(lineString.coordinates());
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull MultiPoint multiPoint) {
        ArrayList<Point> coords = new ArrayList<Point>();
        coords.addAll(multiPoint.coordinates());
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull Polygon polygon, boolean excludeWrapCoord) {
        ArrayList<Point> coords = new ArrayList<Point>();
        int wrapShrink = excludeWrapCoord ? 1 : 0;
        for (int i = 0; i < polygon.coordinates().size(); ++i) {
            for (int j = 0; j < ((List)polygon.coordinates().get(i)).size() - wrapShrink; ++j) {
                coords.add((Point)((List)polygon.coordinates().get(i)).get(j));
            }
        }
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull MultiLineString multiLineString) {
        ArrayList<Point> coords = new ArrayList<Point>();
        for (int i = 0; i < multiLineString.coordinates().size(); ++i) {
            coords.addAll((Collection)multiLineString.coordinates().get(i));
        }
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull MultiPolygon multiPolygon, boolean excludeWrapCoord) {
        ArrayList<Point> coords = new ArrayList<Point>();
        int wrapShrink = excludeWrapCoord ? 1 : 0;
        for (int i = 0; i < multiPolygon.coordinates().size(); ++i) {
            for (int j = 0; j < ((List)multiPolygon.coordinates().get(i)).size(); ++j) {
                for (int k = 0; k < ((List)((List)multiPolygon.coordinates().get(i)).get(j)).size() - wrapShrink; ++k) {
                    coords.add((Point)((List)((List)multiPolygon.coordinates().get(i)).get(j)).get(k));
                }
            }
        }
        return coords;
    }

    public static Point getCoord(Feature obj) {
        if (obj.geometry() instanceof Point) {
            return (Point)obj.geometry();
        }
        throw new TurfException("A Feature with a Point geometry is required.");
    }
}

