/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.staticmap.v1.models;

import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.auto.value.AutoValue;
import com.mapbox.api.staticmap.v1.models.AutoValue_StaticMarkerAnnotation;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ColorUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import java.util.Locale;

@AutoValue
public abstract class StaticMarkerAnnotation {
    public static Builder builder() {
        return new AutoValue_StaticMarkerAnnotation.Builder().name("pin-m");
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public String url() {
        if (this.iconUrl() != null) {
            return String.format(Locale.US, "url-%s(%f,%f)", this.iconUrl(), this.lnglat().longitude(), this.lnglat().latitude());
        }
        String url = this.color() != null && !TextUtils.isEmpty((CharSequence)this.label()) ? String.format(Locale.US, "%s-%s+%s", this.name(), this.label(), this.color()) : (!TextUtils.isEmpty((CharSequence)this.label()) ? String.format(Locale.US, "%s-%s", this.name(), this.label()) : (this.color() != null ? String.format(Locale.US, "%s+%s", this.name(), this.color()) : this.name()));
        return String.format(Locale.US, "%s(%f,%f)", url, this.lnglat().longitude(), this.lnglat().latitude());
    }

    @Nullable
    abstract String name();

    @Nullable
    abstract String label();

    @Nullable
    abstract String color();

    @Nullable
    abstract Point lnglat();

    @Nullable
    abstract String iconUrl();

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder name(String var1);

        public abstract Builder label(String var1);

        public abstract Builder color(@Nullable String var1);

        public Builder color(int red, int green, int blue) {
            return this.color(ColorUtils.toHexString((int)red, (int)green, (int)blue));
        }

        public abstract Builder lnglat(Point var1);

        public abstract Builder iconUrl(@Nullable String var1);

        abstract StaticMarkerAnnotation autoBuild();

        public StaticMarkerAnnotation build() {
            StaticMarkerAnnotation marker = this.autoBuild();
            if (marker.lnglat() == null) {
                throw new ServicesException("A Static map marker requires a defined longitude and latitude coordinate.");
            }
            return marker;
        }
    }
}

