/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.optimization.v1;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.api.optimization.v1.AutoValue_MapboxOptimization;
import com.mapbox.api.optimization.v1.OptimizationService;
import com.mapbox.api.optimization.v1.models.OptimizationAdapterFactory;
import com.mapbox.api.optimization.v1.models.OptimizationResponse;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;

@AutoValue
public abstract class MapboxOptimization
extends MapboxService<OptimizationResponse, OptimizationService> {
    protected MapboxOptimization() {
        super(OptimizationService.class);
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(OptimizationAdapterFactory.create()).registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    protected Call<OptimizationResponse> initializeCall() {
        return ((OptimizationService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.roundTrip(), this.radiuses(), this.bearings(), this.steps(), this.overview(), this.geometries(), this.annotations(), this.destination(), this.source(), this.language(), this.distributions());
    }

    @NonNull
    abstract String user();

    @NonNull
    abstract String profile();

    @Nullable
    abstract Boolean roundTrip();

    @Nullable
    abstract String distributions();

    @Nullable
    abstract String source();

    @Nullable
    abstract String destination();

    @Nullable
    abstract String geometries();

    @Nullable
    abstract String overview();

    @Nullable
    abstract Boolean steps();

    @Nullable
    abstract String clientAppName();

    @NonNull
    abstract String accessToken();

    @NonNull
    protected abstract String baseUrl();

    @Nullable
    abstract String language();

    @Nullable
    abstract String radiuses();

    @Nullable
    abstract String bearings();

    @NonNull
    abstract String coordinates();

    @Nullable
    abstract String annotations();

    public static Builder builder() {
        return new AutoValue_MapboxOptimization.Builder().baseUrl("https://api.mapbox.com").profile("driving").user("mapbox").geometries("polyline6");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private List<Integer[]> distributions = new ArrayList<Integer[]>();
        private List<List<Double>> bearings = new ArrayList<List<Double>>();
        private List<Point> coordinates = new ArrayList<Point>();
        private String[] annotations;
        private double[] radiuses;

        public abstract Builder user(@NonNull String var1);

        public Builder coordinates(@NonNull List<Point> coordinates) {
            this.coordinates.addAll(coordinates);
            return this;
        }

        abstract Builder coordinates(@NonNull String var1);

        public Builder coordinate(@NonNull Point coordinate) {
            this.coordinates.add(coordinate);
            return this;
        }

        public abstract Builder profile(@NonNull String var1);

        public abstract Builder roundTrip(@Nullable Boolean var1);

        public abstract Builder source(@Nullable String var1);

        public abstract Builder destination(@Nullable String var1);

        public abstract Builder geometries(@Nullable String var1);

        public abstract Builder overview(@Nullable String var1);

        public Builder radiuses(double ... radiuses) {
            this.radiuses = radiuses;
            return this;
        }

        abstract Builder radiuses(@Nullable String var1);

        public Builder bearing(@Nullable @FloatRange(from=0.0, to=360.0) Double angle, @Nullable @FloatRange(from=0.0, to=360.0) Double tolerance) {
            this.bearings.add(Arrays.asList(angle, tolerance));
            return this;
        }

        abstract Builder bearings(@Nullable String var1);

        public abstract Builder steps(@Nullable Boolean var1);

        public Builder annotations(String ... annotations) {
            this.annotations = annotations;
            return this;
        }

        abstract Builder annotations(@Nullable String var1);

        public Builder language(@Nullable Locale language) {
            if (language != null) {
                this.language(language.getLanguage());
            }
            return this;
        }

        public abstract Builder language(@Nullable String var1);

        public abstract Builder clientAppName(@NonNull String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder baseUrl(@NonNull String var1);

        public Builder distribution(@Nullable Integer pickup, @Nullable Integer dropOff) {
            this.distributions.add(new Integer[]{pickup, dropOff});
            return this;
        }

        abstract Builder distributions(@Nullable String var1);

        abstract MapboxOptimization autoBuild();

        public MapboxOptimization build() {
            if (this.coordinates == null || this.coordinates.size() < 2) {
                throw new ServicesException("At least two coordinates must be provided with your APIrequest.");
            }
            if (this.coordinates.size() > 12) {
                throw new ServicesException("Maximum of 12 coordinates are allowed for this API.");
            }
            this.coordinates(Builder.formatCoordinates(this.coordinates));
            this.bearings(FormatUtils.formatBearings(this.bearings));
            this.annotations(TextUtils.join((CharSequence)",", (Object[])this.annotations));
            this.radiuses(TextUtils.formatRadiuses((double[])this.radiuses));
            this.distributions(FormatUtils.formatDistributions(this.distributions));
            MapboxOptimization optimization = this.autoBuild();
            if (!MapboxUtils.isAccessTokenValid((String)optimization.accessToken())) {
                throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
            }
            return optimization;
        }

        private static String formatCoordinates(List<Point> coordinates) {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            for (Point point : coordinates) {
                coordinatesFormatted.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate((double)point.longitude()), FormatUtils.formatCoordinate((double)point.latitude())));
            }
            return TextUtils.join((CharSequence)";", (Object[])coordinatesFormatted.toArray());
        }
    }
}

