/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.matching.v5;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.api.matching.v5.AutoValue_MapboxMapMatching;
import com.mapbox.api.matching.v5.MapMatchingService;
import com.mapbox.api.matching.v5.MatchingResponseFactory;
import com.mapbox.api.matching.v5.models.MapMatchingAdapterFactory;
import com.mapbox.api.matching.v5.models.MapMatchingResponse;
import com.mapbox.core.MapboxService;
import com.mapbox.core.exceptions.ServicesException;
import com.mapbox.core.utils.ApiCallHelper;
import com.mapbox.core.utils.MapboxUtils;
import com.mapbox.core.utils.TextUtils;
import com.mapbox.geojson.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@AutoValue
public abstract class MapboxMapMatching
extends MapboxService<MapMatchingResponse, MapMatchingService> {
    protected MapboxMapMatching() {
        super(MapMatchingService.class);
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(MapMatchingAdapterFactory.create()).registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    protected Call<MapMatchingResponse> initializeCall() {
        if (this.usePostMethod() == null) {
            return this.callForUrlLength();
        }
        if (this.usePostMethod().booleanValue()) {
            return this.post();
        }
        return this.get();
    }

    private Call<MapMatchingResponse> callForUrlLength() {
        Call<MapMatchingResponse> get = this.get();
        if (get.request().url().toString().length() < 8192) {
            return get;
        }
        return this.post();
    }

    private Call<MapMatchingResponse> get() {
        return ((MapMatchingService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.geometries(), this.radiuses(), this.steps(), this.overview(), this.timestamps(), this.annotations(), this.language(), this.tidy(), this.roundaboutExits(), this.bannerInstructions(), this.voiceInstructions(), this.voiceUnits(), this.waypointIndices(), this.waypointNames(), this.approaches());
    }

    private Call<MapMatchingResponse> post() {
        return ((MapMatchingService)this.getService()).postCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.geometries(), this.radiuses(), this.steps(), this.overview(), this.timestamps(), this.annotations(), this.language(), this.tidy(), this.roundaboutExits(), this.bannerInstructions(), this.voiceInstructions(), this.voiceUnits(), this.waypointIndices(), this.waypointNames(), this.approaches());
    }

    public Response<MapMatchingResponse> executeCall() throws IOException {
        Response response = this.getCall().execute();
        MatchingResponseFactory factory = new MatchingResponseFactory(this);
        return factory.generate((Response<MapMatchingResponse>)response);
    }

    public void enqueueCall(final Callback<MapMatchingResponse> callback) {
        this.getCall().enqueue((Callback)new Callback<MapMatchingResponse>(){

            public void onResponse(Call<MapMatchingResponse> call, Response<MapMatchingResponse> response) {
                MatchingResponseFactory factory = new MatchingResponseFactory(MapboxMapMatching.this);
                Response<MapMatchingResponse> generatedResponse = factory.generate(response);
                callback.onResponse(call, generatedResponse);
            }

            public void onFailure(Call<MapMatchingResponse> call, Throwable throwable) {
                callback.onFailure(call, throwable);
            }
        });
    }

    @Nullable
    abstract Boolean usePostMethod();

    @Nullable
    abstract String clientAppName();

    @NonNull
    abstract String accessToken();

    @Nullable
    abstract Boolean tidy();

    @NonNull
    abstract String user();

    @NonNull
    abstract String profile();

    @NonNull
    abstract String coordinates();

    @Nullable
    abstract String geometries();

    @Nullable
    abstract String radiuses();

    @Nullable
    abstract Boolean steps();

    @Nullable
    abstract String overview();

    @Nullable
    abstract String timestamps();

    @Nullable
    abstract String annotations();

    @Nullable
    abstract String language();

    @Nullable
    abstract Boolean roundaboutExits();

    @Nullable
    abstract Boolean bannerInstructions();

    @Nullable
    abstract Boolean voiceInstructions();

    @Nullable
    abstract String voiceUnits();

    @Nullable
    abstract String waypointIndices();

    @Nullable
    abstract String waypointNames();

    @Nullable
    abstract String approaches();

    @NonNull
    protected abstract String baseUrl();

    public static Builder builder() {
        return new AutoValue_MapboxMapMatching.Builder().baseUrl("https://api.mapbox.com").profile("driving").geometries("polyline6").user("mapbox");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private List<Point> coordinates = new ArrayList<Point>();
        private String[] annotations;
        private String[] timestamps;
        private Double[] radiuses;
        private Integer[] waypointIndices;
        private String[] waypointNames;
        private String[] approaches;

        public Builder post() {
            this.usePostMethod(true);
            return this;
        }

        public Builder get() {
            this.usePostMethod(false);
            return this;
        }

        abstract Builder usePostMethod(@NonNull Boolean var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder tidy(@Nullable Boolean var1);

        public abstract Builder user(@NonNull String var1);

        public abstract Builder profile(@NonNull String var1);

        public abstract Builder geometries(@Nullable String var1);

        public Builder radiuses(Double ... radiuses) {
            this.radiuses = radiuses;
            return this;
        }

        abstract Builder radiuses(@Nullable String var1);

        @Deprecated
        public Builder waypoints(Integer ... waypoints) {
            this.waypointIndices = waypoints;
            return this;
        }

        public Builder waypointIndices(Integer ... waypointIndices) {
            this.waypointIndices = waypointIndices;
            return this;
        }

        abstract Builder waypointIndices(@Nullable String var1);

        public abstract Builder steps(@Nullable Boolean var1);

        public abstract Builder overview(@Nullable String var1);

        public abstract Builder bannerInstructions(@Nullable Boolean var1);

        public abstract Builder voiceInstructions(@Nullable Boolean var1);

        public abstract Builder voiceUnits(@Nullable String var1);

        public abstract Builder roundaboutExits(@Nullable Boolean var1);

        public Builder annotations(String ... annotations) {
            this.annotations = annotations;
            return this;
        }

        protected abstract Builder annotations(@Nullable String var1);

        public Builder timestamps(String ... timestamps) {
            this.timestamps = timestamps;
            return this;
        }

        protected abstract Builder timestamps(@Nullable String var1);

        public Builder coordinates(@NonNull List<Point> coordinates) {
            this.coordinates.addAll(coordinates);
            return this;
        }

        protected abstract Builder coordinates(@NonNull String var1);

        public Builder coordinate(@NonNull Point coordinate) {
            this.coordinates.add(coordinate);
            return this;
        }

        public Builder language(@Nullable Locale language) {
            if (language != null) {
                this.language(language.getLanguage());
            }
            return this;
        }

        public abstract Builder language(String var1);

        public abstract Builder clientAppName(@NonNull String var1);

        public Builder addApproaches(String ... approaches) {
            this.approaches = approaches;
            return this;
        }

        abstract Builder approaches(@Nullable String var1);

        public Builder addWaypointNames(String ... waypointNames) {
            this.waypointNames = waypointNames;
            return this;
        }

        abstract Builder waypointNames(@Nullable String var1);

        public abstract Builder baseUrl(String var1);

        protected abstract MapboxMapMatching autoBuild();

        public MapboxMapMatching build() {
            if (this.coordinates == null || this.coordinates.size() < 2) {
                throw new ServicesException("At least two coordinates must be provided with your API request.");
            }
            if (this.radiuses != null && this.radiuses.length != this.coordinates.size()) {
                throw new ServicesException("There must be as many radiuses as there are coordinates.");
            }
            if (this.timestamps != null && this.timestamps.length != this.coordinates.size()) {
                throw new ServicesException("There must be as many timestamps as there are coordinates.");
            }
            if (this.waypointIndices != null) {
                if (this.waypointIndices.length < 2) {
                    throw new ServicesException("Waypoints must be a list of at least two indexes separated by ';'");
                }
                if (this.waypointIndices[0] != 0 || this.waypointIndices[this.waypointIndices.length - 1] != this.coordinates.size() - 1) {
                    throw new ServicesException("Waypoints must contain indices of the first and last coordinates");
                }
                for (int i = 1; i < this.waypointIndices.length - 1; ++i) {
                    if (this.waypointIndices[i] >= 0 && this.waypointIndices[i] < this.coordinates.size()) continue;
                    throw new ServicesException("Waypoints index too large (no corresponding coordinate)");
                }
            }
            if (this.waypointNames != null) {
                String waypointNamesStr = FormatUtils.formatWaypointNames(Arrays.asList(this.waypointNames));
                this.waypointNames(waypointNamesStr);
            }
            if (this.approaches != null) {
                if (this.approaches.length != this.coordinates.size()) {
                    throw new ServicesException("Number of approach elements must match number of coordinates provided.");
                }
                String formattedApproaches = FormatUtils.formatApproaches(Arrays.asList(this.approaches));
                if (formattedApproaches == null) {
                    throw new ServicesException("All approaches values must be one of curb, unrestricted");
                }
                this.approaches(formattedApproaches);
            }
            this.coordinates(Builder.formatCoordinates(this.coordinates));
            this.timestamps(TextUtils.join((CharSequence)";", (Object[])this.timestamps));
            this.annotations(TextUtils.join((CharSequence)",", (Object[])this.annotations));
            this.radiuses(TextUtils.join((CharSequence)";", (Object[])this.radiuses));
            this.waypointIndices(TextUtils.join((CharSequence)";", (Object[])this.waypointIndices));
            MapboxMapMatching mapMatching = this.autoBuild();
            if (!MapboxUtils.isAccessTokenValid((String)mapMatching.accessToken())) {
                throw new ServicesException("Using Mapbox Services requires setting a valid access token.");
            }
            return mapMatching;
        }

        private static String formatCoordinates(List<Point> coordinates) {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            for (Point point : coordinates) {
                coordinatesFormatted.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate((double)point.longitude()), FormatUtils.formatCoordinate((double)point.latitude())));
            }
            return TextUtils.join((CharSequence)";", (Object[])coordinatesFormatted.toArray());
        }
    }
}

