

package com.mapbox.api.routetiles.v1;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.mapbox.geojson.BoundingBox;
import javax.annotation.Generated;

@Generated("com.google.auto.value.processor.AutoValueProcessor")
final class AutoValue_MapboxRouteTiles extends MapboxRouteTiles {

  private final String clientAppName;

  private final BoundingBox boundingBox;

  private final String version;

  private final String accessToken;

  private final String baseUrl;

  private AutoValue_MapboxRouteTiles(
      @Nullable String clientAppName,
      BoundingBox boundingBox,
      String version,
      String accessToken,
      String baseUrl) {
    this.clientAppName = clientAppName;
    this.boundingBox = boundingBox;
    this.version = version;
    this.accessToken = accessToken;
    this.baseUrl = baseUrl;
  }

  @Nullable
  @Override
  String clientAppName() {
    return clientAppName;
  }

  @NonNull
  @Override
  BoundingBox boundingBox() {
    return boundingBox;
  }

  @NonNull
  @Override
  String version() {
    return version;
  }

  @NonNull
  @Override
  String accessToken() {
    return accessToken;
  }

  @Override
  protected String baseUrl() {
    return baseUrl;
  }

  @Override
  public String toString() {
    return "MapboxRouteTiles{"
         + "clientAppName=" + clientAppName + ", "
         + "boundingBox=" + boundingBox + ", "
         + "version=" + version + ", "
         + "accessToken=" + accessToken + ", "
         + "baseUrl=" + baseUrl
        + "}";
  }

  @Override
  public boolean equals(Object o) {
    if (o == this) {
      return true;
    }
    if (o instanceof MapboxRouteTiles) {
      MapboxRouteTiles that = (MapboxRouteTiles) o;
      return ((this.clientAppName == null) ? (that.clientAppName() == null) : this.clientAppName.equals(that.clientAppName()))
           && (this.boundingBox.equals(that.boundingBox()))
           && (this.version.equals(that.version()))
           && (this.accessToken.equals(that.accessToken()))
           && (this.baseUrl.equals(that.baseUrl()));
    }
    return false;
  }

  @Override
  public int hashCode() {
    int h$ = 1;
    h$ *= 1000003;
    h$ ^= (clientAppName == null) ? 0 : clientAppName.hashCode();
    h$ *= 1000003;
    h$ ^= boundingBox.hashCode();
    h$ *= 1000003;
    h$ ^= version.hashCode();
    h$ *= 1000003;
    h$ ^= accessToken.hashCode();
    h$ *= 1000003;
    h$ ^= baseUrl.hashCode();
    return h$;
  }

  @Override
  public MapboxRouteTiles.Builder toBuilder() {
    return new Builder(this);
  }

  static final class Builder extends MapboxRouteTiles.Builder {
    private String clientAppName;
    private BoundingBox boundingBox;
    private String version;
    private String accessToken;
    private String baseUrl;
    Builder() {
    }
    private Builder(MapboxRouteTiles source) {
      this.clientAppName = source.clientAppName();
      this.boundingBox = source.boundingBox();
      this.version = source.version();
      this.accessToken = source.accessToken();
      this.baseUrl = source.baseUrl();
    }
    @Override
    public MapboxRouteTiles.Builder clientAppName(String clientAppName) {
      this.clientAppName = clientAppName;
      return this;
    }
    @Override
    public MapboxRouteTiles.Builder boundingBox(BoundingBox boundingBox) {
      if (boundingBox == null) {
        throw new NullPointerException("Null boundingBox");
      }
      this.boundingBox = boundingBox;
      return this;
    }
    @Override
    public MapboxRouteTiles.Builder version(String version) {
      if (version == null) {
        throw new NullPointerException("Null version");
      }
      this.version = version;
      return this;
    }
    @Override
    public MapboxRouteTiles.Builder accessToken(String accessToken) {
      if (accessToken == null) {
        throw new NullPointerException("Null accessToken");
      }
      this.accessToken = accessToken;
      return this;
    }
    @Override
    public MapboxRouteTiles.Builder baseUrl(String baseUrl) {
      if (baseUrl == null) {
        throw new NullPointerException("Null baseUrl");
      }
      this.baseUrl = baseUrl;
      return this;
    }
    @Override
    MapboxRouteTiles autoBuild() {
      String missing = "";
      if (this.boundingBox == null) {
        missing += " boundingBox";
      }
      if (this.version == null) {
        missing += " version";
      }
      if (this.accessToken == null) {
        missing += " accessToken";
      }
      if (this.baseUrl == null) {
        missing += " baseUrl";
      }
      if (!missing.isEmpty()) {
        throw new IllegalStateException("Missing required properties:" + missing);
      }
      return new AutoValue_MapboxRouteTiles(
          this.clientAppName,
          this.boundingBox,
          this.version,
          this.accessToken,
          this.baseUrl);
    }
  }

}
