/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.models.$AutoValue_StepIntersection;
import com.mapbox.api.directions.v5.models.AutoValue_StepIntersection;
import com.mapbox.api.directions.v5.models.DirectionsJsonObject;
import com.mapbox.api.directions.v5.models.IntersectionLanes;
import com.mapbox.api.directions.v5.models.MapboxStreetsV8;
import com.mapbox.api.directions.v5.models.RestStop;
import com.mapbox.api.directions.v5.models.TollCollection;
import com.mapbox.geojson.Point;
import java.util.List;

@AutoValue
public abstract class StepIntersection
extends DirectionsJsonObject {
    public static Builder builder() {
        return new $AutoValue_StepIntersection.Builder();
    }

    @NonNull
    public Point location() {
        return Point.fromLngLat((double)this.rawLocation()[0], (double)this.rawLocation()[1]);
    }

    @SerializedName(value="location")
    @NonNull
    protected abstract double[] rawLocation();

    @Nullable
    public abstract List<Integer> bearings();

    @Nullable
    public abstract List<String> classes();

    @Nullable
    public abstract List<Boolean> entry();

    @Nullable
    public abstract Integer in();

    @Nullable
    public abstract Integer out();

    @Nullable
    public abstract List<IntersectionLanes> lanes();

    @SerializedName(value="geometry_index")
    @Nullable
    public abstract Integer geometryIndex();

    @SerializedName(value="is_urban")
    @Nullable
    public abstract Boolean isUrban();

    @SerializedName(value="admin_index")
    @Nullable
    public abstract Integer adminIndex();

    @SerializedName(value="rest_stop")
    @Nullable
    public abstract RestStop restStop();

    @SerializedName(value="toll_collection")
    @Nullable
    public abstract TollCollection tollCollection();

    @SerializedName(value="mapbox_streets_v8")
    @Nullable
    public abstract MapboxStreetsV8 mapboxStreetsV8();

    @SerializedName(value="tunnel_name")
    @Nullable
    public abstract String tunnelName();

    public abstract Builder toBuilder();

    public static TypeAdapter<StepIntersection> typeAdapter(Gson gson) {
        return new AutoValue_StepIntersection.GsonTypeAdapter(gson);
    }

    public static StepIntersection fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
        return (StepIntersection)gson.create().fromJson(json, StepIntersection.class);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder bearings(@Nullable List<Integer> var1);

        public abstract Builder classes(@Nullable List<String> var1);

        public abstract Builder entry(@Nullable List<Boolean> var1);

        public abstract Builder in(@Nullable Integer var1);

        public abstract Builder out(@Nullable Integer var1);

        public abstract Builder lanes(@Nullable List<IntersectionLanes> var1);

        public abstract Builder geometryIndex(@Nullable Integer var1);

        @Nullable
        public abstract Builder isUrban(@Nullable Boolean var1);

        @Nullable
        public abstract Builder adminIndex(@Nullable Integer var1);

        @Nullable
        public abstract Builder restStop(@Nullable RestStop var1);

        @Nullable
        public abstract Builder tollCollection(@Nullable TollCollection var1);

        @Nullable
        public abstract Builder mapboxStreetsV8(@Nullable MapboxStreetsV8 var1);

        public abstract Builder tunnelName(@Nullable String var1);

        public abstract Builder rawLocation(@NonNull double[] var1);

        public abstract StepIntersection build();
    }
}

