/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.DirectionsAdapterFactory;
import com.mapbox.api.directions.v5.WalkingOptions;
import com.mapbox.api.directions.v5.WalkingOptionsAdapterFactory;
import com.mapbox.api.directions.v5.models.$AutoValue_RouteOptions;
import com.mapbox.api.directions.v5.models.AutoValue_RouteOptions;
import com.mapbox.api.directions.v5.models.DirectionsJsonObject;
import com.mapbox.api.directions.v5.utils.FormatUtils;
import com.mapbox.api.directions.v5.utils.ParseUtils;
import com.mapbox.geojson.Point;
import com.mapbox.geojson.PointAsCoordinatesTypeAdapter;
import java.util.List;

@AutoValue
public abstract class RouteOptions
extends DirectionsJsonObject {
    public static Builder builder() {
        return new $AutoValue_RouteOptions.Builder();
    }

    @NonNull
    public abstract String baseUrl();

    @NonNull
    public abstract String user();

    @NonNull
    public abstract String profile();

    @NonNull
    public abstract List<Point> coordinates();

    @Nullable
    public abstract Boolean alternatives();

    @Nullable
    public abstract String language();

    @Nullable
    public abstract String radiuses();

    @Nullable
    public List<Double> radiusesList() {
        return ParseUtils.parseToDoubles(this.radiuses());
    }

    @Nullable
    public abstract String bearings();

    @Nullable
    public List<List<Double>> bearingsList() {
        return ParseUtils.parseToListOfListOfDoubles(this.bearings());
    }

    @SerializedName(value="continue_straight")
    @Nullable
    public abstract Boolean continueStraight();

    @SerializedName(value="roundabout_exits")
    @Nullable
    public abstract Boolean roundaboutExits();

    @Nullable
    public abstract String geometries();

    @Nullable
    public abstract String overview();

    @Nullable
    public abstract Boolean steps();

    @Nullable
    public abstract String annotations();

    @Nullable
    public List<String> annotationsList() {
        return ParseUtils.parseToStrings(this.annotations(), ",");
    }

    @Nullable
    public abstract String exclude();

    @SerializedName(value="voice_instructions")
    @Nullable
    public abstract Boolean voiceInstructions();

    @SerializedName(value="banner_instructions")
    @Nullable
    public abstract Boolean bannerInstructions();

    @SerializedName(value="voice_units")
    @Nullable
    public abstract String voiceUnits();

    @SerializedName(value="access_token")
    @NonNull
    public abstract String accessToken();

    @SerializedName(value="uuid")
    @NonNull
    public abstract String requestUuid();

    @Nullable
    public abstract String approaches();

    @Nullable
    public List<String> approachesList() {
        return ParseUtils.parseToStrings(this.approaches());
    }

    @SerializedName(value="waypoints")
    @Nullable
    public abstract String waypointIndices();

    @Nullable
    public List<Integer> waypointIndicesList() {
        return ParseUtils.parseToIntegers(this.waypointIndices());
    }

    @SerializedName(value="waypoint_names")
    @Nullable
    public abstract String waypointNames();

    @Nullable
    public List<String> waypointNamesList() {
        return ParseUtils.parseToStrings(this.waypointNames());
    }

    @SerializedName(value="waypoint_targets")
    @Nullable
    public abstract String waypointTargets();

    @Nullable
    public List<Point> waypointTargetsList() {
        return ParseUtils.parseToPoints(this.waypointTargets());
    }

    @Nullable
    public abstract WalkingOptions walkingOptions();

    public static TypeAdapter<RouteOptions> typeAdapter(Gson gson) {
        return new AutoValue_RouteOptions.GsonTypeAdapter(gson);
    }

    @NonNull
    public static RouteOptions fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
        gson.registerTypeAdapter(Point.class, (Object)new PointAsCoordinatesTypeAdapter());
        gson.registerTypeAdapterFactory(WalkingOptionsAdapterFactory.create());
        return (RouteOptions)gson.create().fromJson(json, RouteOptions.class);
    }

    @NonNull
    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder baseUrl(@NonNull String var1);

        public abstract Builder user(@NonNull String var1);

        public abstract Builder profile(@NonNull String var1);

        public abstract Builder coordinates(@NonNull List<Point> var1);

        public abstract Builder alternatives(@NonNull Boolean var1);

        public abstract Builder language(@NonNull String var1);

        public abstract Builder radiuses(@NonNull String var1);

        public Builder radiusesList(@NonNull List<Double> radiuses) {
            String result = FormatUtils.formatRadiuses(radiuses);
            if (result != null) {
                this.radiuses(result);
            }
            return this;
        }

        public abstract Builder bearings(@NonNull String var1);

        public Builder bearingsList(@NonNull List<List<Double>> bearings) {
            String result = FormatUtils.formatBearings(bearings);
            if (result != null) {
                this.bearings(result);
            }
            return this;
        }

        public abstract Builder continueStraight(@NonNull Boolean var1);

        public abstract Builder roundaboutExits(@NonNull Boolean var1);

        public abstract Builder geometries(@NonNull String var1);

        public abstract Builder overview(@NonNull String var1);

        public abstract Builder steps(@NonNull Boolean var1);

        public abstract Builder annotations(@NonNull String var1);

        public Builder annotationsList(@NonNull List<String> annotations) {
            String result = FormatUtils.join(",", annotations);
            if (result != null) {
                this.annotations(result);
            }
            return this;
        }

        public abstract Builder voiceInstructions(@NonNull Boolean var1);

        public abstract Builder bannerInstructions(@NonNull Boolean var1);

        public abstract Builder voiceUnits(@NonNull String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder requestUuid(@NonNull String var1);

        public abstract Builder exclude(@NonNull String var1);

        public abstract Builder approaches(@NonNull String var1);

        public Builder approachesList(@NonNull List<String> approaches) {
            String result = FormatUtils.formatApproaches(approaches);
            if (result != null) {
                this.approaches(result);
            }
            return this;
        }

        public abstract Builder waypointIndices(@NonNull String var1);

        public Builder waypointIndicesList(@NonNull List<Integer> indices) {
            String result = FormatUtils.join(";", indices);
            if (result != null) {
                this.waypointIndices(result);
            }
            return this;
        }

        public abstract Builder waypointNames(@NonNull String var1);

        public Builder waypointNamesList(@NonNull List<String> waypointNames) {
            String result = FormatUtils.formatWaypointNames(waypointNames);
            if (result != null) {
                this.waypointNames(result);
            }
            return this;
        }

        public abstract Builder waypointTargets(@NonNull String var1);

        public Builder waypointTargetsList(@NonNull List<Point> waypointTargets) {
            this.waypointTargets(FormatUtils.formatPointsList(waypointTargets));
            return this;
        }

        public abstract Builder walkingOptions(@NonNull WalkingOptions var1);

        public abstract RouteOptions build();
    }
}

