/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.api.directions.v5;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.mapbox.api.directions.v5.;
import com.mapbox.api.directions.v5.AutoValue_WalkingOptions;
import com.mapbox.api.directions.v5.WalkingOptionsAdapterFactory;

@AutoValue
public abstract class WalkingOptions {
    @SerializedName(value="walking_speed")
    @Nullable
    public abstract Double walkingSpeed();

    @SerializedName(value="walkway_bias")
    @Nullable
    public abstract Double walkwayBias();

    @SerializedName(value="alley_bias")
    @Nullable
    public abstract Double alleyBias();

    public static WalkingOptions fromJson(String json) {
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapterFactory(WalkingOptionsAdapterFactory.create());
        return (WalkingOptions)gsonBuilder.create().fromJson(json, WalkingOptions.class);
    }

    public final String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(WalkingOptionsAdapterFactory.create()).create();
        return gson.toJson((Object)this, WalkingOptions.class);
    }

    @NonNull
    public abstract Builder toBuilder();

    public static TypeAdapter<WalkingOptions> typeAdapter(Gson gson) {
        return new AutoValue_WalkingOptions.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new .AutoValue_WalkingOptions.Builder();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder walkingSpeed(@Nullable @FloatRange(from=0.14, to=6.94) Double var1);

        public abstract Builder walkwayBias(@Nullable @FloatRange(from=-1.0, to=1.0) Double var1);

        public abstract Builder alleyBias(@Nullable @FloatRange(from=-1.0, to=1.0) Double var1);

        public abstract WalkingOptions build();
    }
}

