/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.commons.geojson;

import com.google.gson.GsonBuilder;
import com.mapbox.services.commons.geojson.GeoJSON;
import com.mapbox.services.commons.geojson.Geometry;
import com.mapbox.services.commons.geojson.custom.GeometryDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionDeserializer;
import com.mapbox.services.commons.geojson.custom.PositionSerializer;
import com.mapbox.services.commons.models.Position;
import java.util.List;

public class GeometryCollection
implements GeoJSON {
    private final String type = "GeometryCollection";
    private final List<Geometry> geometries;

    public GeometryCollection(List<Geometry> geometries) {
        this.geometries = geometries;
    }

    @Override
    public String getType() {
        return "GeometryCollection";
    }

    public List<Geometry> getGeometries() {
        return this.geometries;
    }

    public static GeometryCollection fromGeometries(List<Geometry> geometries) {
        return new GeometryCollection(geometries);
    }

    public static GeometryCollection fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionDeserializer());
        gson.registerTypeAdapter(Geometry.class, (Object)new GeometryDeserializer());
        return (GeometryCollection)gson.create().fromJson(json, GeometryCollection.class);
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapter(Position.class, (Object)new PositionSerializer());
        return gson.create().toJson((Object)this);
    }
}

