/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.annotation.SuppressLint;
import android.os.Parcel;
import android.text.TextUtils;
import androidx.annotation.Keep;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.KeyValue;
import java.util.List;

@SuppressLint(value={"ParcelCreator"})
@Keep
public class CrashEvent
extends Event {
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private final String created;
    @SerializedName(value="sdkIdentifier")
    private String sdkIdentifier;
    @SerializedName(value="sdkVersion")
    private String sdkVersion;
    @SerializedName(value="osVersion")
    private String osVersion;
    @SerializedName(value="model")
    private String model;
    @SerializedName(value="device")
    private String device;
    @SerializedName(value="isSilent")
    private String isSilent;
    @SerializedName(value="stackTraceHash")
    private String stackTraceHash;
    @SerializedName(value="stackTrace")
    private String stackTrace;
    @SerializedName(value="threadDetails")
    private String threadDetails;
    @SerializedName(value="appId")
    private String appId;
    @SerializedName(value="appVersion")
    private String appVersion;
    @SerializedName(value="customData")
    private List<KeyValue> customData;

    public CrashEvent(String event, String created) {
        this.event = event;
        this.created = created;
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.CRASH;
    }

    public String getHash() {
        return this.stackTraceHash;
    }

    public boolean isValid() {
        return !TextUtils.isEmpty((CharSequence)this.event) && !TextUtils.isEmpty((CharSequence)this.created) && !TextUtils.isEmpty((CharSequence)this.stackTraceHash);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
    }
}

