/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Bundle;
import android.util.Base64;
import android.util.Log;
import androidx.annotation.VisibleForTesting;
import com.mapbox.android.telemetry.Environment;
import com.mapbox.android.telemetry.EnvironmentResolver;
import com.mapbox.android.telemetry.ServerInformation;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;

class ComServerInformation
implements EnvironmentResolver {
    private final String LOG_TAG = "ComServerInformation";
    private final String DIGEST = "SHA-256";
    private final String KEY_META_DATA_COM_SERVER = "com.mapbox.ComEventsServer";
    private List<String> configurationList = new ArrayList<String>(){
        {
            this.add("FVQ3CP/SEI8eLPxHJnjyew2P5DTC1OBKK4Y6XkmC0WI=");
        }
    };

    ComServerInformation() {
    }

    @Override
    public void nextChain(EnvironmentResolver chain) {
    }

    @Override
    public ServerInformation obtainServerInformation(Bundle appMetaData) {
        String hostnameHash;
        ServerInformation com = new ServerInformation(Environment.COM);
        String hostname = appMetaData.getString("com.mapbox.ComEventsServer");
        if (!TelemetryUtils.isEmpty(hostname) && !TelemetryUtils.isEmpty(hostnameHash = this.obtainHash(hostname)) && this.configurationList.contains(hostnameHash)) {
            com.setHostname(hostname);
        }
        return com;
    }

    private String obtainHash(String hostname) {
        String hostNameHash = null;
        try {
            byte[] digest = MessageDigest.getInstance("SHA-256").digest(hostname.getBytes());
            hostNameHash = Base64.encodeToString((byte[])digest, (int)2);
        }
        catch (Exception exception) {
            Log.d((String)"ComServerInformation", (String)String.format("Hostname error %s", exception.getMessage()));
        }
        return hostNameHash;
    }

    @VisibleForTesting
    void setConfigurationList(List<String> configurationList) {
        this.configurationList = configurationList;
    }
}

