/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry.metrics.network;

import com.mapbox.android.telemetry.metrics.network.NetworkUsageMetricsCollector;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;

public class NetworkUsageInterceptor
implements Interceptor {
    private final NetworkUsageMetricsCollector metricsCollector;

    public NetworkUsageInterceptor(NetworkUsageMetricsCollector metricsCollector) {
        this.metricsCollector = metricsCollector;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        RequestBody requestBody = request.body();
        if (requestBody == null) {
            return chain.proceed(request);
        }
        Response response = chain.proceed(request);
        this.metricsCollector.addTxBytes(requestBody.contentLength());
        ResponseBody responseBody = response.body();
        if (responseBody == null) {
            return response;
        }
        this.metricsCollector.addRxBytes(responseBody.contentLength());
        return response;
    }
}

