/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.JsonAdapter;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.FeedbackData;
import com.mapbox.android.telemetry.FeedbackDataSerializer;
import com.mapbox.android.telemetry.FeedbackEventData;
import com.mapbox.android.telemetry.FeedbackEventDataSerializer;
import com.mapbox.android.telemetry.LocationDataSerializer;
import com.mapbox.android.telemetry.NavigationLocationData;
import com.mapbox.android.telemetry.NavigationMetadata;
import com.mapbox.android.telemetry.NavigationMetadataSerializer;
import com.mapbox.android.telemetry.NavigationState;
import com.mapbox.android.telemetry.NavigationStepMetadata;

class NavigationFeedbackEvent
extends Event
implements Parcelable {
    private static final String NAVIGATION_FEEDBACK = "navigation.feedback";
    private final String event;
    @JsonAdapter(value=NavigationMetadataSerializer.class)
    private NavigationMetadata metadata;
    @JsonAdapter(value=FeedbackEventDataSerializer.class)
    private FeedbackEventData feedbackEventData;
    @JsonAdapter(value=LocationDataSerializer.class)
    private NavigationLocationData navigationLocationData;
    @JsonAdapter(value=FeedbackDataSerializer.class)
    private FeedbackData feedbackData;
    private NavigationStepMetadata step = null;
    public static final Parcelable.Creator<NavigationFeedbackEvent> CREATOR = new Parcelable.Creator<NavigationFeedbackEvent>(){

        public NavigationFeedbackEvent createFromParcel(Parcel in) {
            return new NavigationFeedbackEvent(in);
        }

        public NavigationFeedbackEvent[] newArray(int size) {
            return new NavigationFeedbackEvent[size];
        }
    };

    NavigationFeedbackEvent(NavigationState navigationState) {
        this.event = NAVIGATION_FEEDBACK;
        this.metadata = navigationState.getNavigationMetadata();
        this.feedbackEventData = navigationState.getFeedbackEventData();
        this.navigationLocationData = navigationState.getNavigationLocationData();
        this.feedbackData = navigationState.getFeedbackData();
        this.step = navigationState.getNavigationStepMetadata();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.NAV_FEEDBACK;
    }

    String getEvent() {
        return this.event;
    }

    NavigationMetadata getMetadata() {
        return this.metadata;
    }

    FeedbackEventData getFeedbackEventData() {
        return this.feedbackEventData;
    }

    NavigationLocationData getNavigationLocationData() {
        return this.navigationLocationData;
    }

    FeedbackData getFeedbackData() {
        return this.feedbackData;
    }

    NavigationStepMetadata getStep() {
        return this.step;
    }

    private NavigationFeedbackEvent(Parcel in) {
        this.event = in.readString();
        this.metadata = (NavigationMetadata)in.readValue(NavigationMetadata.class.getClassLoader());
        this.feedbackEventData = (FeedbackEventData)in.readValue(FeedbackEventData.class.getClassLoader());
        this.navigationLocationData = (NavigationLocationData)in.readValue(NavigationLocationData.class.getClassLoader());
        this.feedbackData = (FeedbackData)in.readValue(FeedbackData.class.getClassLoader());
        this.step = (NavigationStepMetadata)in.readValue(NavigationStepMetadata.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeValue((Object)this.metadata);
        dest.writeValue((Object)this.feedbackEventData);
        dest.writeValue((Object)this.navigationLocationData);
        dest.writeValue((Object)this.feedbackData);
        dest.writeValue((Object)this.step);
    }
}

