/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mapbox.android.telemetry.NavigationCancelEvent;
import java.lang.reflect.Type;
import java.util.Map;

class CancelEventSerializer
implements JsonSerializer<NavigationCancelEvent> {
    private static final String EVENT = "event";

    CancelEventSerializer() {
    }

    public JsonElement serialize(NavigationCancelEvent src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject cancelEvent = new JsonObject();
        cancelEvent.addProperty(EVENT, src.getEvent());
        this.serializeCancelData(src, context, cancelEvent);
        this.serializeMetadata(src, context, cancelEvent);
        return cancelEvent;
    }

    private void serializeCancelData(NavigationCancelEvent src, JsonSerializationContext context, JsonObject cancelEvent) {
        JsonObject cancelData = context.serialize((Object)src.getCancelData()).getAsJsonObject();
        for (Map.Entry e : cancelData.entrySet()) {
            cancelEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeMetadata(NavigationCancelEvent src, JsonSerializationContext context, JsonObject cancelEvent) {
        JsonObject metadata = context.serialize((Object)src.getMetadata()).getAsJsonObject();
        for (Map.Entry e : metadata.entrySet()) {
            cancelEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }
}

