/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.support.v4.content.PermissionChecker;
import android.util.Log;
import com.mapbox.android.core.location.LocationEngine;
import com.mapbox.android.core.location.LocationEngineCallback;
import com.mapbox.android.core.location.LocationEngineProvider;
import com.mapbox.android.core.location.LocationEngineRequest;
import com.mapbox.android.core.location.LocationEngineResult;
import com.mapbox.android.core.permissions.PermissionsManager;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.EventCallback;
import com.mapbox.android.telemetry.EventsQueue;
import com.mapbox.android.telemetry.LocationReceiver;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.ServiceTaskCallback;
import com.mapbox.android.telemetry.SessionIdentifier;
import com.mapbox.android.telemetry.TelemetryCallback;
import com.mapbox.android.telemetry.TelemetryLocationEnabler;
import com.mapbox.android.telemetry.TelemetryReceiver;
import java.util.List;
import java.util.concurrent.CopyOnWriteArraySet;

public class TelemetryService
extends Service
implements TelemetryCallback,
EventCallback {
    public static final String IS_LOCATION_ENABLER_FROM_PREFERENCES = "isLocationEnablerFromPreferences";
    private static final String MISSING_FINE_PERMISSION = "Detected that ACCESS_FINE_LOCATION permission is missing from the manifest. This is a required permission for Mapbox.Please add this permission back into your manifest, so our system can work properly";
    private static final String NULL_APPLICATION_CONTEXT = "MapboxTelemetry.applicationContext is null. Preventing call of methods that require a non-null context.";
    public static final int API_LEVEL_23 = 23;
    private static final long DEFAULT_INTERVAL_IN_MILLISECONDS = 1000L;
    private static final long DEFAULT_MAX_WAIT_TIME = 5000L;
    private static final String TAG = "TelemetryService";
    private LocationReceiver locationReceiver = null;
    private TelemetryReceiver telemetryReceiver = null;
    private EventsQueue queue = null;
    private int boundInstances = 0;
    private LocationEngine locationEngine = null;
    private CopyOnWriteArraySet<ServiceTaskCallback> serviceTaskCallbacks = null;
    private TelemetryLocationEnabler telemetryLocationEnabler;
    private boolean isLocationEnablerFromPreferences = true;
    private boolean isLocationReceiverRegistered = false;
    private boolean isTelemetryReceiverRegistered = false;
    private final LocationEngineCallback<LocationEngineResult> callback = new LocationEngineCallback<LocationEngineResult>(){

        public void onSuccess(LocationEngineResult result) {
            TelemetryService.this.checkApplicationContext();
            List locations = result.getLocations();
            Log.d((String)TelemetryService.TAG, (String)("Locations reported: " + locations.size()));
            if (locations == null || locations.isEmpty()) {
                Log.e((String)TelemetryService.TAG, (String)"Location is unavailable");
                return;
            }
            LocalBroadcastManager.getInstance((Context)TelemetryService.this.getApplicationContext()).sendBroadcast(LocationReceiver.supplyIntent(locations));
        }

        public void onFailure(@NonNull Exception exception) {
            Log.e((String)TelemetryService.TAG, (String)exception.toString());
        }
    };

    public void onCreate() {
        super.onCreate();
        this.createLocationReceiver();
        this.createTelemetryReceiver();
        this.createServiceTaskCallbacks();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        this.checkApplicationContext();
        this.enableTelemetryLocationState(intent);
        return 3;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return new TelemetryBinder();
    }

    public void onDestroy() {
        this.checkApplicationContext();
        this.unregisterLocationReceiver();
        this.unregisterTelemetryReceiver();
        this.disableTelemetryLocationState();
        super.onDestroy();
    }

    public void onTaskRemoved(Intent rootIntent) {
        for (ServiceTaskCallback callback : this.serviceTaskCallbacks) {
            callback.onTaskRemoved();
        }
        super.onTaskRemoved(rootIntent);
    }

    @Override
    public void onBackground() {
        System.out.println("TelemetryService#onBackground: Shutting down location receiver...");
        this.unregisterLocationReceiver();
    }

    @Override
    public void onForeground() {
        System.out.println("TelemetryService#onForeground: Restarting location receiver...");
        this.registerLocationReceiver();
    }

    @Override
    public void onEventReceived(Event event) {
        if (this.queue != null) {
            this.queue.push(event);
        }
    }

    public void updateSessionIdentifier(SessionIdentifier sessionIdentifier) {
        this.locationReceiver.updateSessionIdentifier(sessionIdentifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindInstance() {
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            ++this.boundInstances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unbindInstance() {
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            --this.boundInstances;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int obtainBoundInstances() {
        TelemetryService telemetryService = this;
        synchronized (telemetryService) {
            return this.boundInstances;
        }
    }

    boolean addServiceTask(ServiceTaskCallback callback) {
        return this.serviceTaskCallbacks.add(callback);
    }

    boolean removeServiceTask(ServiceTaskCallback callback) {
        return this.serviceTaskCallbacks.remove(callback);
    }

    void injectEventsQueue(EventsQueue queue) {
        this.queue = queue;
    }

    boolean isLocationReceiverRegistered() {
        return this.isLocationReceiverRegistered;
    }

    boolean isTelemetryReceiverRegistered() {
        return this.isTelemetryReceiverRegistered;
    }

    private void createLocationReceiver() {
        this.locationReceiver = new LocationReceiver(this);
        this.registerLocationReceiver();
    }

    private void registerLocationReceiver() {
        this.locationEngine = LocationEngineProvider.getBestLocationEngine((Context)this.getApplicationContext(), (boolean)true);
        if (this.locationPermissionCheck()) {
            try {
                this.locationEngine.requestLocationUpdates(TelemetryService.getRequest(), this.callback, this.getMainLooper());
            }
            catch (SecurityException se) {
                Log.e((String)TAG, (String)se.toString());
            }
        }
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.locationReceiver, new IntentFilter("com.mapbox.location_receiver"));
        this.isLocationReceiverRegistered = true;
    }

    private static LocationEngineRequest getRequest() {
        return new LocationEngineRequest.Builder(1000L).setPriority(3).setMaxWaitTime(5000L).build();
    }

    private void createTelemetryReceiver() {
        this.telemetryReceiver = new TelemetryReceiver(this);
        this.registerTelemetryReceiver();
    }

    private void registerTelemetryReceiver() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.telemetryReceiver, new IntentFilter("com.mapbox.telemetry_receiver"));
        this.isTelemetryReceiverRegistered = true;
    }

    private void createServiceTaskCallbacks() {
        this.serviceTaskCallbacks = new CopyOnWriteArraySet();
    }

    private void enableTelemetryLocationState(Intent intent) {
        this.isLocationEnablerFromPreferences = intent.getBooleanExtra(IS_LOCATION_ENABLER_FROM_PREFERENCES, true);
        if (this.isLocationEnablerFromPreferences) {
            this.createLocationEnabler();
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.ENABLED);
        }
    }

    private void unregisterLocationReceiver() {
        this.locationEngine.removeLocationUpdates(this.callback);
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.locationReceiver);
        this.isLocationReceiverRegistered = false;
    }

    private void unregisterTelemetryReceiver() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.telemetryReceiver);
        this.isTelemetryReceiverRegistered = false;
    }

    private void disableTelemetryLocationState() {
        if (this.isLocationEnablerFromPreferences) {
            this.createLocationEnabler();
            this.telemetryLocationEnabler.updateTelemetryLocationState(TelemetryLocationEnabler.LocationState.DISABLED);
        }
    }

    private void checkApplicationContext() {
        if (MapboxTelemetry.applicationContext == null) {
            MapboxTelemetry.applicationContext = this.getApplicationContext();
        }
    }

    private void createLocationEnabler() {
        if (this.telemetryLocationEnabler == null) {
            this.telemetryLocationEnabler = new TelemetryLocationEnabler(true);
        }
    }

    private boolean locationPermissionCheck() {
        if (Build.VERSION.SDK_INT >= 23) {
            return PermissionsManager.areLocationPermissionsGranted((Context)this);
        }
        if (MapboxTelemetry.applicationContext == null) {
            Log.d((String)"Null Context", (String)NULL_APPLICATION_CONTEXT);
            return false;
        }
        int finePermission = PermissionChecker.checkSelfPermission((Context)MapboxTelemetry.applicationContext, (String)"android.permission.ACCESS_FINE_LOCATION");
        return this.checkFinePermission(finePermission);
    }

    private boolean checkFinePermission(int finePermission) {
        if (finePermission != 0) {
            Log.d((String)"Missing Permission", (String)MISSING_FINE_PERMISSION);
            return false;
        }
        return true;
    }

    class TelemetryBinder
    extends Binder {
        TelemetryBinder() {
        }

        TelemetryService obtainService() {
            return TelemetryService.this;
        }
    }
}

