/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.JsonAdapter;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.NavigationMetadata;
import com.mapbox.android.telemetry.NavigationMetadataSerializer;
import com.mapbox.android.telemetry.NavigationState;

class NavigationArriveEvent
extends Event
implements Parcelable {
    private static final String NAVIGATION_ARRIVE = "navigation.arrive";
    private final String event;
    @JsonAdapter(value=NavigationMetadataSerializer.class)
    private NavigationMetadata metadata;
    public static final Parcelable.Creator<NavigationArriveEvent> CREATOR = new Parcelable.Creator<NavigationArriveEvent>(){

        public NavigationArriveEvent createFromParcel(Parcel in) {
            return new NavigationArriveEvent(in);
        }

        public NavigationArriveEvent[] newArray(int size) {
            return new NavigationArriveEvent[size];
        }
    };

    NavigationArriveEvent(NavigationState navigationState) {
        this.event = NAVIGATION_ARRIVE;
        this.metadata = navigationState.getNavigationMetadata();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.NAV_ARRIVE;
    }

    String getEvent() {
        return this.event;
    }

    NavigationMetadata getMetadata() {
        return this.metadata;
    }

    private NavigationArriveEvent(Parcel in) {
        this.event = in.readString();
        this.metadata = (NavigationMetadata)in.readParcelable(NavigationMetadata.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeParcelable((Parcelable)this.metadata, flags);
    }
}

