/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.MapBuildEvent;
import com.mapbox.android.telemetry.MapClickEvent;
import com.mapbox.android.telemetry.MapDragendEvent;
import com.mapbox.android.telemetry.MapLoadEvent;
import com.mapbox.android.telemetry.MapState;
import com.mapbox.android.telemetry.MapboxTelemetry;
import com.mapbox.android.telemetry.OfflineDownloadEndEvent;
import com.mapbox.android.telemetry.OfflineDownloadStartEvent;
import com.mapbox.android.telemetry.TelemetryUtils;
import java.util.HashMap;
import java.util.Map;

public class MapEventFactory {
    private static final String APPLICATION_CONTEXT_CANT_BE_NULL = "Create a MapboxTelemetry instance before calling this method.";
    private static final String LANDSCAPE = "Landscape";
    private static final String PORTRAIT = "Portrait";
    private static final String NO_CARRIER = "EMPTY_CARRIER";
    private static final int NO_NETWORK = -1;
    private static final String NOT_A_LOAD_MAP_EVENT_TYPE = "Type must be a load map event.";
    private static final String NOT_A_GESTURE_MAP_EVENT_TYPE = "Type must be a gesture map event.";
    private static final String NOT_OFFLINEDOWNLOAD_EVENT_TYPE = "Type must be an offline download map event.";
    private static final String MAP_STATE_ILLEGAL_NULL = "MapState cannot be null.";
    private static final Map<Integer, String> ORIENTATIONS = new HashMap<Integer, String>(){
        {
            this.put(2, MapEventFactory.LANDSCAPE);
            this.put(1, MapEventFactory.PORTRAIT);
        }
    };
    private final Map<Event.Type, MapBuildEvent> BUILD_EVENT_MAP_GESTURE = new HashMap<Event.Type, MapBuildEvent>(){
        {
            this.put(Event.Type.MAP_CLICK, new MapBuildEvent(){

                @Override
                public Event build(MapState mapState) {
                    return MapEventFactory.this.buildMapClickEvent(mapState);
                }
            });
            this.put(Event.Type.MAP_DRAGEND, new MapBuildEvent(){

                @Override
                public Event build(MapState mapState) {
                    return MapEventFactory.this.buildMapDragendEvent(mapState);
                }
            });
        }
    };

    public MapEventFactory() {
        if (MapboxTelemetry.applicationContext == null) {
            throw new IllegalStateException(APPLICATION_CONTEXT_CANT_BE_NULL);
        }
    }

    public Event createMapLoadEvent(Event.Type type) {
        this.checkLoad(type);
        return this.buildMapLoadEvent();
    }

    public Event createMapGestureEvent(Event.Type type, MapState mapState) {
        this.checkGesture(type, mapState);
        return this.BUILD_EVENT_MAP_GESTURE.get((Object)type).build(mapState);
    }

    public Event createOfflineDownloadStartEvent(String shapeForOfflineRegion, Double minZoom, Double maxZoom, String styleURL) {
        OfflineDownloadStartEvent offlineEvent = new OfflineDownloadStartEvent(shapeForOfflineRegion, minZoom, maxZoom);
        offlineEvent.setStyleURL(styleURL);
        return offlineEvent;
    }

    public Event createOfflineDownloadCompleteEvent(String shapeForOfflineRegion, Double minZoom, Double maxZoom, String styleURL, Long sizeOfResourcesCompleted, Long numberOfTilesCompleted, String state) {
        OfflineDownloadEndEvent offlineEvent = new OfflineDownloadEndEvent(shapeForOfflineRegion, minZoom, maxZoom);
        offlineEvent.setStyleURL(styleURL);
        offlineEvent.setSizeOfResourcesCompleted(sizeOfResourcesCompleted);
        offlineEvent.setNumberOfTilesCompleted(numberOfTilesCompleted);
        return offlineEvent;
    }

    private MapClickEvent buildMapClickEvent(MapState mapState) {
        MapClickEvent mapClickEvent = new MapClickEvent(mapState).setDeviceInfo(MapboxTelemetry.applicationContext);
        mapClickEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        mapClickEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        mapClickEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        return mapClickEvent;
    }

    private MapDragendEvent buildMapDragendEvent(MapState mapState) {
        MapDragendEvent mapDragendEvent = new MapDragendEvent(mapState).setDeviceInfo(MapboxTelemetry.applicationContext);
        mapDragendEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        mapDragendEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        mapDragendEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        return mapDragendEvent;
    }

    private String obtainOrientation(Context context) {
        return ORIENTATIONS.get(context.getResources().getConfiguration().orientation);
    }

    private float obtainAccessibilityFontScaleSize(Context context) {
        return context.getResources().getConfiguration().fontScale;
    }

    private String obtainCellularCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        if (TextUtils.isEmpty((CharSequence)carrierName)) {
            return NO_CARRIER;
        }
        return carrierName;
    }

    private float obtainDisplayDensity(Context context) {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getMetrics(displayMetrics);
        return displayMetrics.density;
    }

    private Boolean obtainConnectedToWifi(Context context) {
        return this.isConnectedToWifi(context);
    }

    private boolean isConnectedToWifi(Context context) {
        try {
            WifiManager wifiMgr = (WifiManager)context.getApplicationContext().getSystemService("wifi");
            WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
            return this.isWifiConnected(wifiMgr, wifiInfo);
        }
        catch (Exception exception) {
            return false;
        }
    }

    private boolean isWifiConnected(WifiManager wifiMgr, WifiInfo wifiInfo) {
        return wifiMgr.isWifiEnabled() && this.networkConnected(wifiInfo);
    }

    private boolean networkConnected(WifiInfo wifiInfo) {
        return wifiInfo.getNetworkId() != -1;
    }

    private MapLoadEvent buildMapLoadEvent() {
        String userId = TelemetryUtils.retrieveVendorId();
        MapLoadEvent mapLoadEvent = new MapLoadEvent(userId).setDeviceInfo(MapboxTelemetry.applicationContext);
        mapLoadEvent.setOrientation(this.obtainOrientation(MapboxTelemetry.applicationContext));
        mapLoadEvent.setAccessibilityFontScale(this.obtainAccessibilityFontScaleSize(MapboxTelemetry.applicationContext));
        mapLoadEvent.setCarrier(this.obtainCellularCarrier(MapboxTelemetry.applicationContext));
        mapLoadEvent.setResolution(this.obtainDisplayDensity(MapboxTelemetry.applicationContext));
        mapLoadEvent.setWifi(this.obtainConnectedToWifi(MapboxTelemetry.applicationContext));
        return mapLoadEvent;
    }

    private void checkLoad(Event.Type type) {
        if (type != Event.Type.MAP_LOAD) {
            throw new IllegalArgumentException(NOT_A_LOAD_MAP_EVENT_TYPE);
        }
    }

    private void checkGesture(Event.Type type, MapState mapState) {
        this.checkGestureMapEvent(type);
        this.isNotNull(mapState);
    }

    private void checkGestureMapEvent(Event.Type type) {
        if (!Event.mapGestureEventTypes.contains((Object)type)) {
            throw new IllegalArgumentException(NOT_A_GESTURE_MAP_EVENT_TYPE);
        }
    }

    private void isNotNull(MapState mapState) {
        if (mapState == null) {
            throw new IllegalArgumentException(MAP_STATE_ILLEGAL_NULL);
        }
    }
}

