/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.gson.annotations.SerializedName;
import com.mapbox.android.telemetry.Event;
import com.mapbox.android.telemetry.TelemetryUtils;

class MapLoadEvent
extends Event
implements Parcelable {
    private static final String MAP_LOAD = "map.load";
    private static final String OPERATING_SYSTEM = "Android - " + Build.VERSION.RELEASE;
    @SerializedName(value="event")
    private final String event;
    @SerializedName(value="created")
    private String created;
    @SerializedName(value="userId")
    private String userId;
    @SerializedName(value="model")
    private String model = null;
    @SerializedName(value="operatingSystem")
    private String operatingSystem = null;
    @SerializedName(value="resolution")
    private Float resolution = null;
    @SerializedName(value="accessibilityFontScale")
    private Float accessibilityFontScale = null;
    @SerializedName(value="orientation")
    private String orientation = null;
    @SerializedName(value="batteryLevel")
    private Integer batteryLevel;
    @SerializedName(value="pluggedIn")
    private Boolean pluggedIn;
    @SerializedName(value="carrier")
    private String carrier = null;
    @SerializedName(value="cellularNetworkType")
    private String cellularNetworkType;
    @SerializedName(value="wifi")
    private Boolean wifi = null;
    @SerializedName(value="sdkIdentifier")
    private String sdkIdentifier = null;
    @SerializedName(value="sdkVersion")
    private String sdkVersion = null;
    public static final Parcelable.Creator<MapLoadEvent> CREATOR = new Parcelable.Creator<MapLoadEvent>(){

        public MapLoadEvent createFromParcel(Parcel in) {
            return new MapLoadEvent(in);
        }

        public MapLoadEvent[] newArray(int size) {
            return new MapLoadEvent[size];
        }
    };

    MapLoadEvent(String userId) {
        this.event = MAP_LOAD;
        this.model = Build.MODEL;
        this.operatingSystem = OPERATING_SYSTEM;
        this.created = TelemetryUtils.obtainCurrentDate();
        this.userId = userId;
        this.batteryLevel = TelemetryUtils.obtainBatteryLevel();
        this.pluggedIn = TelemetryUtils.isPluggedIn();
        this.cellularNetworkType = TelemetryUtils.obtainCellularNetworkType();
    }

    @Override
    Event.Type obtainType() {
        return Event.Type.MAP_LOAD;
    }

    void setResolution(float resolution) {
        this.resolution = Float.valueOf(resolution);
    }

    void setAccessibilityFontScale(float accessibilityFontScale) {
        this.accessibilityFontScale = Float.valueOf(accessibilityFontScale);
    }

    void setOrientation(String orientation) {
        this.orientation = orientation;
    }

    void setCarrier(String carrier) {
        this.carrier = carrier;
    }

    void setWifi(boolean wifi) {
        this.wifi = wifi;
    }

    void setSdkIdentifier(String sdkIdentifier) {
        this.sdkIdentifier = sdkIdentifier;
    }

    void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    private MapLoadEvent(Parcel in) {
        this.event = in.readString();
        this.created = in.readString();
        this.userId = in.readString();
        this.model = in.readString();
        this.operatingSystem = in.readString();
        this.resolution = in.readByte() == 0 ? null : Float.valueOf(in.readFloat());
        this.accessibilityFontScale = in.readByte() == 0 ? null : Float.valueOf(in.readFloat());
        this.orientation = in.readString();
        this.batteryLevel = in.readInt();
        this.pluggedIn = in.readByte() != 0;
        this.carrier = in.readString();
        this.cellularNetworkType = in.readString();
        byte wifiVal = in.readByte();
        this.wifi = wifiVal == 2 ? null : Boolean.valueOf(wifiVal != 0);
        this.sdkIdentifier = in.readString();
        this.sdkVersion = in.readString();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.event);
        dest.writeString(this.created);
        dest.writeString(this.userId);
        dest.writeString(this.model);
        dest.writeString(this.operatingSystem);
        if (this.resolution == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeFloat(this.resolution.floatValue());
        }
        if (this.accessibilityFontScale == null) {
            dest.writeByte((byte)0);
        } else {
            dest.writeByte((byte)1);
            dest.writeFloat(this.accessibilityFontScale.floatValue());
        }
        dest.writeString(this.orientation);
        dest.writeInt(this.batteryLevel.intValue());
        dest.writeByte((byte)(this.pluggedIn != false ? 1 : 0));
        dest.writeString(this.carrier);
        dest.writeString(this.cellularNetworkType);
        if (this.wifi == null) {
            dest.writeByte((byte)2);
        } else {
            dest.writeByte((byte)(this.wifi != false ? 1 : 0));
        }
        dest.writeString(this.sdkIdentifier);
        dest.writeString(this.sdkVersion);
    }
}

