/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mapbox.android.telemetry.NavigationRerouteEvent;
import java.lang.reflect.Type;
import java.util.Map;

class RerouteEventSerializer
implements JsonSerializer<NavigationRerouteEvent> {
    private static final String EVENT = "event";
    private static final String STEP = "step";

    RerouteEventSerializer() {
    }

    public JsonElement serialize(NavigationRerouteEvent src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject rerouteEvent = new JsonObject();
        rerouteEvent.addProperty(EVENT, src.getEvent());
        this.serializeMetadata(src, context, rerouteEvent);
        this.serializeRerouteData(src, context, rerouteEvent);
        this.serializeLocationData(src, context, rerouteEvent);
        this.serializeFeedbackData(src, context, rerouteEvent);
        this.serializeVoiceData(src, context, rerouteEvent);
        this.serializeStep(src, context, rerouteEvent);
        return rerouteEvent;
    }

    private void serializeMetadata(NavigationRerouteEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonObject metadata = context.serialize((Object)src.getNavigationMetadata()).getAsJsonObject();
        for (Map.Entry e : metadata.entrySet()) {
            feedbackEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeRerouteData(NavigationRerouteEvent src, JsonSerializationContext context, JsonObject rerouteEvent) {
        JsonObject rerouteData = context.serialize((Object)src.getNavigationRerouteData()).getAsJsonObject();
        for (Map.Entry e : rerouteData.entrySet()) {
            rerouteEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeLocationData(NavigationRerouteEvent src, JsonSerializationContext context, JsonObject rerouteEvent) {
        JsonObject locationData = context.serialize((Object)src.getNavigationLocationData()).getAsJsonObject();
        for (Map.Entry e : locationData.entrySet()) {
            rerouteEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeFeedbackData(NavigationRerouteEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonObject feedbackData = context.serialize((Object)src.getFeedbackData()).getAsJsonObject();
        for (Map.Entry e : feedbackData.entrySet()) {
            feedbackEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeVoiceData(NavigationRerouteEvent src, JsonSerializationContext context, JsonObject feedbackEvent) {
        JsonObject voiceData = context.serialize((Object)src.getVoiceData()).getAsJsonObject();
        for (Map.Entry e : voiceData.entrySet()) {
            feedbackEvent.add((String)e.getKey(), (JsonElement)e.getValue());
        }
    }

    private void serializeStep(NavigationRerouteEvent src, JsonSerializationContext context, JsonObject rerouteEvent) {
        JsonElement step = context.serialize((Object)src.getStep());
        rerouteEvent.add(STEP, step);
    }
}

