/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.android.telemetry;

import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.support.annotation.RequiresApi;
import android.support.v4.content.LocalBroadcastManager;
import com.mapbox.android.telemetry.SchedulerCallback;
import com.mapbox.android.telemetry.SchedulerFlusher;
import com.mapbox.android.telemetry.SchedulerFlusherJobService;

class JobSchedulerFlusher
implements SchedulerFlusher {
    private static final int SCHEDULER_FLUSHER_JOB_ID = 0;
    static final String START_JOB_INTENT_KEY = "start_job";
    static final String STOP_JOB_INTENT_KEY = "stop_job";
    private final Context context;
    private final SchedulerCallback callback;
    private BroadcastReceiver receiver;

    JobSchedulerFlusher(Context context, SchedulerCallback callback) {
        this.context = context;
        this.callback = callback;
    }

    @Override
    public void register() {
        this.receiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String start = intent.getStringExtra(JobSchedulerFlusher.START_JOB_INTENT_KEY);
                String stop = intent.getStringExtra(JobSchedulerFlusher.STOP_JOB_INTENT_KEY);
                if (start != null) {
                    JobSchedulerFlusher.this.callback.onPeriodRaised();
                }
                if (stop != null) {
                    JobSchedulerFlusher.this.callback.onError();
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.context).registerReceiver(this.receiver, new IntentFilter("com.mapbox.scheduler_flusher"));
    }

    @Override
    @RequiresApi(api=21)
    public void schedule(long elapsedRealTime) {
        JobScheduler jobScheduler = (JobScheduler)this.context.getSystemService("jobscheduler");
        jobScheduler.schedule(new JobInfo.Builder(0, new ComponentName(this.context, SchedulerFlusherJobService.class)).setPeriodic(180000L).build());
    }

    @Override
    public void unregister() {
        LocalBroadcastManager.getInstance((Context)this.context).unregisterReceiver(this.receiver);
    }
}

