/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.location;

import android.content.Context;
import android.location.Location;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationListener;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import java.lang.ref.WeakReference;

public class GoogleLocationEngine
extends LocationEngine
implements GoogleApiClient.ConnectionCallbacks,
GoogleApiClient.OnConnectionFailedListener,
LocationListener {
    private static final String LOG_TAG = GoogleLocationEngine.class.getSimpleName();
    private static LocationEngine instance;
    private WeakReference<Context> context;
    private GoogleApiClient googleApiClient;

    public GoogleLocationEngine(Context context) {
        this.context = new WeakReference<Context>(context);
        this.googleApiClient = new GoogleApiClient.Builder((Context)this.context.get()).addConnectionCallbacks((GoogleApiClient.ConnectionCallbacks)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
    }

    public static synchronized LocationEngine getLocationEngine(Context context) {
        if (instance == null) {
            instance = new GoogleLocationEngine(context.getApplicationContext());
        }
        return instance;
    }

    @Override
    public void activate() {
        this.connect();
    }

    @Override
    public void deactivate() {
        if (this.googleApiClient != null && this.googleApiClient.isConnected()) {
            this.googleApiClient.disconnect();
        }
    }

    @Override
    public boolean isConnected() {
        return this.googleApiClient.isConnected();
    }

    public void onConnected(@Nullable Bundle bundle) {
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onConnected();
        }
    }

    public void onConnectionSuspended(int cause) {
        Log.d((String)LOG_TAG, (String)("Connection suspended: " + cause));
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
        Log.d((String)LOG_TAG, (String)("Connection failed:" + connectionResult.getErrorMessage()));
    }

    @Override
    public Location getLastLocation() {
        if (this.googleApiClient.isConnected()) {
            return LocationServices.FusedLocationApi.getLastLocation(this.googleApiClient);
        }
        return null;
    }

    @Override
    public void requestLocationUpdates() {
        LocationRequest request = LocationRequest.create();
        if (this.interval != null) {
            request.setInterval((long)this.interval.intValue());
        }
        if (this.fastestInterval != null) {
            request.setFastestInterval((long)this.fastestInterval.intValue());
        }
        if (this.smallestDisplacement != null) {
            request.setSmallestDisplacement(this.smallestDisplacement.floatValue());
        }
        if (this.priority == 0) {
            request.setPriority(105);
        } else if (this.priority == 1) {
            request.setPriority(104);
        } else if (this.priority == 2) {
            request.setPriority(102);
        } else if (this.priority == 3) {
            request.setPriority(100);
        }
        if (this.googleApiClient.isConnected()) {
            LocationServices.FusedLocationApi.requestLocationUpdates(this.googleApiClient, request, (LocationListener)this);
        }
    }

    @Override
    public void removeLocationUpdates() {
        if (this.googleApiClient.isConnected()) {
            LocationServices.FusedLocationApi.removeLocationUpdates(this.googleApiClient, (LocationListener)this);
        }
    }

    @Override
    public LocationEngine.Type obtainType() {
        return LocationEngine.Type.GOOGLE_PLAY_SERVICES;
    }

    public void onLocationChanged(Location location) {
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onLocationChanged(location);
        }
    }

    private void connect() {
        if (this.googleApiClient != null) {
            if (this.googleApiClient.isConnected()) {
                this.onConnected(null);
            } else {
                this.googleApiClient.connect();
            }
        }
    }
}

