/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.location;

import android.content.Context;
import com.mapbox.services.android.telemetry.location.ClasspathChecker;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineSupplier;
import com.mapbox.services.android.telemetry.location.LostLocationEngine;

class LostLocationEngineFactory
implements LocationEngineSupplier {
    private static final String LOST_LOCATION_SERVICES = "com.mapzen.android.lost.api.LocationServices";
    private final ClasspathChecker classpathChecker;

    LostLocationEngineFactory(ClasspathChecker classpathChecker) {
        this.classpathChecker = classpathChecker;
    }

    @Override
    public LocationEngine supply(Context context) {
        return LostLocationEngine.getLocationEngine(context);
    }

    @Override
    public boolean hasDependencyOnClasspath() {
        return this.classpathChecker.hasDependencyOnClasspath(LOST_LOCATION_SERVICES);
    }
}

