/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.utils;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.location.Location;
import android.media.AudioManager;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.mapbox.services.android.telemetry.constants.TelemetryConstants;
import com.mapbox.services.android.telemetry.permissions.PermissionsManager;
import com.mapbox.services.android.telemetry.utils.AudioTypeChain;
import com.mapbox.services.android.telemetry.utils.AudioTypeResolver;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import okio.Buffer;

public class TelemetryUtils {
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", TelemetryConstants.DEFAULT_LOCALE);

    public static String generateCreateDate(Location location) {
        if (location != null) {
            return TelemetryUtils.generateCreateDateFormatted(new Date(location.getTime()));
        }
        return TelemetryUtils.generateCreateDateFormatted(new Date());
    }

    public static String toHumanReadableAscii(String s) {
        int c;
        int length = s.length();
        for (int i = 0; i < length; i += Character.charCount(c)) {
            c = s.codePointAt(i);
            if (c > 31 && c < 127) continue;
            Buffer buffer = new Buffer();
            buffer.writeUtf8(s, 0, i);
            buffer.writeUtf8CodePoint(63);
            for (int j = i + Character.charCount(c); j < length; j += Character.charCount(c)) {
                c = s.codePointAt(j);
                buffer.writeUtf8CodePoint(c > 31 && c < 127 ? c : 63);
            }
            return buffer.readUtf8();
        }
        return s;
    }

    public static String generateCreateDateFormatted(Date date) {
        return dateFormat.format(date);
    }

    public static Location buildLocation(double longitude, double latitude) {
        Location location = new Location(TelemetryUtils.class.getSimpleName());
        location.setLongitude(longitude);
        location.setLatitude(latitude);
        return location;
    }

    public static SharedPreferences getSharedPreferences(Context context) {
        return context.getSharedPreferences("MapboxSharedPreferences", 0);
    }

    public static String getApplicationIdentifier(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return String.format(TelemetryConstants.DEFAULT_LOCALE, "%s/%s/%s", context.getPackageName(), packageInfo.versionName, packageInfo.versionCode);
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String getOrientation(Context context) {
        switch (context.getResources().getConfiguration().orientation) {
            case 2: {
                return "Landscape";
            }
            case 1: {
                return "Portrait";
            }
        }
        return "";
    }

    public static String getApplicationState(Context context) {
        ActivityManager activityManager = (ActivityManager)context.getSystemService("activity");
        List appProcesses = activityManager.getRunningAppProcesses();
        if (appProcesses == null) {
            return "";
        }
        String packageName = context.getPackageName();
        for (ActivityManager.RunningAppProcessInfo appProcess : appProcesses) {
            if (appProcess.importance != 100 || !appProcess.processName.equals(packageName)) continue;
            return "Foreground";
        }
        return "Background";
    }

    public static float getAccesibilityFontScaleSize(Context context) {
        return context.getResources().getConfiguration().fontScale;
    }

    public static String getCellularCarrier(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        String carrierName = manager.getNetworkOperatorName();
        if (TextUtils.isEmpty((CharSequence)carrierName)) {
            carrierName = "";
        }
        return carrierName;
    }

    public static String getCellularNetworkType(Context context) {
        TelephonyManager manager = (TelephonyManager)context.getSystemService("phone");
        switch (manager.getNetworkType()) {
            case 7: {
                return "1xRTT";
            }
            case 4: {
                return "CDMA";
            }
            case 2: {
                return "EDGE";
            }
            case 14: {
                return "EHRPD";
            }
            case 5: {
                return "EVDO_0";
            }
            case 6: {
                return "EVDO_A";
            }
            case 12: {
                return "EVDO_B";
            }
            case 1: {
                return "GPRS";
            }
            case 8: {
                return "HSDPA";
            }
            case 10: {
                return "HSPA";
            }
            case 15: {
                return "HSPAP";
            }
            case 9: {
                return "HSUPA";
            }
            case 11: {
                return "IDEN";
            }
            case 13: {
                return "LTE";
            }
            case 3: {
                return "UMTS";
            }
            case 0: {
                return "Unknown";
            }
        }
        return "";
    }

    public static Boolean getConnectedToWifi(Context context) {
        Boolean isConnectedToWifi = false;
        try {
            WifiInfo wifiInfo;
            WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
            if (PermissionsManager.isPermissionGranted(context, "android.permission.ACCESS_WIFI_STATE") && wifiMgr.isWifiEnabled() && (wifiInfo = wifiMgr.getConnectionInfo()).getNetworkId() != -1) {
                isConnectedToWifi = true;
            }
        }
        catch (Exception exception) {
            isConnectedToWifi = false;
        }
        return isConnectedToWifi;
    }

    public static int getScreenBrightness(Context context) {
        int screenBrightness;
        try {
            screenBrightness = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"screen_brightness");
            screenBrightness = (int)Math.floor(100.0 * (double)screenBrightness / 255.0);
        }
        catch (Settings.SettingNotFoundException exception) {
            screenBrightness = -1;
        }
        return screenBrightness;
    }

    public static int getVolumeLevel(Context context) {
        AudioManager audioManager = (AudioManager)context.getSystemService("audio");
        return (int)Math.floor(100.0 * (double)audioManager.getStreamVolume(3) / (double)audioManager.getStreamMaxVolume(3));
    }

    public static String buildUUID() {
        return UUID.randomUUID().toString();
    }

    public static String obtainAudioType(Context context) {
        AudioTypeChain audioTypeChain = new AudioTypeChain();
        AudioTypeResolver setupChain = audioTypeChain.setup();
        return setupChain.obtainAudioType(context);
    }
}

