/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.service;

import android.app.Service;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.IBinder;
import android.support.annotation.Nullable;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.mapbox.services.android.telemetry.TelemetryLocationReceiver;

public class TelemetryService
extends Service {
    private static final String LOG_TAG = TelemetryService.class.getSimpleName();
    private TelemetryLocationReceiver receiver = null;

    @Nullable
    public IBinder onBind(Intent intent) {
        Log.w((String)LOG_TAG, (String)"The service doesn't support a binder interface.");
        return null;
    }

    public void onCreate() {
        Log.v((String)LOG_TAG, (String)"Create event.");
        this.receiver = new TelemetryLocationReceiver();
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver((BroadcastReceiver)this.receiver, new IntentFilter("com.mapbox.services.android.telemetry.location.TelemetryLocationReceiver"));
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        Log.v((String)LOG_TAG, (String)"Start command event.");
        return 2;
    }

    public void onTaskRemoved(Intent rootIntent) {
        Log.v((String)LOG_TAG, (String)"Task removed event.");
        this.shutdownTelemetryService();
    }

    public void onDestroy() {
        Log.v((String)LOG_TAG, (String)"Destroy event.");
        this.shutdownTelemetryService();
    }

    private void shutdownTelemetryService() {
        try {
            Log.v((String)LOG_TAG, (String)"Unregistering location receiver.");
            LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver((BroadcastReceiver)this.receiver);
        }
        catch (Exception exception) {
            Log.e((String)LOG_TAG, (String)String.format("Unregistering receiver failed: %s.", exception.getMessage()));
        }
    }
}

