/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.services.android.telemetry.location;

import android.content.Context;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.mapbox.services.android.telemetry.location.LocationEngine;
import com.mapbox.services.android.telemetry.location.LocationEngineListener;
import com.mapbox.services.android.telemetry.permissions.PermissionsManager;
import java.lang.ref.WeakReference;

public class AndroidLocationEngine
extends LocationEngine
implements LocationListener {
    private static final String LOG_TAG = AndroidLocationEngine.class.getSimpleName();
    private static final String DEFAULT_PROVIDER = "passive";
    private static final long DEFAULT_MIN_TIME = 0L;
    private static final float DEFAULT_MIN_DISTANCE = 0.0f;
    private static AndroidLocationEngine instance;
    private WeakReference<Context> context;
    private LocationManager locationManager;
    private String currentProvider = null;

    public AndroidLocationEngine(Context context) {
        Log.v((String)LOG_TAG, (String)"Initializing.");
        this.context = new WeakReference<Context>(context);
        this.locationManager = (LocationManager)((Context)this.context.get()).getSystemService("location");
        this.currentProvider = DEFAULT_PROVIDER;
    }

    public static synchronized LocationEngine getLocationEngine(Context context) {
        if (instance == null) {
            instance = new AndroidLocationEngine(context.getApplicationContext());
        }
        return instance;
    }

    @Override
    public void activate() {
        Log.v((String)LOG_TAG, (String)"Activating.");
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onConnected();
        }
    }

    @Override
    public void deactivate() {
        Log.v((String)LOG_TAG, (String)"Deactivating.");
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public Location getLastLocation() {
        if (!TextUtils.isEmpty((CharSequence)this.currentProvider) && PermissionsManager.areLocationPermissionsGranted((Context)this.context.get())) {
            return this.locationManager.getLastKnownLocation(this.currentProvider);
        }
        return null;
    }

    @Override
    public void requestLocationUpdates() {
        if (!TextUtils.isEmpty((CharSequence)this.currentProvider) && PermissionsManager.areLocationPermissionsGranted((Context)this.context.get())) {
            this.locationManager.requestLocationUpdates(this.currentProvider, 0L, 0.0f, (LocationListener)this);
        }
    }

    @Override
    public void setPriority(int priority) {
        super.setPriority(priority);
        this.updateCurrentProvider();
    }

    private void updateCurrentProvider() {
        if (this.priority == 0) {
            this.currentProvider = DEFAULT_PROVIDER;
        } else if (this.priority == 1) {
            this.currentProvider = "network";
        } else if (this.priority == 2) {
            this.currentProvider = "network";
        } else if (this.priority == 3) {
            this.currentProvider = "gps";
        }
        Log.d((String)LOG_TAG, (String)String.format("Priority set to %d (current provider is %s).", this.priority, this.currentProvider));
    }

    @Override
    public void removeLocationUpdates() {
        if (PermissionsManager.areLocationPermissionsGranted((Context)this.context.get())) {
            this.locationManager.removeUpdates((LocationListener)this);
        }
    }

    public void onLocationChanged(Location location) {
        Log.v((String)LOG_TAG, (String)"New location received.");
        for (LocationEngineListener listener : this.locationListeners) {
            listener.onLocationChanged(location);
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
        Log.v((String)LOG_TAG, (String)String.format("Provider %s status changed to %d (current provider is %s).", provider, status, this.currentProvider));
    }

    public void onProviderEnabled(String provider) {
        Log.v((String)LOG_TAG, (String)String.format("Provider %s was enabled (current provider is %s).", provider, this.currentProvider));
    }

    public void onProviderDisabled(String provider) {
        Log.v((String)LOG_TAG, (String)String.format("Provider %s was disabled (current provider is %s).", provider, this.currentProvider));
    }
}

