/*
 * Decompiled with CFR 0.152.
 */
package com.mapbox.mapboxsdk.module.telemetry;

import android.annotation.SuppressLint;
import androidx.annotation.FloatRange;
import com.mapbox.mapboxsdk.module.telemetry.MapBaseEvent;
import com.mapbox.mapboxsdk.module.telemetry.PhoneState;

@SuppressLint(value={"ParcelCreator"})
public class OfflineDownloadEndEvent
extends MapBaseEvent {
    private static final String EVENT_NAME = "map.offlineDownload.end";
    private final Double minZoom;
    private final Double maxZoom;
    private final String shapeForOfflineRegion;
    private String styleURL;
    private String state;
    private long sizeOfResourcesCompleted;
    private long numberOfTilesCompleted;

    OfflineDownloadEndEvent(PhoneState phoneState, String shapeForOfflineRegion, @FloatRange(from=0.0, to=25.5) Double minZoom, @FloatRange(from=0.0, to=25.5) Double maxZoom) {
        super(phoneState);
        this.shapeForOfflineRegion = shapeForOfflineRegion;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
    }

    @Override
    String getEventName() {
        return EVENT_NAME;
    }

    Double getMinZoom() {
        return this.minZoom;
    }

    Double getMaxZoom() {
        return this.maxZoom;
    }

    String getShapeForOfflineRegion() {
        return this.shapeForOfflineRegion;
    }

    String getStyleURL() {
        return this.styleURL;
    }

    void setStyleURL(String styleURL) {
        this.styleURL = styleURL;
    }

    long getSizeOfResourcesCompleted() {
        return this.sizeOfResourcesCompleted;
    }

    void setSizeOfResourcesCompleted(long sizeOfResourcesCompleted) {
        this.sizeOfResourcesCompleted = sizeOfResourcesCompleted;
    }

    long getNumberOfTilesCompleted() {
        return this.numberOfTilesCompleted;
    }

    void setNumberOfTilesCompleted(long numberOfTilesCompleted) {
        this.numberOfTilesCompleted = numberOfTilesCompleted;
    }

    String getState() {
        return this.state;
    }

    void setState(int state) {
        this.state = String.valueOf(state);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OfflineDownloadEndEvent that = (OfflineDownloadEndEvent)((Object)o);
        if (this.sizeOfResourcesCompleted != that.sizeOfResourcesCompleted) {
            return false;
        }
        if (this.numberOfTilesCompleted != that.numberOfTilesCompleted) {
            return false;
        }
        if (this.minZoom != null ? !this.minZoom.equals(that.minZoom) : that.minZoom != null) {
            return false;
        }
        if (this.maxZoom != null ? !this.maxZoom.equals(that.maxZoom) : that.maxZoom != null) {
            return false;
        }
        if (this.shapeForOfflineRegion != null ? !this.shapeForOfflineRegion.equals(that.shapeForOfflineRegion) : that.shapeForOfflineRegion != null) {
            return false;
        }
        if (this.styleURL != null ? !this.styleURL.equals(that.styleURL) : that.styleURL != null) {
            return false;
        }
        return this.state != null ? this.state.equals(that.state) : that.state == null;
    }

    public int hashCode() {
        int result = this.minZoom != null ? this.minZoom.hashCode() : 0;
        result = 31 * result + (this.maxZoom != null ? this.maxZoom.hashCode() : 0);
        result = 31 * result + (this.shapeForOfflineRegion != null ? this.shapeForOfflineRegion.hashCode() : 0);
        result = 31 * result + (this.styleURL != null ? this.styleURL.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + (int)(this.sizeOfResourcesCompleted ^ this.sizeOfResourcesCompleted >>> 32);
        result = 31 * result + (int)(this.numberOfTilesCompleted ^ this.numberOfTilesCompleted >>> 32);
        return result;
    }

    public String toString() {
        return "OfflineDownloadEndEvent{, minZoom=" + this.minZoom + ", maxZoom=" + this.maxZoom + ", shapeForOfflineRegion='" + this.shapeForOfflineRegion + '\'' + ", styleURL='" + this.styleURL + '\'' + ", sizeOfResourcesCompleted=" + this.sizeOfResourcesCompleted + ", numberOfTilesCompleted=" + this.numberOfTilesCompleted + ", state=" + this.state + '}';
    }
}

